/*
 * Decompiled with CFR 0.152.
 */
package com.animationtransmog;

import com.animationtransmog.AnimationTypes;
import com.animationtransmog.config.AnimationTransmogConfig;
import com.animationtransmog.config.AnimationTransmogConfigManager;
import com.animationtransmog.effect.AnimationPlayerController;
import com.animationtransmog.effect.DatabaseManager;
import com.animationtransmog.effect.PlayerController;
import com.google.inject.Provides;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Animation Transmog")
public class AnimationTransmogPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AnimationTransmogPlugin.class);
    @Inject
    private AnimationTransmogConfig config;
    @Inject
    private Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private OkHttpClient okHttpClient;
    boolean configChanged = true;
    boolean welcomeMessagePlayed = false;
    DatabaseManager dbManager;
    AnimationTransmogConfigManager configManager;
    AnimationTypes animationTypes;
    AnimationPlayerController animationPlayerController;
    HashMap<String, PlayerController> players;
    String messageFromAnotherThread = "";

    protected void startUp() {
        log.info("Animation Transmog started!");
        this.dbManager = new DatabaseManager(this.okHttpClient);
        this.configManager = new AnimationTransmogConfigManager(this.config);
        this.animationTypes = new AnimationTypes();
        this.animationPlayerController = new AnimationPlayerController(this.configManager);
        this.players = new HashMap();
    }

    protected void shutDown() {
        log.info("Animation Transmog stopped!");
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned e) {
        String playerName = e.getActor().getName();
        this.addNewPlayer(playerName, e.getActor());
    }

    void addNewPlayer(String playerName, Actor actor) {
        if (playerName == null) {
            return;
        }
        if (!this.configManager.getCanUseDB() || actor == this.client.getLocalPlayer()) {
            if (actor != this.client.getLocalPlayer()) {
                return;
            }
            HashMap<String, String> settings2 = this.getLocalSettings();
            PlayerController playerController = new PlayerController(this.animationTypes, actor, this.client, settings2);
            this.players.put(playerName, playerController);
            return;
        }
        if (!this.players.containsKey(playerName)) {
            this.dbManager.getSettings(playerName, settings -> {
                if (settings.size() == 0) {
                    this.players.put(playerName, null);
                    return;
                }
                PlayerController playerController = new PlayerController(this.animationTypes, actor, this.client, (HashMap<String, String>)settings);
                this.players.put(playerName, playerController);
            });
        } else {
            PlayerController playerController = this.players.get(playerName);
            if (playerController == null) {
                return;
            }
            playerController.effectController.setPlayer(actor, this.client);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.animationPlayerController.setPlayer((Actor)this.client.getLocalPlayer(), this.client);
            if (!this.configManager.getCanUseDB() && !this.welcomeMessagePlayed) {
                this.welcomeMessagePlayed = true;
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Animation Transmog Plugin: To enable new functionality, please go to the plugin settings and check \"Enable Multiplayer\" on.").build()).build());
            }
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        Player local;
        if (!this.messageFromAnotherThread.equals("")) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", this.messageFromAnotherThread, null);
            this.messageFromAnotherThread = "";
        }
        if ((local = this.client.getLocalPlayer()) == null || local.getName() == null) {
            return;
        }
        this.animationPlayerController.update();
        for (PlayerController player : this.players.values()) {
            if (player == null) continue;
            player.effectController.updateTimer();
        }
        if (this.configChanged) {
            this.configChanged = false;
            HashMap<String, String> settings = this.updateSettings();
            if (!this.players.containsKey(local.getName())) {
                this.addNewPlayer(local.getName(), (Actor)this.client.getLocalPlayer());
            } else {
                this.players.get(local.getName()).setSettings(settings);
            }
        }
    }

    @Subscribe
    public void onBeforeRender(BeforeRender event) {
        for (PlayerController player : this.players.values()) {
            if (player == null) continue;
            player.effectController.onBeforeRender();
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged e) {
        Actor playerActor = e.getActor();
        PlayerController playerController = this.players.get(playerActor.getName());
        if (playerController == null) {
            return;
        }
        playerController.effectController.onChange();
    }

    @Provides
    AnimationTransmogConfig provideConfig(ConfigManager configManager) {
        return (AnimationTransmogConfig)configManager.getConfig(AnimationTransmogConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (e.getGroup().equals("animationtransmog")) {
            this.configChanged = true;
        }
    }

    HashMap<String, String> updateSettings() {
        HashMap<String, String> newSettings = this.getLocalSettings();
        String playerName = this.client.getLocalPlayer().getName();
        if (this.configManager.getCanUseDB()) {
            this.dbManager.setSettings(playerName, newSettings);
        }
        return newSettings;
    }

    HashMap<String, String> getLocalSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        Object[] keys = this.configManager.configGetters.keySet().toArray();
        for (int i = 0; i < this.configManager.configGetters.size(); ++i) {
            String key = (String)keys[i];
            String value = this.configManager.configGetters.get(key).get();
            settings.put(key, value);
        }
        return settings;
    }
}

