/*
 * Decompiled with CFR 0.152.
 */
package com.cbowanimationstall;

import com.cbowanimationstall.CbowAnimationStallConfig;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.events.AnimationChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Cbow Animation Stall", description="Revert crossbow animation during PVM, uses the original/PVP variant with an animation stall")
public class CbowAnimationStallPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CbowAnimationStallPlugin.class);
    private static final int CROSSBOW_PVM_ANIMATION = 7552;
    private static final int CROSSBOW_PVP_ANIMATION = 4230;
    @Inject
    private Client client;
    @Inject
    private CbowAnimationStallConfig config;

    @Subscribe(priority=-1001.0f)
    public void onAnimationChanged(AnimationChanged e) {
        if (this.client.getVarbitValue(8121) == 1) {
            return;
        }
        Actor actor = e.getActor();
        if (this.config.localPlayerOnly() && !actor.equals(this.client.getLocalPlayer())) {
            return;
        }
        if (actor.getAnimation() == 7552) {
            actor.setAnimation(4230);
        }
    }

    @Provides
    CbowAnimationStallConfig provideConfig(ConfigManager configManager) {
        return (CbowAnimationStallConfig)configManager.getConfig(CbowAnimationStallConfig.class);
    }
}

