/*
 * Decompiled with CFR 0.152.
 */
package bluelightzero;

import bluelightzero.InfoOverlay;
import bluelightzero.UnresponsiveCursorConfig;
import com.google.inject.Provides;
import java.awt.Cursor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ExecutorServiceExceptionLogger;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Unresponsive Cursor")
public class UnresponsiveCursorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(UnresponsiveCursorPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientUI clientUI;
    @Inject
    private WorldService worldService;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private InfoOverlay infoOverlay;
    private static final int TICK_TIME = 600;
    private static final int PING_SLOW_INTERVAL = 6000;
    private static final int PING_FAST_INTERVAL = 200;
    private boolean wasLagging = false;
    private Cursor replacedCursor = null;
    private long lastTickTime;
    private ScheduledExecutorService scheduledExecutorService;
    private static final int TIMEOUT = 1000;
    private static final int PORT = 43594;
    private long lastPingTime;
    private final LinkedList<Long> recentPings = new LinkedList();
    private long lastPongTime;
    private long lastPingLatency;
    @Inject
    private UnresponsiveCursorConfig config;

    protected void startUp() throws Exception {
        this.scheduledExecutorService = new ExecutorServiceExceptionLogger(Executors.newSingleThreadScheduledExecutor());
        this.overlayManager.add((Overlay)this.infoOverlay);
    }

    protected void shutDown() throws Exception {
        this.scheduledExecutorService.shutdown();
        this.scheduledExecutorService = null;
        this.overlayManager.remove((Overlay)this.infoOverlay);
        if (this.wasLagging) {
            this.wasLagging = false;
            this.clientUI.resetCursor();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN && this.wasLagging) {
            this.wasLagging = false;
            this.clientUI.resetCursor();
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.lastTickTime = new Date().getTime();
    }

    private void pingCurrentWorld() {
        try {
            long after;
            WorldResult worldResult = this.worldService.getWorlds();
            if (worldResult == null || this.client.getGameState() != GameState.LOGGED_IN) {
                return;
            }
            World currentWorld = worldResult.findWorld(this.client.getWorld());
            if (currentWorld == null) {
                return;
            }
            String address = currentWorld.getAddress();
            Socket socket = new Socket();
            InetAddress inetAddress = InetAddress.getByName(address);
            long before = new Date().getTime();
            socket.connect(new InetSocketAddress(inetAddress, 43594), 1000);
            this.lastPongTime = after = new Date().getTime();
            this.lastPingLatency = after - before;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean hasBeenRecentPing() {
        long now = new Date().getTime();
        for (Long pingTime : this.recentPings) {
            long timeSinceRecentPing = now - pingTime;
            if (timeSinceRecentPing >= 6000L || timeSinceRecentPing <= this.lastPingLatency) continue;
            return true;
        }
        return false;
    }

    @Subscribe
    public void onClientTick(ClientTick tick) {
        boolean isCustomCursor;
        boolean isLagging;
        long now = new Date().getTime();
        long timeSinceLastTick = now - this.lastTickTime;
        boolean bl = isLagging = timeSinceLastTick > (long)(600 + this.config.lagThreshold());
        if (this.config.enableText()) {
            if (isLagging && this.hasBeenRecentPing()) {
                long timeSincePong = now - this.lastPongTime;
                if (timeSincePong > 200L + this.lastPingLatency) {
                    this.infoOverlay.setText(this.config.connectionLostText());
                    this.infoOverlay.setColor(this.config.connectionLostTextColor());
                } else {
                    this.infoOverlay.setText(this.config.serverLagText());
                    this.infoOverlay.setColor(this.config.serverLagTextColor());
                }
            } else {
                this.infoOverlay.clearText();
            }
        } else {
            this.infoOverlay.clearText();
        }
        boolean isDefaultCursor = this.clientUI.getCurrentCursor().getType() == 0;
        boolean bl2 = isCustomCursor = this.clientUI.getCurrentCursor().getType() == -1;
        if (isLagging && !this.wasLagging) {
            if (isDefaultCursor) {
                this.replacedCursor = null;
                this.clientUI.setCursor(Cursor.getPredefinedCursor(3));
                this.wasLagging = true;
            } else if (isCustomCursor) {
                this.replacedCursor = this.clientUI.getCurrentCursor();
                this.clientUI.setCursor(Cursor.getPredefinedCursor(3));
                this.wasLagging = true;
            }
        } else if (!isLagging && this.wasLagging) {
            if (this.replacedCursor != null) {
                this.clientUI.setCursor(this.replacedCursor);
            } else {
                this.clientUI.resetCursor();
            }
            this.wasLagging = false;
        }
        long timeSincePing = now - this.lastPingTime;
        if (isLagging) {
            if (timeSincePing > 200L) {
                this.scheduledExecutorService.execute(this::pingCurrentWorld);
                this.lastPingTime = now;
                this.recentPings.add(now);
            }
        } else if (timeSincePing > 6000L) {
            this.scheduledExecutorService.execute(this::pingCurrentWorld);
            this.lastPingTime = now;
            this.recentPings.add(now);
        }
        if (this.recentPings.size() > 10) {
            this.recentPings.remove();
        }
    }

    @Provides
    UnresponsiveCursorConfig provideConfig(ConfigManager configManager) {
        return (UnresponsiveCursorConfig)configManager.getConfig(UnresponsiveCursorConfig.class);
    }
}

