/*
 * Decompiled with CFR 0.152.
 */
package bluelightzero;

import bluelightzero.UnresponsiveCursorConfig;
import bluelightzero.UnresponsiveCursorPlugin;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class InfoOverlay
extends Overlay {
    private final Client client;
    private final UnresponsiveCursorPlugin plugin;
    private final UnresponsiveCursorConfig config;
    private String text = "";
    private Color color;

    @Inject
    private InfoOverlay(Client client, UnresponsiveCursorPlugin plugin, UnresponsiveCursorConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
        this.setPriority(OverlayPriority.HIGH);
        this.setPosition(OverlayPosition.TOOLTIP);
    }

    public void clearText() {
        this.text = "";
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.text.isEmpty()) {
            int textWidth = graphics.getFontMetrics().stringWidth(this.text);
            int textHeight = graphics.getFontMetrics().getAscent() - graphics.getFontMetrics().getDescent();
            Point mousePosition = this.client.getMouseCanvasPosition();
            Point textPosition = new Point(mousePosition.getX() + 16, mousePosition.getY() + textHeight / 2);
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textPosition, (String)this.text, (Color)this.color);
        }
        return null;
    }
}

