/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.charges.triggers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TriggerChatMessage {
    @Nonnull
    public final Pattern message;
    public boolean menu_target;
    public boolean equipped;
    public boolean multiple_charges;
    public boolean increase_dynamically;
    public boolean decrease_dynamically;
    public boolean use_difference;
    public boolean notification;
    public List<Integer> specific_items = new ArrayList<Integer>();
    @Nullable
    public Pattern ignore_message;
    @Nullable
    public Consumer<String> extra_consumer;
    @Nullable
    public Integer fixed_charges;
    @Nullable
    public Integer decrease_charges;
    @Nullable
    public Integer increase_charges;
    @Nullable
    public String notification_message;

    public TriggerChatMessage(@Nonnull String message) {
        this.message = Pattern.compile(message);
    }

    public TriggerChatMessage fixedCharges(int charges) {
        this.fixed_charges = charges;
        return this;
    }

    public TriggerChatMessage onItemClick() {
        this.menu_target = true;
        return this;
    }

    public TriggerChatMessage increaseCharges(int charges) {
        this.increase_charges = charges;
        return this;
    }

    public TriggerChatMessage decreaseCharges(int charges) {
        this.decrease_charges = charges;
        return this;
    }

    public TriggerChatMessage equipped() {
        this.equipped = true;
        return this;
    }

    public TriggerChatMessage multipleCharges() {
        this.multiple_charges = true;
        return this;
    }

    public TriggerChatMessage increaseDynamically() {
        this.increase_dynamically = true;
        return this;
    }

    public TriggerChatMessage decreaseDynamically() {
        this.decrease_dynamically = true;
        return this;
    }

    public TriggerChatMessage notification() {
        this.notification = true;
        return this;
    }

    public TriggerChatMessage notification(String message) {
        this.notification = true;
        this.notification_message = message;
        return this;
    }

    public TriggerChatMessage useDifference() {
        this.use_difference = true;
        return this;
    }

    public TriggerChatMessage ignore(String ignore_message) {
        this.ignore_message = Pattern.compile(ignore_message);
        return this;
    }

    public TriggerChatMessage specificItem(int ... item_ids) {
        for (int item_id : item_ids) {
            this.specific_items.add(item_id);
        }
        return this;
    }

    public TriggerChatMessage extraConsumer(Consumer<String> extra_consumer) {
        this.extra_consumer = extra_consumer;
        return this;
    }
}

