/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.charges.store;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;

public class Store {
    private int gametick = 0;
    private int gametick_before = 0;
    @Nullable
    public ItemContainer inventory = null;
    @Nullable
    public ItemContainer equipment = null;
    @Nullable
    public Item[] inventory_items = null;
    @Nullable
    public Item[] bank_items = null;
    public final List<String[]> menu_entries = new ArrayList<String[]>();

    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.INVENTORY.getId()) {
            this.inventory = event.getItemContainer();
        } else if (event.getContainerId() == InventoryID.EQUIPMENT.getId()) {
            this.equipment = event.getItemContainer();
        }
    }

    public void onInventoryItemsChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.INVENTORY.getId()) {
            this.inventory_items = event.getItemContainer().getItems();
        }
    }

    public void onBankItemsChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.BANK.getId()) {
            this.bank_items = event.getItemContainer().getItems();
        }
    }

    public void onMenuOptionClicked(MenuOptionClicked event) {
        String menu_target = event.getMenuTarget().replaceAll("</?col.*?>", "");
        String menu_option = event.getMenuOption();
        if (menu_target.isEmpty() || menu_option == null || menu_option.isEmpty()) {
            return;
        }
        if (this.gametick >= this.gametick_before + 2) {
            this.gametick = 0;
            this.gametick_before = 0;
            this.menu_entries.clear();
        }
        this.menu_entries.add(new String[]{menu_target, menu_option});
    }

    public void onGameTick(GameTick ignored) {
        ++this.gametick;
    }
}

