/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.charges.item;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Hitsplat;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import tictac7x.charges.ChargesImprovedConfig;
import tictac7x.charges.ChargesImprovedPlugin;
import tictac7x.charges.store.ItemActivity;
import tictac7x.charges.store.ItemKey;
import tictac7x.charges.store.Store;
import tictac7x.charges.triggers.TriggerAnimation;
import tictac7x.charges.triggers.TriggerChatMessage;
import tictac7x.charges.triggers.TriggerGraphic;
import tictac7x.charges.triggers.TriggerHitsplat;
import tictac7x.charges.triggers.TriggerItem;
import tictac7x.charges.triggers.TriggerItemContainer;
import tictac7x.charges.triggers.TriggerReset;
import tictac7x.charges.triggers.TriggerStat;
import tictac7x.charges.triggers.TriggerWidget;

public class ChargedItem
extends InfoBox {
    public final ItemKey infobox_id;
    public int item_id;
    protected final Client client;
    protected final ClientThread client_thread;
    protected final ItemManager items;
    protected final InfoBoxManager infoboxes;
    protected final ConfigManager configs;
    protected final ChatMessageManager chat_messages;
    protected final Notifier notifier;
    protected final ChargesImprovedConfig config;
    protected final Store store;
    @Nullable
    protected String config_key;
    @Nullable
    protected String[] extra_config_keys;
    @Nullable
    protected TriggerChatMessage[] triggers_chat_messages;
    @Nullable
    protected TriggerAnimation[] triggers_animations;
    @Nullable
    protected TriggerGraphic[] triggers_graphics;
    @Nullable
    protected TriggerHitsplat[] triggers_hitsplats;
    @Nullable
    protected TriggerItem[] triggers_items;
    @Nullable
    protected TriggerWidget[] triggers_widgets;
    @Nullable
    protected TriggerReset[] triggers_resets;
    @Nullable
    protected TriggerItemContainer[] triggers_item_containers;
    @Nullable
    protected TriggerStat[] triggers_stats;
    protected boolean in_equipment = false;
    private boolean in_inventory = false;
    protected boolean needs_to_be_equipped_for_infobox;
    private boolean is_negative;
    protected int charges = -1;
    private String tooltip;
    private boolean render = false;
    @Nullable
    public Integer negative_full_charges;
    public boolean zero_charges_is_positive = false;

    public ChargedItem(ItemKey infobox_id, int item_id, Client client, ClientThread client_thread, ConfigManager configs, ItemManager items, InfoBoxManager infoboxes, ChatMessageManager chat_messages, Notifier notifier, ChargesImprovedConfig config, Store store, Plugin plugin) {
        super((BufferedImage)items.getImage(item_id), plugin);
        this.infobox_id = infobox_id;
        this.item_id = item_id;
        this.client = client;
        this.client_thread = client_thread;
        this.configs = configs;
        this.items = items;
        this.infoboxes = infoboxes;
        this.chat_messages = chat_messages;
        this.notifier = notifier;
        this.config = config;
        this.store = store;
        client_thread.invokeLater(() -> {
            this.loadChargesFromConfig();
            this.updateTooltip();
            this.onChargesUpdated();
        });
    }

    public String getName() {
        return super.getName() + "_" + this.item_id;
    }

    public String getText() {
        return ChargesImprovedPlugin.getChargesMinified(this.charges);
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Color getTextColor() {
        if (this.charges == -1) {
            return this.config.getColorUnknown();
        }
        if (this.charges == 0 && !this.zero_charges_is_positive || this.negative_full_charges != null && this.charges == this.negative_full_charges || this.needs_to_be_equipped_for_infobox && !this.in_equipment || this.is_negative || this.isDeactivated()) {
            return this.config.getColorEmpty();
        }
        return this.config.getColorDefault();
    }

    public TriggerItem[] getTriggersItems() {
        return this.triggers_items;
    }

    public boolean inEquipment() {
        return this.in_equipment;
    }

    private boolean isAllowed() {
        return !this.config.getHiddenInfoboxes().contains((Object)this.infobox_id);
    }

    public boolean isNegative() {
        return this.is_negative;
    }

    public boolean needsToBeEquipped() {
        return this.needs_to_be_equipped_for_infobox;
    }

    public boolean render() {
        return this.config.showInfoboxes() && this.isAllowed() && this.render && this.charges != -2;
    }

    public int getCharges() {
        return this.charges;
    }

    public void onStatChanged(StatChanged event) {
        if (this.triggers_stats == null) {
            return;
        }
        for (TriggerStat triggerStat : this.triggers_stats) {
            if (triggerStat.skill != event.getSkill() || triggerStat.extra_config.isPresent() && !this.configs.getConfiguration("tictac7x-charges", triggerStat.extra_config.get()[0]).equals(triggerStat.extra_config.get()[1]) || !triggerStat.discharges.isPresent()) continue;
            this.decreaseCharges(triggerStat.discharges.get());
        }
    }

    public void onVarbitChanged(VarbitChanged event) {
        if (this.triggers_items == null) {
            return;
        }
        for (TriggerItem trigger_item : this.triggers_items) {
            int charges;
            if (trigger_item.varbit_id == null || trigger_item.varbit_value == null || event.getVarbitId() != trigger_item.varbit_id.intValue() || event.getValue() != trigger_item.varbit_value.intValue()) continue;
            if (trigger_item.fixed_charges != null) {
                charges = 0;
                charges += this.store.inventory != null ? this.store.inventory.count(trigger_item.item_id) * trigger_item.fixed_charges : 0;
                this.charges = charges += this.store.equipment != null ? this.store.equipment.count(trigger_item.item_id) * trigger_item.fixed_charges : 0;
            } else if (trigger_item.quantity_charges) {
                charges = 0;
                charges += this.store.inventory != null ? this.store.inventory.count(trigger_item.item_id) : 0;
                this.charges = charges += this.store.equipment != null ? this.store.equipment.count(trigger_item.item_id) : 0;
            }
            this.is_negative = trigger_item.is_negative;
        }
    }

    private int getInventoryItemsDifference(ItemContainerChanged event) {
        if (event.getItemContainer().getId() != InventoryID.INVENTORY.getId() || this.store.inventory_items == null) {
            return 0;
        }
        return this.itemsDifference(this.store.inventory_items, event.getItemContainer().getItems());
    }

    private int getBankItemsDifference(ItemContainerChanged event) {
        int difference = 0;
        if (event.getContainerId() == InventoryID.BANK.getId() && this.store.bank_items != null) {
            HashMap<Integer, Integer> differences = new HashMap<Integer, Integer>();
            for (Item new_item : event.getItemContainer().getItems()) {
                differences.put(new_item.getId(), new_item.getQuantity());
                this.items.getItemComposition(0).getPlaceholderId();
            }
            for (Item old_item : this.store.bank_items) {
                differences.put(old_item.getId(), differences.getOrDefault(old_item.getId(), 0) - old_item.getQuantity());
            }
            for (Map.Entry entry : differences.entrySet()) {
                if ((Integer)entry.getValue() <= 0) continue;
                difference += ((Integer)entry.getValue()).intValue();
            }
        }
        return difference;
    }

    public void onItemContainersChanged(ItemContainerChanged event) {
        if (event.getItemContainer() == null) {
            return;
        }
        int inventory_items_difference = this.getInventoryItemsDifference(event);
        int bank_items_difference = this.getBankItemsDifference(event);
        if (this.triggers_item_containers != null) {
            for (TriggerItemContainer trigger_item_container : this.triggers_item_containers) {
                if (trigger_item_container.inventory_id != event.getContainerId() || trigger_item_container.menu_target != null && !this.inMenuTargets(trigger_item_container.menu_target) || trigger_item_container.menu_option != null && !this.inMenuOptions(trigger_item_container.menu_option)) continue;
                if (trigger_item_container.fixed_charges != null) {
                    this.setCharges(trigger_item_container.fixed_charges);
                    break;
                }
                if (trigger_item_container.increase_by_inventory_difference) {
                    this.increaseCharges(inventory_items_difference);
                    break;
                }
                if (trigger_item_container.decrease_by_bank_difference) {
                    this.decreaseCharges(bank_items_difference);
                    break;
                }
                if (event.getItemContainer() == null) continue;
                this.setCharges(event.getItemContainer().count());
                break;
            }
        }
        if (this.triggers_items == null) {
            return;
        }
        boolean in_inventory = false;
        boolean in_equipment = false;
        boolean render = false;
        Integer charges = null;
        for (TriggerItem trigger_item : this.triggers_items) {
            boolean in_equipment_item;
            if (trigger_item.varbit_id != null && trigger_item.varbit_value != null && this.client.getVarbitValue(trigger_item.varbit_id.intValue()) != trigger_item.varbit_value.intValue()) continue;
            this.is_negative = trigger_item.is_negative;
            boolean in_inventory_item = this.store.inventory != null && this.store.inventory.contains(trigger_item.item_id);
            boolean bl = in_equipment_item = this.store.equipment != null && this.store.equipment.contains(trigger_item.item_id);
            if (!in_equipment_item && !in_inventory_item) continue;
            render = true;
            if (in_inventory_item) {
                in_inventory = true;
            }
            if (in_equipment_item) {
                in_equipment = true;
            }
            if (trigger_item.item_id != this.item_id) {
                this.updateInfobox(trigger_item.item_id);
            }
            if (trigger_item.fixed_charges != null) {
                if (charges == null) {
                    charges = 0;
                }
                charges = charges + (this.store.inventory != null ? this.store.inventory.count(trigger_item.item_id) * trigger_item.fixed_charges : 0);
                charges = charges + (this.store.equipment != null ? this.store.equipment.count(trigger_item.item_id) * trigger_item.fixed_charges : 0);
                continue;
            }
            if (!trigger_item.quantity_charges) continue;
            if (charges == null) {
                charges = 0;
            }
            charges = charges + (this.store.inventory != null ? this.store.inventory.count(trigger_item.item_id) : 0);
            charges = charges + (this.store.equipment != null ? this.store.equipment.count(trigger_item.item_id) : 0);
        }
        this.render = render;
        this.in_inventory = in_inventory;
        this.in_equipment = in_equipment;
        if (charges != null) {
            this.charges = charges;
        }
        this.updateTooltip();
    }

    public void onChatMessage(ChatMessage event) {
        if (this.triggers_chat_messages == null || event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM && event.getType() != ChatMessageType.MESBOX || this.config_key == null || !this.in_inventory && !this.in_equipment) {
            return;
        }
        String message = event.getMessage().replaceAll("</?col.*?>", "").replaceAll("<br>", " ");
        for (TriggerChatMessage chat_message : this.triggers_chat_messages) {
            Matcher ignore_matcher;
            Matcher matcher = chat_message.message.matcher(message);
            if (chat_message.ignore_message != null && (ignore_matcher = chat_message.ignore_message.matcher(message)).find()) {
                return;
            }
            if (!chat_message.specific_items.isEmpty() && !chat_message.specific_items.contains(this.item_id) || !matcher.find() || chat_message.menu_target && !this.inMenuTargets(this.getItemName()) || chat_message.equipped && !this.in_equipment) continue;
            if (chat_message.notification) {
                this.notifier.notify(chat_message.notification_message != null ? chat_message.notification_message : message);
            }
            if (chat_message.increase_charges != null) {
                this.increaseCharges(chat_message.increase_charges);
            } else if (chat_message.decrease_charges != null) {
                this.decreaseCharges(chat_message.decrease_charges);
            } else if (chat_message.fixed_charges != null) {
                this.setCharges(chat_message.fixed_charges);
            } else if (chat_message.multiple_charges) {
                int charges = 0;
                Matcher matcher_multiple = Pattern.compile(".*?(\\d+)").matcher(message);
                while (matcher_multiple.find()) {
                    charges += Integer.parseInt(matcher_multiple.group(1));
                }
                this.setCharges(charges);
            } else if (chat_message.use_difference) {
                int used = Integer.parseInt(matcher.group("used"));
                int total = Integer.parseInt(matcher.group("total"));
                this.setCharges(total - used);
            } else {
                try {
                    int charges = Integer.parseInt(matcher.group("charges").replaceAll(",", "").replaceAll("\\.", ""));
                    if (chat_message.increase_dynamically) {
                        this.increaseCharges(charges);
                    } else if (chat_message.decrease_dynamically) {
                        this.decreaseCharges(charges);
                    } else {
                        this.setCharges(charges);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (chat_message.extra_consumer != null) {
                chat_message.extra_consumer.accept(message);
            }
            if (this.extra_config_keys != null) {
                for (String extra_group : this.extra_config_keys) {
                    try {
                        this.setConfiguration(this.config_key + "_" + extra_group, matcher.group(extra_group).replaceAll(",", ""));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return;
        }
    }

    public void onWidgetLoaded(WidgetLoaded event) {
        if (this.triggers_widgets == null || this.config_key == null) {
            return;
        }
        this.client_thread.invokeLater(() -> {
            for (TriggerWidget trigger_widget : this.triggers_widgets) {
                if (event.getGroupId() != trigger_widget.group_id) continue;
                Widget widget = this.client.getWidget(trigger_widget.group_id, trigger_widget.child_id);
                if (trigger_widget.sub_child_id != null && widget != null) {
                    widget = widget.getChild(trigger_widget.sub_child_id.intValue());
                }
                if (widget == null) continue;
                String message = widget.getText().replaceAll("</?col.*?>", "").replaceAll("<br>", " ");
                Pattern regex = Pattern.compile(trigger_widget.message);
                Matcher matcher = regex.matcher(message);
                if (!matcher.find()) continue;
                if (trigger_widget.charges != null) {
                    this.setCharges(trigger_widget.charges);
                } else if (trigger_widget.consumer != null) {
                    trigger_widget.consumer.accept(message);
                } else if (matcher.group("charges") != null) {
                    int charges = Integer.parseInt(matcher.group("charges").replaceAll(",", ""));
                    if (trigger_widget.increase_dynamically) {
                        this.increaseCharges(charges);
                    } else {
                        this.setCharges(charges);
                    }
                }
                if (this.extra_config_keys == null) continue;
                for (String extra_group : this.extra_config_keys) {
                    String extra = matcher.group(extra_group);
                    if (extra == null) continue;
                    this.setConfiguration(this.config_key + "_" + extra_group, extra);
                }
            }
        });
    }

    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("tictac7x-charges") && event.getKey().equals(this.config_key)) {
            this.charges = Integer.parseInt(event.getNewValue());
        }
    }

    public void onAnimationChanged(AnimationChanged event) {
        if (event.getActor() != this.client.getLocalPlayer()) {
            return;
        }
        if (this.store.inventory == null || this.store.equipment == null || this.triggers_animations == null || this.charges == -1 || this.triggers_items == null) {
            return;
        }
        block0: for (TriggerAnimation trigger_animation : this.triggers_animations) {
            if (trigger_animation.animation_id != event.getActor().getAnimation()) continue;
            if (trigger_animation.unallowed_items != null) {
                for (int item_id : trigger_animation.unallowed_items) {
                    if (this.store.inventory.contains(item_id) || this.store.equipment.contains(item_id)) continue block0;
                }
            }
            if (trigger_animation.equipped && !this.in_equipment || trigger_animation.menu_target != null && !this.inMenuTargets(trigger_animation.menu_target) || trigger_animation.menu_option != null && !this.inMenuOptions(trigger_animation.menu_option)) continue;
            if (trigger_animation.decrease_charges) {
                this.decreaseCharges(trigger_animation.charges);
            } else {
                this.increaseCharges(trigger_animation.charges);
            }
            return;
        }
    }

    public void onGraphicChanged(GraphicChanged event) {
        if (event.getActor() != this.client.getLocalPlayer()) {
            return;
        }
        if (this.store.equipment == null || this.triggers_graphics == null || this.charges == -1 || this.triggers_items == null) {
            return;
        }
        for (TriggerGraphic trigger_graphic : this.triggers_graphics) {
            if (!event.getActor().hasSpotAnim(trigger_graphic.graphic_id) || trigger_graphic.equipped && !this.in_equipment) continue;
            if (trigger_graphic.decrease_charges) {
                this.decreaseCharges(trigger_graphic.charges);
                continue;
            }
            this.increaseCharges(trigger_graphic.charges);
        }
    }

    public void onHitsplatApplied(HitsplatApplied event) {
        if (this.triggers_hitsplats == null || this.store.equipment == null) {
            return;
        }
        Hitsplat hitsplat = event.getHitsplat();
        for (TriggerHitsplat trigger_hitsplat : this.triggers_hitsplats) {
            if (trigger_hitsplat.self && event.getActor() != this.client.getLocalPlayer() || !trigger_hitsplat.self && (event.getActor() == this.client.getLocalPlayer() || hitsplat.isOthers()) || trigger_hitsplat.hitsplat_id != hitsplat.getHitsplatType() || trigger_hitsplat.equipped && !this.in_equipment || trigger_hitsplat.non_zero && hitsplat.getAmount() == 0) continue;
            this.decreaseCharges(trigger_hitsplat.discharges);
        }
    }

    public void resetCharges() {
        if (this.triggers_resets == null) {
            return;
        }
        for (TriggerReset trigger_reset : this.triggers_resets) {
            if (trigger_reset.item_id != null) {
                if (this.item_id != trigger_reset.item_id) continue;
                this.setCharges(trigger_reset.charges);
                continue;
            }
            this.setCharges(trigger_reset.charges);
        }
    }

    private void loadChargesFromConfig() {
        if (this.config_key == null) {
            return;
        }
        try {
            this.charges = Integer.parseInt(this.configs.getConfiguration("tictac7x-charges", this.config_key));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCharges(int charges) {
        if (this.negative_full_charges != null && charges > this.negative_full_charges) {
            return;
        }
        this.charges = charges;
        this.onChargesUpdated();
        if (this.config_key != null) {
            this.setConfiguration(this.config_key, charges);
        }
    }

    private void decreaseCharges(int charges) {
        if (this.charges - charges < 0) {
            return;
        }
        this.setCharges(this.charges - charges);
    }

    public void increaseCharges(int charges) {
        if (this.charges < 0) {
            return;
        }
        this.setCharges(this.charges + charges);
    }

    private void setConfiguration(String key, @Nonnull String value) {
        this.configs.setConfiguration("tictac7x-charges", key, value);
    }

    private void setConfiguration(String key, int value) {
        this.configs.setConfiguration("tictac7x-charges", key, (Object)value);
    }

    private void updateInfobox(int item_id) {
        this.item_id = item_id;
        this.updateTooltip();
        this.setImage((BufferedImage)this.items.getImage(item_id));
        this.infoboxes.updateInfoBoxImage((InfoBox)this);
    }

    private void updateTooltip() {
        this.tooltip = this.items.getItemComposition(this.item_id).getName() + (this.needs_to_be_equipped_for_infobox && !this.in_equipment ? " - Needs to be equipped" : "");
    }

    protected void onChargesUpdated() {
    }

    private int itemsDifference(Item[] items_before, Item[] items_after) {
        int items_before_count = (int)Arrays.stream(items_before).filter(item -> item.getId() != -1).count();
        int items_after_count = (int)Arrays.stream(items_after).filter(item -> item.getId() != -1).count();
        return Math.abs(items_before_count - items_after_count);
    }

    private boolean inMenuTargets(String target) {
        return this.store.menu_entries.stream().anyMatch(entry -> entry[0].contains(target));
    }

    private boolean inMenuOptions(String option) {
        return this.store.menu_entries.stream().anyMatch(entry -> entry[1].equals(option));
    }

    private String getItemName() {
        return this.items.getItemComposition(this.item_id).getName();
    }

    public boolean isDeactivated() {
        Optional<String> configStatus = Optional.ofNullable(this.configs.getConfiguration("tictac7x-charges", this.config_key + "_status"));
        if (!configStatus.isPresent()) {
            return false;
        }
        return configStatus.get().equals(ItemActivity.DEACTIVATED.toString());
    }

    public String getConfigStatusKey() {
        if (this.config_key == null) {
            return null;
        }
        return this.config_key + "_status";
    }
}

