/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.charges;

import com.google.inject.Provides;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tictac7x.charges.ChargedItemsOverlay;
import tictac7x.charges.ChargesImprovedConfig;
import tictac7x.charges.infoboxes.A_CrystalBody;
import tictac7x.charges.infoboxes.A_CrystalHelm;
import tictac7x.charges.infoboxes.A_CrystalLegs;
import tictac7x.charges.infoboxes.C_ArdougneCloak;
import tictac7x.charges.infoboxes.C_Coffin;
import tictac7x.charges.infoboxes.C_MagicCape;
import tictac7x.charges.infoboxes.H_CircletOfWater;
import tictac7x.charges.infoboxes.J_BraceletOfClay;
import tictac7x.charges.infoboxes.J_BraceletOfExpeditious;
import tictac7x.charges.infoboxes.J_BraceletOfFlamtaer;
import tictac7x.charges.infoboxes.J_BraceletOfSlaughter;
import tictac7x.charges.infoboxes.J_Camulet;
import tictac7x.charges.infoboxes.J_CelestialRing;
import tictac7x.charges.infoboxes.J_EscapeCrystal;
import tictac7x.charges.infoboxes.J_RingOfRecoil;
import tictac7x.charges.infoboxes.J_RingOfShadows;
import tictac7x.charges.infoboxes.J_RingOfSuffering;
import tictac7x.charges.infoboxes.J_SlayerRing;
import tictac7x.charges.infoboxes.J_XericsTalisman;
import tictac7x.charges.infoboxes.S_Chronicle;
import tictac7x.charges.infoboxes.S_CrystalShield;
import tictac7x.charges.infoboxes.S_DragonfireShield;
import tictac7x.charges.infoboxes.S_FaladorShield;
import tictac7x.charges.infoboxes.S_KharedstMemoirs;
import tictac7x.charges.infoboxes.U_AshSanctifier;
import tictac7x.charges.infoboxes.U_BoneCrusher;
import tictac7x.charges.infoboxes.U_BottomlessCompostBucket;
import tictac7x.charges.infoboxes.U_FishBarrel;
import tictac7x.charges.infoboxes.U_FungicideSpray;
import tictac7x.charges.infoboxes.U_GemBag;
import tictac7x.charges.infoboxes.U_GricollersCan;
import tictac7x.charges.infoboxes.U_LogBasket;
import tictac7x.charges.infoboxes.U_OgreBellows;
import tictac7x.charges.infoboxes.U_SeedBox;
import tictac7x.charges.infoboxes.U_SoulBearer;
import tictac7x.charges.infoboxes.U_TeleportCrystal;
import tictac7x.charges.infoboxes.U_Waterskin;
import tictac7x.charges.infoboxes.W_Arclight;
import tictac7x.charges.infoboxes.W_BryophytasStaff;
import tictac7x.charges.infoboxes.W_CrystalBow;
import tictac7x.charges.infoboxes.W_CrystalHalberd;
import tictac7x.charges.infoboxes.W_IbansStaff;
import tictac7x.charges.infoboxes.W_PharaohsSceptre;
import tictac7x.charges.infoboxes.W_SanguinestiStaff;
import tictac7x.charges.infoboxes.W_SkullSceptre;
import tictac7x.charges.infoboxes.W_TridentOfTheSeas;
import tictac7x.charges.infoboxes.barrows.AhrimsHood;
import tictac7x.charges.infoboxes.barrows.AhrimsRobeskirt;
import tictac7x.charges.infoboxes.barrows.AhrimsRobetop;
import tictac7x.charges.infoboxes.barrows.AhrimsStaff;
import tictac7x.charges.infoboxes.barrows.DharoksGreataxe;
import tictac7x.charges.infoboxes.barrows.DharoksHelm;
import tictac7x.charges.infoboxes.barrows.DharoksPlatebody;
import tictac7x.charges.infoboxes.barrows.DharoksPlatelegs;
import tictac7x.charges.infoboxes.barrows.GuthansChainskirt;
import tictac7x.charges.infoboxes.barrows.GuthansHelm;
import tictac7x.charges.infoboxes.barrows.GuthansPlatebody;
import tictac7x.charges.infoboxes.barrows.GuthansWarspear;
import tictac7x.charges.infoboxes.barrows.KarilsCoif;
import tictac7x.charges.infoboxes.barrows.KarilsCrossbow;
import tictac7x.charges.infoboxes.barrows.KarilsLeatherskirt;
import tictac7x.charges.infoboxes.barrows.KarilsLeathertop;
import tictac7x.charges.infoboxes.barrows.ToragsHammers;
import tictac7x.charges.infoboxes.barrows.ToragsHelm;
import tictac7x.charges.infoboxes.barrows.ToragsPlatebody;
import tictac7x.charges.infoboxes.barrows.ToragsPlatelegs;
import tictac7x.charges.infoboxes.barrows.VeracsBrassard;
import tictac7x.charges.infoboxes.barrows.VeracsFlail;
import tictac7x.charges.infoboxes.barrows.VeracsHelm;
import tictac7x.charges.infoboxes.barrows.VeracsPlateskirt;
import tictac7x.charges.item.ChargedItem;
import tictac7x.charges.store.Store;

@PluginDescriptor(name="Item Charges Improved", description="Show charges of various items", tags={"charges", "barrows", "bracelet", "ring", "xeric", "talisman", "book", "chronicle", "shield", "ash", "bone", "bottomless", "bucket", "fish", "gricoller", "can", "soul", "arclight", "bryophyta", "staff", "iban", "pharaoh", "sceptre", "skull", "sanguinesti", "trident", "dragonfire", "circlet", "camulet"})
public class ChargesImprovedPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ChargesImprovedPlugin.class);
    private final String plugin_version = "v0.3.2";
    private final String plugin_message = "<colHIGHLIGHT>Item Charges Improved v0.3.2:<br><colHIGHLIGHT>* Gem bag added.<br><colHIGHLIGHT>* Seed box added.<br><colHIGHLIGHT>* Ring of shadows added.<br><colHIGHLIGHT>* Crystal armor added.<br><colHIGHLIGHT>* Crystal halberd added.";
    private final int VARBIT_MINUTES = 8354;
    @Inject
    private Client client;
    @Inject
    private ClientThread client_thread;
    @Inject
    private ItemManager items;
    @Inject
    private ConfigManager configs;
    @Inject
    private InfoBoxManager infoboxes;
    @Inject
    private OverlayManager overlays;
    @Inject
    private ChargesImprovedConfig config;
    @Inject
    private ChatMessageManager chat_messages;
    @Inject
    private Notifier notifier;
    private Store store;
    private ChargedItemsOverlay overlay_charged_items;
    private ChargedItem[] infoboxes_charged_items;
    private final ZoneId timezone = ZoneId.of("Europe/London");

    @Provides
    ChargesImprovedConfig provideConfig(ConfigManager configManager) {
        return (ChargesImprovedConfig)configManager.getConfig(ChargesImprovedConfig.class);
    }

    protected void startUp() {
        this.store = new Store();
        this.infoboxes_charged_items = new ChargedItem[]{new W_Arclight(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new W_TridentOfTheSeas(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new W_SkullSceptre(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new W_IbansStaff(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new W_PharaohsSceptre(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new W_BryophytasStaff(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new W_SanguinestiStaff(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new W_CrystalBow(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new W_CrystalHalberd(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new S_KharedstMemoirs(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new S_Chronicle(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new S_CrystalShield(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new S_FaladorShield(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new S_DragonfireShield(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new J_BraceletOfClay(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new J_BraceletOfExpeditious(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new J_BraceletOfFlamtaer(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new J_BraceletOfSlaughter(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new J_CelestialRing(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new J_EscapeCrystal(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new J_RingOfRecoil(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new J_RingOfSuffering(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new J_SlayerRing(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new J_XericsTalisman(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new J_Camulet(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new J_RingOfShadows(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new H_CircletOfWater(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new C_ArdougneCloak(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new C_Coffin(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new C_MagicCape(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new U_AshSanctifier(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new U_BoneCrusher(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new U_BottomlessCompostBucket(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new U_FishBarrel(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new U_GemBag(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new U_FungicideSpray(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new U_GricollersCan(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new U_SeedBox(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new U_SoulBearer(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new U_TeleportCrystal(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new U_Waterskin(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new U_OgreBellows(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new U_LogBasket(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new A_CrystalBody(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new A_CrystalHelm(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new A_CrystalLegs(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new AhrimsHood(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new AhrimsRobetop(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new AhrimsRobeskirt(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new AhrimsStaff(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new DharoksHelm(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new DharoksPlatebody(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new DharoksPlatelegs(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new DharoksGreataxe(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new GuthansHelm(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new GuthansPlatebody(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new GuthansChainskirt(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new GuthansWarspear(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new KarilsCoif(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new KarilsLeathertop(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new KarilsLeatherskirt(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new KarilsCrossbow(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new ToragsHelm(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new ToragsPlatebody(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new ToragsPlatelegs(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new ToragsHammers(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new VeracsHelm(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new VeracsBrassard(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new VeracsPlateskirt(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this), new VeracsFlail(this.client, this.client_thread, this.configs, this.items, this.infoboxes, this.chat_messages, this.notifier, this.config, this.store, this)};
        this.overlay_charged_items = new ChargedItemsOverlay(this.client, this.config, this.infoboxes_charged_items);
        this.overlays.add((Overlay)this.overlay_charged_items);
        Arrays.stream(this.infoboxes_charged_items).forEach(infobox -> this.infoboxes.addInfoBox((InfoBox)infobox));
    }

    protected void shutDown() {
        this.overlays.remove((Overlay)this.overlay_charged_items);
        Arrays.stream(this.infoboxes_charged_items).forEach(infobox -> this.infoboxes.removeInfoBox((InfoBox)infobox));
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        this.store.onItemContainerChanged(event);
        for (ChargedItem infobox : this.infoboxes_charged_items) {
            infobox.onItemContainersChanged(event);
        }
        this.store.onInventoryItemsChanged(event);
        this.store.onBankItemsChanged(event);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Arrays.stream(this.infoboxes_charged_items).forEach(infobox -> infobox.onChatMessage(event));
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        Arrays.stream(this.infoboxes_charged_items).forEach(infobox -> infobox.onAnimationChanged(event));
    }

    @Subscribe
    public void onGraphicChanged(GraphicChanged event) {
        Arrays.stream(this.infoboxes_charged_items).forEach(infobox -> infobox.onGraphicChanged(event));
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        Arrays.stream(this.infoboxes_charged_items).forEach(infobox -> infobox.onConfigChanged(event));
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        Arrays.stream(this.infoboxes_charged_items).forEach(infobox -> infobox.onHitsplatApplied(event));
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        Arrays.stream(this.infoboxes_charged_items).forEach(infobox -> infobox.onWidgetLoaded(event));
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        this.store.onMenuOptionClicked(event);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGING_IN) {
            this.checkForChargesReset();
        }
        if (event.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (!this.config.getVersion().equals("v0.3.2")) {
            this.configs.setConfiguration("tictac7x-charges", "version", "v0.3.2");
            this.chat_messages.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage("<colHIGHLIGHT>Item Charges Improved v0.3.2:<br><colHIGHLIGHT>* Gem bag added.<br><colHIGHLIGHT>* Seed box added.<br><colHIGHLIGHT>* Ring of shadows added.<br><colHIGHLIGHT>* Crystal armor added.<br><colHIGHLIGHT>* Crystal halberd added.").build());
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        Arrays.stream(this.infoboxes_charged_items).forEach(infobox -> infobox.onStatChanged(event));
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        Arrays.stream(this.infoboxes_charged_items).forEach(infobox -> infobox.onVarbitChanged(event));
        if (event.getVarbitId() == 8354 && this.client.getGameState() == GameState.LOGGED_IN && event.getValue() == 0) {
            this.checkForChargesReset();
        }
    }

    @Subscribe
    public void onGameTick(GameTick gametick) {
        this.store.onGameTick(gametick);
    }

    private void checkForChargesReset() {
        String date = LocalDateTime.now(this.timezone).format(DateTimeFormatter.ISO_LOCAL_DATE);
        if (date.equals(this.config.getResetDate())) {
            return;
        }
        this.configs.setConfiguration("tictac7x-charges", "date", date);
        Arrays.stream(this.infoboxes_charged_items).forEach(infobox -> infobox.resetCharges());
    }

    public static String getChargesMinified(int charges) {
        if (charges == -2) {
            return "\u221e";
        }
        if (charges == -1) {
            return "?";
        }
        if (charges < 1000) {
            return String.valueOf(charges);
        }
        if (charges >= 1000000) {
            return charges / 1000000 + "M";
        }
        int thousands = charges / 1000;
        int hundreds = Math.min((charges % 1000 + 50) / 100, 9);
        return thousands + (String)(thousands < 10 && hundreds > 0 ? "." + hundreds : "") + "K";
    }
}

