/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.charges;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.runelite.api.Client;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;
import tictac7x.charges.ChargesImprovedConfig;
import tictac7x.charges.ChargesImprovedPlugin;
import tictac7x.charges.item.ChargedItem;
import tictac7x.charges.triggers.TriggerItem;

public class ChargedItemsOverlay
extends WidgetItemOverlay {
    private final Client client;
    private final ChargesImprovedConfig config;
    private final ChargedItem[] infoboxes_charged_items;

    public ChargedItemsOverlay(Client client, ChargesImprovedConfig config, ChargedItem[] infoboxes_charged_items) {
        this.client = client;
        this.config = config;
        this.infoboxes_charged_items = infoboxes_charged_items;
        this.showOnInventory();
        this.showOnEquipment();
        this.showOnInterfaces(new int[]{84});
        this.showOnBank();
    }

    private boolean isBankWidget(WidgetItem item_widget) {
        return item_widget.getWidget().getParentId() == 786442 || item_widget.getWidget().getParentId() == 786443 || item_widget.getWidget().getParentId() == 786444 || item_widget.getWidget().getParentId() == 786445;
    }

    public void renderItemOverlay(Graphics2D graphics, int item_id, WidgetItem item_widget) {
        if (!this.config.showItemOverlays()) {
            return;
        }
        for (ChargedItem infobox : this.infoboxes_charged_items) {
            if (infobox.getTriggersItems() == null || this.config.getHiddenItemOverlays().contains((Object)infobox.infobox_id) || infobox.getCharges() == -2) continue;
            TriggerItem trigger_item_to_use = null;
            for (TriggerItem trigger_item : infobox.getTriggersItems()) {
                if (trigger_item.item_id != item_id || trigger_item.hide_overlay) continue;
                trigger_item_to_use = trigger_item;
                break;
            }
            if (trigger_item_to_use == null) continue;
            String charges = ChargesImprovedPlugin.getChargesMinified(infobox.getCharges());
            graphics.setFont(FontManager.getRunescapeSmallFont());
            if (trigger_item_to_use.fixed_charges != null) {
                charges = ChargesImprovedPlugin.getChargesMinified(trigger_item_to_use.fixed_charges);
            }
            Rectangle bounds = item_widget.getCanvasBounds();
            TextComponent charges_component = new TextComponent();
            charges_component.setPosition(new Point(bounds.x, (int)bounds.getMaxY()));
            charges_component.setText(charges);
            if (charges.equals("?")) {
                charges_component.setColor(this.config.getColorUnknown());
            } else if (!this.isBankWidget(item_widget) && infobox.needsToBeEquipped() && !infobox.inEquipment() || charges.equals("0") && !infobox.zero_charges_is_positive || infobox.negative_full_charges != null && infobox.getCharges() == infobox.negative_full_charges.intValue() || infobox.isDeactivated()) {
                charges_component.setColor(this.config.getColorEmpty());
            } else {
                charges_component.setColor(this.config.getColorDefault());
            }
            charges_component.render(graphics);
            return;
        }
    }
}

