/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.run4lessplugin;

import com.github.elrol.run4lessplugin.Run4LessPlugin;
import com.github.elrol.run4lessplugin.RunData;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.runelite.client.RuneLite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunnerStats {
    private static final Logger log = LoggerFactory.getLogger(RunnerStats.class);
    private static final File dataLoc = new File(RuneLite.RUNELITE_DIR, "/bonerunning_logs/");
    Map<String, RunnerData> runHistory = new HashMap<String, RunnerData>();
    Map<String, Integer> bonesRan = new HashMap<String, Integer>();
    int totalMade = 0;
    RunData current;

    public void addRun(String client, String bones, int count, int coins, int notes, String noted) {
        RunnerData data = this.runHistory.getOrDefault(client, new RunnerData(client));
        if (!bones.isEmpty() && count > 0) {
            int qty = data.items.getOrDefault(bones, 0);
            data.items.put(bones, qty + count);
            qty = this.bonesRan.getOrDefault(client, 0);
            this.bonesRan.put(client, qty + count);
            if (this.current != null) {
                this.current.ran(bones, count);
            }
        }
        if (coins > 0) {
            this.totalMade += coins;
            data.price += coins;
        }
        if (notes > 0 && !noted.isEmpty()) {
            int notedQty = data.notes.getOrDefault(noted, 0);
            data.notes.put(noted, notedQty + notes);
            if (this.current == null) {
                this.current = new RunData(client, noted, notes);
                this.updateRun(client);
            } else if (this.current.client.equalsIgnoreCase(client)) {
                this.current.add(noted, notes);
                this.updateRun(client);
            } else {
                this.updateRun(client);
                this.current = new RunData(client, noted, notes);
            }
        }
        this.runHistory.put(client, data);
        log.debug("Client: " + client + ", Bones: " + bones + ", Count: " + count + ", Coins: " + coins + ", Notes: " + notes + ", Noted: " + noted);
        this.save();
    }

    public void updateRun(String client) {
        log.info("updating run");
        if (this.current == null) {
            return;
        }
        if (!this.current.client.equalsIgnoreCase(client) || !this.current.check()) {
            double now = System.currentTimeMillis();
            log.info(String.valueOf(this.current.start));
            log.info(String.valueOf(now));
            log.info(String.valueOf(now - (double)this.current.start));
            long seconds = Math.round((double)(System.currentTimeMillis() - this.current.start) / 60000.0);
            RunnerData data = this.runHistory.getOrDefault(client, new RunnerData(client));
            data.totalTime += seconds;
            this.runHistory.put(client, data);
            log.info("time for run was: " + seconds + " seconds");
        }
        if (!this.current.check()) {
            this.current = null;
        }
        this.save();
    }

    public void save() {
        if (!dataLoc.exists()) {
            dataLoc.mkdirs();
        }
        log.debug("DataLoc: " + dataLoc.getAbsoluteFile());
        try (FileWriter writer = new FileWriter(new File(dataLoc, "rundata.json"));){
            if (Run4LessPlugin.INSTANCE == null) {
                return;
            }
            Gson gson = Run4LessPlugin.INSTANCE.gson;
            if (gson != null) {
                gson.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static RunnerStats load() {
        RunnerStats stats = new RunnerStats();
        try {
            if (Run4LessPlugin.INSTANCE == null) {
                return stats;
            }
            Gson gson = Run4LessPlugin.INSTANCE.gson;
            if (gson != null) {
                stats = (RunnerStats)gson.fromJson((Reader)new FileReader(new File(dataLoc, "rundata.json")), RunnerStats.class);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return stats;
    }

    public int totalBones() {
        int total = 0;
        for (int i : this.bonesRan.values()) {
            total += i;
        }
        return total;
    }

    public static class RunnerData {
        public String client;
        public Map<String, Integer> items = new HashMap<String, Integer>();
        public Map<String, Integer> notes = new HashMap<String, Integer>();
        public int price;
        public long totalTime;

        public RunnerData(String client) {
            this.client = client;
            this.price = 0;
            this.totalTime = 0L;
        }
    }
}

