/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.run4lessplugin;

import com.github.elrol.run4lessplugin.Run4LessConfig;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class RunnerNotificationOverlay
extends Overlay {
    @Inject
    private Run4LessConfig config;
    private final PanelComponent panelComponent = new PanelComponent();
    private String text = "";

    public void init(String text, boolean state) {
        this.text = text;
        this.setPriority(OverlayPriority.HIGHEST);
        this.setPosition(OverlayPosition.TOP_CENTER);
        this.flash(state);
    }

    public void flash(boolean state) {
        Dimension dim = new Dimension(this.scale(300), this.scale(100));
        this.panelComponent.setPreferredSize(dim);
        this.panelComponent.getChildren().clear();
        this.panelComponent.setWrap(false);
        this.panelComponent.getChildren().add(TitleComponent.builder().text(this.text).color(state ? Color.white : Color.red).preferredSize(new Dimension(this.scale(100), this.scale(300))).build());
    }

    public void clearText() {
        this.text = "";
    }

    public boolean isNew() {
        return this.text.equals("");
    }

    public int scale(int base) {
        float scale = 1.0f;
        return Math.round(scale * (float)base);
    }

    public Dimension render(Graphics2D graphics) {
        return this.panelComponent.render(graphics);
    }
}

