/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.run4lessplugin;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunData {
    private static final Logger log = LoggerFactory.getLogger(RunData.class);
    String client = "";
    transient long start;
    Map<String, Integer> bones = new HashMap<String, Integer>();

    public RunData(String client, String type, int qty) {
        this.client = client;
        this.start = System.currentTimeMillis();
        log.info("Run Start: " + String.valueOf(this.start));
        this.bones.put(type, qty);
    }

    public void ran(String type, int qty) {
        if (this.bones.containsKey(type)) {
            int q = this.bones.get(type) - qty;
            if (q <= 0) {
                this.bones.remove(type);
            } else {
                this.bones.put(type, this.bones.get(type) - qty);
            }
        }
    }

    public void add(String type, int qty) {
        this.bones.put(type, this.bones.getOrDefault(type, 0) + qty);
    }

    public boolean check() {
        return this.bones.isEmpty();
    }
}

