/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.run4lessplugin;

import com.github.elrol.run4lessplugin.HostData;
import com.github.elrol.run4lessplugin.Run4LessCCOverlay;
import com.github.elrol.run4lessplugin.Run4LessConfig;
import com.github.elrol.run4lessplugin.Run4LessHostOverlay;
import com.github.elrol.run4lessplugin.Run4LessOverlay;
import com.github.elrol.run4lessplugin.Run4LessPanel;
import com.github.elrol.run4lessplugin.RunnerNotificationOverlay;
import com.github.elrol.run4lessplugin.RunnerStats;
import com.github.elrol.run4lessplugin.TimedNotifier;
import com.google.common.collect.ArrayListMultimap;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Provides;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.runelite.api.ChatLineBuffer;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.FriendsChatManager;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.FriendsChatRank;
import net.runelite.api.GameState;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.FriendsChatChanged;
import net.runelite.api.events.FriendsChatMemberJoined;
import net.runelite.api.events.FriendsChatMemberLeft;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.annotations.EverythingIsNonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bone Running Plugin", description="A plugin made for Bone Running, commissioned by the Run4Less group and updated for Bone Dash", tags={"bone dash", "menu", "running", "bone"})
public class Run4LessPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(Run4LessPlugin.class);
    protected static Run4LessPlugin INSTANCE;
    @Inject
    protected Gson gson;
    @Inject
    protected OkHttpClient httpClient;
    @Inject
    private Run4LessConfig config;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Run4LessOverlay run4LessOverlay;
    @Inject
    private Run4LessCCOverlay run4LessCCOverlay;
    @Inject
    private RunnerNotificationOverlay notificationOverlay;
    @Inject
    private Run4LessHostOverlay run4LessHostOverlay;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Provider<MenuManager> menuManager;
    @Inject
    private ConfigManager configManager;
    public static NavigationButton panel;
    private boolean isRunner = false;
    private boolean isHost = false;
    private final ArrayListMultimap<String, Integer> indexes = ArrayListMultimap.create();
    public static RunnerStats stats;
    public static HostData hostData;
    public static final String setClient = "Set as Client";
    boolean shouldSpam = true;
    public ArrayList<String> hosts = new ArrayList();
    public ArrayList<String> hosting = new ArrayList();
    public static BufferedImage logo;

    protected void startUp() throws Exception {
        INSTANCE = this;
        hostData.load(this.config.hostJson());
        this.run4LessHostOverlay.init(this.hosting);
        if (this.client != null) {
            ((MenuManager)this.menuManager.get()).addPlayerMenuItem(setClient);
        }
        if (this.config.splitCCEnabled() && this.config.ccLines() > 0) {
            this.overlayManager.add((Overlay)this.run4LessCCOverlay);
        }
        logo = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/OIG.png");
        logo = Run4LessPlugin.resize(logo, this.config.logoScale());
        panel = NavigationButton.builder().tooltip("Bone Calculator").icon(logo).priority(10).panel((PluginPanel)new Run4LessPanel()).build();
        this.clientToolbar.addNavigation(panel);
        this.updateLogo(((Object)((Object)this)).getClass(), this.config.logoUrl());
        super.startUp();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.run4LessOverlay);
        this.overlayManager.remove((Overlay)this.run4LessCCOverlay);
        this.overlayManager.remove((Overlay)this.notificationOverlay);
        this.overlayManager.remove((Overlay)this.run4LessHostOverlay);
        this.clientToolbar.removeNavigation(panel);
        ((MenuManager)this.menuManager.get()).removePlayerMenuItem(setClient);
        this.configManager.setConfiguration("run4less", "clientName", "");
        stats.updateRun("");
        super.shutDown();
    }

    private boolean isRightClan() {
        FriendsChatManager manager = this.client.getFriendsChatManager();
        if (manager == null) {
            return false;
        }
        return Text.standardize((String)manager.getOwner()).equalsIgnoreCase(Text.standardize((String)this.config.ccName()));
    }

    @Subscribe(priority=-2.0f)
    public void onChatMessage(ChatMessage message) {
        String rsn;
        Widget tradingWith;
        FriendsChatManager manager = this.client.getFriendsChatManager();
        boolean ccEnabled = this.config.splitCCEnabled();
        int ccLines = this.config.ccLines();
        if (this.isRightClan() && message.getType().equals((Object)ChatMessageType.FRIENDSCHAT)) {
            FriendsChatMember p;
            String sender;
            Widget chat;
            if (ccEnabled && ccLines > 0 && (chat = this.client.getWidget(WidgetInfo.CHATBOX_TRANSPARENT_LINES)) != null && !chat.isHidden()) {
                this.run4LessCCOverlay.init(chat.getWidth(), message);
            }
            log.debug(message.getMessage());
            if (message.getMessage().toLowerCase().contains("!bones ")) {
                log.debug("Ran bones command");
                String cmd = message.getMessage().toLowerCase().split("!bones ")[1];
                String[] temp = cmd.replace("!bones", "").split(" ");
                int rate = 0;
                if (temp[0].equalsIgnoreCase("afk")) {
                    rate = 25000;
                } else if (temp[0].equalsIgnoreCase("tick")) {
                    rate = 15000;
                } else {
                    this.client.addChatMessage(message.getType(), message.getName(), "Invalid argument [" + temp[0] + "]. Options are [tick/afk]", message.getSender());
                }
                int qty = Integer.parseInt(temp[1]);
                if (qty <= 0) {
                    this.client.addChatMessage(message.getType(), message.getName(), "Invalid argument [" + temp[1] + "]. Options must be greater then 0", message.getSender());
                    qty = 0;
                }
                DecimalFormat formatter = new DecimalFormat("#,###");
                String price = formatter.format(Math.round((float)qty / 26.0f * (float)rate));
                this.client.addChatMessage(message.getType(), message.getName(), temp[0] + "ing " + temp[1] + " bones would be " + price, message.getSender());
                log.debug(temp[0] + "ing " + temp[1] + " bones would be " + price);
            }
            if (!(sender = message.getName()).isEmpty() && (p = (FriendsChatMember)manager.findByName(sender)) != null) {
                FriendsChatRank rank = p.getRank();
                String msg = message.getMessage();
                boolean runner = msg.equalsIgnoreCase("@runner");
                boolean ping = this.config.enablePing();
                if (rank != FriendsChatRank.UNRANKED && runner && this.isRunner && ping) {
                    TimedNotifier.init("Bone Runner Requested", 30, this.overlayManager, this.notificationOverlay);
                }
                if (this.hosts.contains(p.getName()) && message.getMessage().contains("@host")) {
                    if (this.hosting.contains(p.getName())) {
                        this.hosting.remove(p.getName());
                    } else {
                        this.hosting.add(p.getName());
                    }
                    this.run4LessHostOverlay.init(this.hosting);
                }
            }
        }
        if (message.getMessage().equalsIgnoreCase("accepted trade.") && this.config.enableStats() && (tradingWith = this.client.getWidget(334, 30)) != null && (rsn = tradingWith.getText().replace("Trading with:<br>", "")).equalsIgnoreCase(this.config.clientName())) {
            Widget partnerTrades = this.client.getWidget(334, 29);
            Widget offeredTrades = this.client.getWidget(334, 28);
            if (partnerTrades != null && offeredTrades != null) {
                int i = 0;
                int coins = 0;
                int notes = 0;
                int qty = 0;
                String bones = "";
                String noted = "";
                for (Widget w : partnerTrades.getChildren()) {
                    String text = w.getText();
                    if (text.startsWith("Coins")) {
                        text = text.contains("(") ? text.split("[(]")[1] : text.split("<col=ffffff> x <col=ffff00>")[1];
                        text = text.replace(",", "").replace(")", "");
                        coins += Integer.parseInt(text);
                        continue;
                    }
                    if (text.toLowerCase().contains("bones") && text.contains("<col=ffffff> x <col=ffff00>")) {
                        String[] temp = text.split("<col=ffffff> x <col=ffff00>");
                        noted = temp[0];
                        notes = Integer.parseInt(temp[1]);
                        continue;
                    }
                    if (!text.toLowerCase().contains("bones")) continue;
                    --qty;
                }
                for (Widget w : offeredTrades.getChildren()) {
                    if (w == null) continue;
                    log.debug("[" + i++ + "]:" + w.getText());
                    String s = w.getText().toLowerCase();
                    if (!s.contains("bones") || s.contains("<col=ffffff> x <col=ffff00>")) continue;
                    bones = w.getText();
                    ++qty;
                }
                log.info("Adding Run");
                stats.addRun(rsn, bones, qty, coins, notes, noted);
            }
        }
        if (this.config.filterTradeEnabled() && message.getType().equals((Object)ChatMessageType.TRADE)) {
            this.removeMessage(message);
        }
        if (this.config.spamTrade() && message.getType().equals((Object)ChatMessageType.TRADEREQ) && this.shouldSpam) {
            this.shouldSpam = false;
            for (int i = 0; i < 7; ++i) {
                this.client.addChatMessage(message.getType(), message.getName(), message.getMessage(), message.getSender());
            }
            this.shouldSpam = true;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("bone dash")) {
            if (this.config.splitCCEnabled()) {
                Widget chat = this.client.getWidget(WidgetInfo.CHATBOX_TRANSPARENT_LINES);
                if (chat != null) {
                    this.run4LessCCOverlay.init(chat.getWidth());
                }
                this.overlayManager.add((Overlay)this.run4LessCCOverlay);
            } else {
                this.overlayManager.remove((Overlay)this.run4LessCCOverlay);
            }
            this.overlayManager.remove((Overlay)this.run4LessOverlay);
            this.updateLogo(((Object)((Object)this)).getClass(), this.config.logoUrl());
            stats.updateRun(this.config.clientName());
        }
    }

    @Subscribe
    public void onFriendsChatChanged(FriendsChatChanged event) {
        this.clientThread.invokeLater(() -> {
            FriendsChatManager manager = this.client.getFriendsChatManager();
            Player player = this.client.getLocalPlayer();
            if (player != null && this.isRightClan()) {
                FriendsChatRank rank = ((FriendsChatMember)manager.findByName(player.getName())).getRank();
                if (rank.equals((Object)FriendsChatRank.FRIEND)) {
                    this.isHost = true;
                    this.updateLogo(((Object)((Object)this)).getClass(), this.config.logoUrl());
                    return;
                }
                if (!rank.equals((Object)FriendsChatRank.UNRANKED)) {
                    this.isRunner = true;
                    this.updateLogo(((Object)((Object)this)).getClass(), this.config.logoUrl());
                    return;
                }
                this.isRunner = false;
                this.isHost = false;
                this.hosts.clear();
                for (FriendsChatMember member : (FriendsChatMember[])manager.getMembers()) {
                    if (this.isPlayerHost(member)) {
                        this.hosts.add(member.getName());
                        continue;
                    }
                    this.hosting.remove(member.getName());
                }
                this.run4LessHostOverlay.init(this.hosting);
            }
            this.overlayManager.remove((Overlay)this.run4LessOverlay);
        });
    }

    private boolean isPlayerHost(FriendsChatMember member) {
        return member.getRank().equals((Object)FriendsChatRank.FRIEND) && !this.hosts.contains(member.getName()) || hostData.getUsers().contains(member.getName()) && !this.hosts.contains(member.getName());
    }

    @Subscribe
    public void onFriendsChatMemberJoined(FriendsChatMemberJoined event) {
        FriendsChatMember member = event.getMember();
        if (this.isPlayerHost(member)) {
            this.hosts.add(member.getName());
        }
    }

    @Subscribe
    public void onFriendsChatMemberLeft(FriendsChatMemberLeft event) {
        Player player = this.client.getLocalPlayer();
        if (player != null) {
            if (event.getMember().getName().equals(player.getName())) {
                this.hosts.clear();
                this.hosting.clear();
            } else {
                this.hosting.remove(event.getMember().getName());
            }
            this.run4LessHostOverlay.init(this.hosting);
        }
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        if (!panel.getIcon().equals(logo)) {
            this.clientToolbar.removeNavigation(panel);
            panel = NavigationButton.builder().tooltip("Bone Calculator").icon(logo).priority(10).panel(panel.getPanel()).build();
            if (panel == null) {
                log.info("Navigation was null");
            }
            if (this.clientToolbar == null) {
                log.info("ClientToolbar was null");
            }
            this.clientToolbar.addNavigation(panel);
        }
        if (this.config.offerAllEnabled()) {
            String option;
            MenuEntry[] menuEntries = this.client.getMenuEntries();
            int index = 0;
            this.indexes.clear();
            for (MenuEntry entry : menuEntries) {
                option = Text.removeTags((String)entry.getOption()).toLowerCase();
                this.indexes.put((Object)option, (Object)index++);
            }
            index = 0;
            for (MenuEntry menuEntry : menuEntries) {
                ++index;
                option = Text.removeTags((String)menuEntry.getOption()).toLowerCase();
                String target = Text.removeTags((String)menuEntry.getTarget()).toLowerCase();
                if (!option.equals("offer")) continue;
                int i = Run4LessPlugin.index(this.indexes, menuEntries, index, option, target);
                int id = Run4LessPlugin.index(this.indexes, menuEntries, i, "offer-all", target);
                if (i < 0 || id < 0) continue;
                MenuEntry entry = menuEntries[id];
                menuEntries[id] = menuEntries[i];
                menuEntries[i] = entry;
                this.client.setMenuEntries(menuEntries);
                this.indexes.clear();
                int idx = 0;
                for (MenuEntry e : menuEntries) {
                    String o = Text.removeTags((String)e.getOption()).toLowerCase();
                    this.indexes.put((Object)o, (Object)idx++);
                }
            }
        }
    }

    public static int index(ArrayListMultimap<String, Integer> optionIndexes, MenuEntry[] entries, int limit, String option, String target) {
        List indexes = optionIndexes.get((Object)option);
        for (int i = indexes.size() - 1; i >= 0; --i) {
            int idx = (Integer)indexes.get(i);
            MenuEntry entry = entries[idx];
            String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
            if (idx > limit || !entryTarget.equals(target)) continue;
            return idx;
        }
        return -1;
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuOption().equals(setClient)) {
            String name = event.getMenuTarget().split(" {2}\\(level-")[0];
            this.configManager.setConfiguration("run4less", "clientName", Text.removeTags((String)name));
        }
    }

    private void removeMessage(ChatMessage msg) {
        ChatLineBuffer ccInfoBuffer = (ChatLineBuffer)this.client.getChatLineMap().get(ChatMessageType.TRADE.getType());
        if (ccInfoBuffer != null) {
            ccInfoBuffer.removeMessageNode(msg.getMessageNode());
        }
    }

    @Provides
    Run4LessConfig getConfig(ConfigManager configManager) {
        return (Run4LessConfig)configManager.getConfig(Run4LessConfig.class);
    }

    private static BufferedImage resize(BufferedImage img, int s) {
        float scale = (float)s / 10.0f;
        int size = Math.round(60.0f * scale);
        Image tmp = img.getScaledInstance(size, size, 4);
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return image;
    }

    private void update(BufferedImage logo) {
        Run4LessPanel.init(logo);
        logo = Run4LessPlugin.resize(logo, this.config.logoScale());
        this.run4LessOverlay.setLogo(logo);
        if ((this.isRunner || this.isHost) && !this.config.logoUrl().equalsIgnoreCase("none")) {
            this.overlayManager.add((Overlay)this.run4LessOverlay);
        }
    }

    private void updateLogo(Class<?> c, String url) {
        logo = ImageUtil.loadImageResource(c, (String)"/OIG.png");
        this.overlayManager.remove((Overlay)this.run4LessOverlay);
        if (!url.equals("") && !url.equalsIgnoreCase("none")) {
            Request req = new Request.Builder().url(url).build();
            this.httpClient.newCall(req).enqueue(new Callback(){

                @EverythingIsNonNull
                public void onFailure(Call call, IOException e) {
                    Run4LessPlugin.this.update(logo);
                    e.printStackTrace();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @EverythingIsNonNull
                public void onResponse(Call call, Response response) throws IOException {
                    try (ResponseBody responseBody = response.body();){
                        Class<ImageIO> clazz = ImageIO.class;
                        synchronized (ImageIO.class) {
                            assert (responseBody != null);
                            BufferedImage temp = ImageIO.read(responseBody.byteStream());
                            if (temp != null) {
                                logo = Run4LessPlugin.resize(temp, Run4LessPlugin.this.config.logoScale());
                            }
                            Run4LessPlugin.this.update(logo);
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                        }
                    }
                    {
                        return;
                    }
                }
            });
        } else {
            this.update(logo);
        }
    }

    static {
        stats = RunnerStats.load();
        hostData = new HostData();
    }
}

