/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.run4lessplugin;

import com.github.elrol.run4lessplugin.Run4LessConfig;
import com.google.inject.Inject;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.ArrayList;
import net.runelite.api.Client;
import net.runelite.api.FriendsChatManager;
import net.runelite.api.FriendsChatMember;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Run4LessHostOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(Run4LessHostOverlay.class);
    @Inject
    private Run4LessConfig config;
    @Inject
    private Client client;
    private PanelComponent panelComponent = new PanelComponent();

    public Run4LessHostOverlay() {
        this.setPriority(OverlayPriority.HIGHEST);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.panelComponent.setPreferredSize(new Dimension(200, 0));
    }

    public void init(ArrayList<String> list) {
        FriendsChatManager manager = this.client.getFriendsChatManager();
        if (manager == null) {
            this.panelComponent.getChildren().clear();
            return;
        }
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Active Hosts").color(this.config.hostColor()).build());
        int i = 0;
        for (String username : list) {
            if (i >= this.config.hostLimit()) continue;
            int world = ((FriendsChatMember)manager.findByName(username)).getWorld();
            LineComponent line = LineComponent.builder().leftColor(this.config.hostColor()).left(username + " : World " + world).build();
            this.panelComponent.getChildren().add(line);
            ++i;
        }
    }

    public Dimension render(Graphics2D graphics) {
        return this.panelComponent.render(graphics);
    }
}

