/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.run4lessplugin;

import com.github.elrol.run4lessplugin.Run4LessConfig;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.ArrayList;
import net.runelite.api.Client;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.FriendsChatRank;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Run4LessCCOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(Run4LessCCOverlay.class);
    @Inject
    private Run4LessConfig config;
    @Inject
    private Client client;
    private final ArrayList<ChatMessage> clanMessages = new ArrayList();
    private final PanelComponent panelComponent = new PanelComponent();

    public Run4LessCCOverlay() {
        this.setPriority(OverlayPriority.HIGHEST);
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
    }

    public void init(int width, ChatMessage message) {
        this.clanMessages.add(message);
        this.init(width);
    }

    public void init(int width) {
        int i;
        Player s = this.client.getLocalPlayer();
        if (s == null) {
            return;
        }
        this.panelComponent.setPreferredSize(new Dimension(width, 0));
        this.panelComponent.getChildren().clear();
        int last = this.clanMessages.size() - 1;
        ArrayList<ChatMessage> msgs = new ArrayList<ChatMessage>();
        for (i = last; i >= 0 && msgs.size() < this.config.ccLines(); --i) {
            ChatMessage msg = this.clanMessages.get(i);
            if (this.config.clientFilterEnabled()) {
                if (this.config.clientName().isEmpty() || !this.config.clientName().equalsIgnoreCase(msg.getName()) && !msg.getName().equalsIgnoreCase(s.getName())) continue;
                msgs.add(msg);
                continue;
            }
            msgs.add(msg);
        }
        for (i = msgs.size() - 1; i >= 0; --i) {
            this.panelComponent.getChildren().add(this.colorMessage((ChatMessage)msgs.get(i), s.getName()));
        }
    }

    private LineComponent colorMessage(ChatMessage msg, String name) {
        Color color = this.config.ccColor();
        if (this.client.getFriendsChatManager() != null) {
            FriendsChatRank rank;
            FriendsChatMember f = (FriendsChatMember)this.client.getFriendsChatManager().findByName(msg.getName());
            if (f != null && (rank = f.getRank()) != null) {
                if (rank != FriendsChatRank.UNRANKED) {
                    color = this.config.ccRColor();
                }
                if (rank.equals((Object)FriendsChatRank.FRIEND)) {
                    color = this.config.ccHostColor();
                }
            }
            if (msg.getMessageNode().getName().equalsIgnoreCase(name)) {
                color = this.config.ccSColor();
            }
        }
        if (msg.getName().equalsIgnoreCase(this.config.clientName())) {
            color = this.config.ccClientColor();
        }
        return LineComponent.builder().leftColor(color).left(msg.getMessageNode().getName() + ": " + msg.getMessage()).build();
    }

    public Dimension render(Graphics2D graphics) {
        return this.panelComponent.render(graphics);
    }
}

