/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.run4lessplugin;

import com.github.elrol.run4lessplugin.Run4LessPlugin;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.annotations.EverythingIsNonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostData {
    private static final Logger log = LoggerFactory.getLogger(HostData.class);
    @SerializedName(value="OSRS Hosts")
    public Host[] OSRS_Hosts;

    public List<String> getUsers() {
        ArrayList<String> users = new ArrayList<String>();
        if (this.OSRS_Hosts == null) {
            return users;
        }
        for (Host host : this.OSRS_Hosts) {
            users.add(host.Username);
        }
        return users;
    }

    public void load(String hostJson) {
        if (hostJson == null || hostJson.isEmpty()) {
            return;
        }
        Request req = new Request.Builder().url(hostJson).build();
        if (Run4LessPlugin.INSTANCE == null) {
            return;
        }
        OkHttpClient httpClient = Run4LessPlugin.INSTANCE.httpClient;
        if (httpClient != null) {
            httpClient.newCall(req).enqueue(new Callback(){

                @EverythingIsNonNull
                public void onFailure(Call call, IOException e) {
                }

                @EverythingIsNonNull
                public void onResponse(Call call, Response response) throws IOException {
                    assert (response.body() != null);
                    InputStreamReader reader = new InputStreamReader(response.body().byteStream(), StandardCharsets.UTF_8);
                    if (Run4LessPlugin.INSTANCE == null) {
                        return;
                    }
                    Gson gson = Run4LessPlugin.INSTANCE.gson;
                    if (gson != null) {
                        HostData data = (HostData)gson.fromJson((Reader)reader, HostData.class);
                        Run4LessPlugin.hostData.OSRS_Hosts = data.OSRS_Hosts;
                    }
                    reader.close();
                }
            });
        }
    }

    public String toString() {
        return "HostData{OSRS_Hosts=" + Arrays.toString(this.OSRS_Hosts) + "}";
    }

    public static class Host {
        String Username;
        int World;
        String loc;

        public Host(String user, int w, String l) {
            this.Username = user;
            this.World = w;
            this.loc = l;
        }

        public String toString() {
            return "Host{Username='" + this.Username + "', World=" + this.World + ", loc='" + this.loc + "'}";
        }
    }
}

