/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.run4lessplugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BoneCalcPanel
extends JPanel {
    private final JTextField boneQty = new JTextField("0");
    private final JTextField price = new JTextField("0");
    private final JTextField totalCost = new JTextField("0");

    public BoneCalcPanel() {
        this.totalCost.setEditable(false);
        JButton reset = new JButton("Reset");
        reset.addActionListener(e -> {
            this.boneQty.setText("0");
            this.price.setText("0");
            this.totalCost.setText("0");
        });
        JButton calc = new JButton("Calculate");
        calc.addActionListener(e -> {
            int bones = this.parseString(this.boneQty.getText());
            this.boneQty.setText("" + bones);
            int p = this.parseString(this.price.getText());
            this.price.setText("" + p);
            double total = Math.floor((float)bones / 26.0f) * (double)p;
            DecimalFormat formatter = new DecimalFormat("#,###");
            this.totalCost.setText(formatter.format(total));
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel("Bone Qty:"), c);
        ++c.gridx;
        this.add((Component)new JLabel("Price per Inv:"), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)this.boneQty, c);
        ++c.gridx;
        this.add((Component)this.price, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)reset, c);
        ++c.gridx;
        this.add((Component)calc, c);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Price for Run:"), c);
        ++c.gridy;
        this.add((Component)this.totalCost, c);
    }

    private int parseString(String s) {
        s = s.replace("b", "000000000");
        s = s.replace("m", "000000");
        s = s.replace("k", "000");
        return Integer.parseInt(s);
    }
}

