/*
 * Decompiled with CFR 0.152.
 */
package com.pleae;

import com.google.inject.Provides;
import com.pleae.PleaeConfig;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.ActorDeath;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Pleae")
public class PleaePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PleaePlugin.class);
    private static final int OVERHEAD_TEXT_TICK_TIMEOUT = 6;
    public static final int CYCLES_PER_GAME_TICK = 30;
    private static final int CYCLES_FOR_OVERHEAD_TEXT = 180;
    @Inject
    private Client client;
    @Inject
    private PleaeConfig config;

    @Provides
    PleaeConfig provideConfig(ConfigManager configManager) {
        return (PleaeConfig)configManager.getConfig(PleaeConfig.class);
    }

    @Subscribe
    public void onActorDeath(ActorDeath actorDeath) {
        Actor actor = actorDeath.getActor();
        if (!(actor instanceof Player)) {
            return;
        }
        Player player = (Player)actor;
        this.addChatMessage(player);
        this.addOverheadMessage(player);
    }

    private void addChatMessage(Player player) {
        if (player == null) {
            return;
        }
        if (player == this.client.getLocalPlayer() && !this.config.chatMessageForYou()) {
            return;
        }
        if (player != this.client.getLocalPlayer() && !this.config.chatMessageForOthers()) {
            return;
        }
        String deathMessage = this.getDeathMessage();
        if (deathMessage == null) {
            return;
        }
        this.client.addChatMessage(ChatMessageType.PUBLICCHAT, player.getName(), deathMessage, null);
    }

    private void addOverheadMessage(Player player) {
        if (player == null) {
            return;
        }
        if (player == this.client.getLocalPlayer() && !this.config.overheadMessageForYou()) {
            return;
        }
        if (player != this.client.getLocalPlayer() && !this.config.overheadMessageForOthers()) {
            return;
        }
        String deathMessage = this.getDeathMessage();
        if (deathMessage == null) {
            return;
        }
        player.setOverheadText(deathMessage);
        player.setOverheadCycle(180);
    }

    private String getDeathMessage() {
        if (this.config.deathMessage() == null) {
            return null;
        }
        String configMessage = this.config.deathMessage().trim();
        return configMessage.length() == 0 ? null : configMessage;
    }
}

