/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.f2pstarassist.plugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.janboerman.f2pstarassist.common.CrashedStar;
import com.janboerman.f2pstarassist.common.GroupKey;
import com.janboerman.f2pstarassist.common.StarKey;
import com.janboerman.f2pstarassist.common.StarList;
import com.janboerman.f2pstarassist.common.StarPacket;
import com.janboerman.f2pstarassist.common.StarRequest;
import com.janboerman.f2pstarassist.common.StarTier;
import com.janboerman.f2pstarassist.common.StarUpdate;
import com.janboerman.f2pstarassist.common.web.StarJson;
import com.janboerman.f2pstarassist.plugin.ResponseException;
import com.janboerman.f2pstarassist.plugin.StarAssistConfig;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class StarClient {
    private static final MediaType APPLICATION_JSON = MediaType.get((String)"application/json");
    private final OkHttpClient httpClient;
    private final StarAssistConfig config;

    @Inject
    public StarClient(OkHttpClient httpClient, StarAssistConfig config) {
        this.httpClient = httpClient;
        this.config = config;
    }

    public CompletableFuture<StarList> requestStars(Set<GroupKey> groups, Set<CrashedStar> knownStars) {
        String json = StarJson.starPacketJson(new StarPacket(groups, new StarRequest(knownStars))).toString();
        String url = this.config.httpUrl() + "/stars";
        RequestBody requestBody = RequestBody.create((MediaType)APPLICATION_JSON, (String)json);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        final CompletableFuture<StarList> future = new CompletableFuture<StarList>();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(new ResponseException(call, e));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                block9: {
                    try {
                        if (!response.isSuccessful()) {
                            future.completeExceptionally(new ResponseException(call, "WebServer answered with response code: " + response.code()));
                            return;
                        }
                        ResponseBody body = response.body();
                        Reader reader = body.charStream();
                        JsonParser jsonParser = new JsonParser();
                        try {
                            JsonElement jsonElement = jsonParser.parse(reader);
                            if (jsonElement instanceof JsonArray) {
                                Set<CrashedStar> starSet = StarJson.crashedStars((JsonArray)jsonElement);
                                StarList starList = new StarList(Collections.singletonMap(starSet, Collections.emptySet()), Collections.emptySet(), Collections.emptySet());
                                future.complete(starList);
                                break block9;
                            }
                            if (jsonElement instanceof JsonObject) {
                                StarList starList = StarJson.starList((JsonObject)jsonElement);
                                future.complete(starList);
                                break block9;
                            }
                            future.completeExceptionally(new ResponseException(call, "Expected a json representation of a star list, but got: " + jsonElement));
                        }
                        catch (RuntimeException e) {
                            future.completeExceptionally(new ResponseException(call, e));
                        }
                    }
                    finally {
                        response.close();
                    }
                }
            }
        });
        return future;
    }

    public CompletableFuture<Optional<CrashedStar>> sendStar(Set<GroupKey> groups, CrashedStar star) {
        String json = StarJson.starPacketJson(new StarPacket(groups, star)).toString();
        String url = this.config.httpUrl() + "/send_star";
        RequestBody requestBody = RequestBody.create((MediaType)APPLICATION_JSON, (String)json);
        Request request = new Request.Builder().url(url).put(requestBody).build();
        final CompletableFuture<Optional<CrashedStar>> future = new CompletableFuture<Optional<CrashedStar>>();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(new ResponseException(call, e));
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful()) {
                    future.completeExceptionally(new ResponseException(call, "WebServer answered with with response code: " + response.code()));
                    return;
                }
                switch (response.code()) {
                    case 200: {
                        Reader reader = response.body().charStream();
                        JsonParser jsonParser = new JsonParser();
                        try {
                            JsonElement jsonElement = jsonParser.parse(reader);
                            if (jsonElement instanceof JsonObject) {
                                future.complete(Optional.of(StarJson.crashedStar((JsonObject)jsonElement)));
                                break;
                            }
                            future.completeExceptionally(new ResponseException(call, "Expected a crashed star json object, but got: " + jsonElement));
                        }
                        catch (RuntimeException e) {
                            future.completeExceptionally(new ResponseException(call, e));
                        }
                        break;
                    }
                    default: {
                        future.complete(Optional.empty());
                    }
                }
            }
        });
        return future;
    }

    public CompletableFuture<CrashedStar> updateStar(Set<GroupKey> groups, StarKey starKey, StarTier tier) {
        String json = StarJson.starPacketJson(new StarPacket(groups, new StarUpdate(starKey, tier))).toString();
        String url = this.config.httpUrl() + "/update_star";
        RequestBody requestBody = RequestBody.create((MediaType)APPLICATION_JSON, (String)json);
        Request request = new Request.Builder().url(url).patch(requestBody).build();
        final CompletableFuture<CrashedStar> future = new CompletableFuture<CrashedStar>();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(new ResponseException(call, e));
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful()) {
                    future.completeExceptionally(new ResponseException(call, "WebServer answered with response code: " + response.code()));
                    return;
                }
                ResponseBody responseBody = response.body();
                Reader reader = responseBody.charStream();
                JsonParser jsonParser = new JsonParser();
                try {
                    JsonElement jsonElement = jsonParser.parse(reader);
                    if (jsonElement instanceof JsonObject) {
                        future.complete(StarJson.crashedStar((JsonObject)jsonElement));
                    } else {
                        future.completeExceptionally(new ResponseException(call, "Expected a crashed star json object, but got: " + jsonElement));
                    }
                }
                catch (RuntimeException e) {
                    future.completeExceptionally(new ResponseException(call, e));
                }
            }
        });
        return future;
    }

    public CompletableFuture<Void> deleteStar(Set<GroupKey> groups, StarKey starKey) {
        String json = StarJson.starPacketJson(new StarPacket(groups, starKey)).toString();
        String url = this.config.httpUrl() + "/poofed_star";
        RequestBody requestBody = RequestBody.create((MediaType)APPLICATION_JSON, (String)json);
        Request request = new Request.Builder().url(url).delete(requestBody).build();
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(new ResponseException(call, e));
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful()) {
                    future.completeExceptionally(new ResponseException(call, "WebServer answered with response code: " + response.code()));
                    return;
                }
                future.complete(null);
            }
        });
        return future;
    }
}

