/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.f2pstarassist.plugin;

import com.google.common.cache.RemovalListener;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.inject.Provides;
import com.janboerman.f2pstarassist.common.CrashedStar;
import com.janboerman.f2pstarassist.common.GroupKey;
import com.janboerman.f2pstarassist.common.RunescapeUser;
import com.janboerman.f2pstarassist.common.StarCache;
import com.janboerman.f2pstarassist.common.StarKey;
import com.janboerman.f2pstarassist.common.StarList;
import com.janboerman.f2pstarassist.common.StarLocation;
import com.janboerman.f2pstarassist.common.StarTier;
import com.janboerman.f2pstarassist.common.StarUpdate;
import com.janboerman.f2pstarassist.common.User;
import com.janboerman.f2pstarassist.common.lingo.StarLingo;
import com.janboerman.f2pstarassist.common.util.CollectionConvert;
import com.janboerman.f2pstarassist.plugin.DoubleHoppingTilesOverlay;
import com.janboerman.f2pstarassist.plugin.ResponseException;
import com.janboerman.f2pstarassist.plugin.StarAssistConfig;
import com.janboerman.f2pstarassist.plugin.StarAssistPanel;
import com.janboerman.f2pstarassist.plugin.StarClient;
import com.janboerman.f2pstarassist.plugin.StarIds;
import com.janboerman.f2pstarassist.plugin.StarPoints;
import com.janboerman.f2pstarassist.plugin.TextUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.Tile;
import net.runelite.api.World;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WorldChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.WorldUtil;
import net.runelite.http.api.worlds.WorldResult;
import net.runelite.http.api.worlds.WorldType;
import okhttp3.Call;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="F2P Star Assist")
public class StarAssistPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(StarAssistPlugin.class);
    private final StarCache starCache;
    private final Map<StarKey, Set<GroupKey>> owningGroups = new HashMap<StarKey, Set<GroupKey>>();
    private final Map<String, GroupKey> groups = new HashMap<String, GroupKey>();
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private WorldService worldService;
    @Inject
    private ClientThread clientThread;
    @Inject
    private StarAssistConfig config;
    @Inject
    private OverlayManager overlayManager;
    private StarClient starClient;
    private DoubleHoppingTilesOverlay doubleHoppingTilesOverlay;
    private ScheduledExecutorService fetcherTimer;
    private StarAssistPanel panel;
    private NavigationButton navButton;
    private static final int DETECTION_DISTANCE = 25;

    public StarAssistPlugin() {
        this.starCache = new StarCache((RemovalListener<StarKey, CrashedStar>)((RemovalListener)removalNotification -> {
            if (removalNotification.wasEvicted()) {
                this.clientThread.invokeLater(this::updatePanel);
            }
            this.clientThread.invoke(() -> {
                CrashedStar removedStar = (CrashedStar)removalNotification.getValue();
                if (removedStar.getWorld() == this.client.getWorld()) {
                    WorldPoint starPoint = StarPoints.fromLocation(removedStar.getLocation());
                    if (this.client.hasHintArrow() && this.client.getHintArrowPoint().equals((Object)starPoint)) {
                        this.client.clearHintArrow();
                    }
                }
                if (removalNotification.wasEvicted()) {
                    this.owningGroups.remove(removedStar.getKey());
                }
            });
        }));
    }

    @Provides
    StarAssistConfig provideConfig(ConfigManager configManager) {
        return (StarAssistConfig)configManager.getConfig(StarAssistConfig.class);
    }

    protected void startUp() throws Exception {
        this.starClient = (StarClient)this.injector.getInstance(StarClient.class);
        this.doubleHoppingTilesOverlay = (DoubleHoppingTilesOverlay)((Object)this.injector.getInstance(DoubleHoppingTilesOverlay.class));
        this.overlayManager.add((Overlay)this.doubleHoppingTilesOverlay);
        this.panel = new StarAssistPanel(this, this.config, this.client, this.clientThread);
        BufferedImage icon = ImageUtil.loadImageResource(StarAssistPlugin.class, (String)"/icon.png");
        this.navButton = NavigationButton.builder().tooltip("F2P Star Assist").icon(icon).priority(10).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.setGroups(this.loadGroups());
        this.fetcherTimer = Executors.newSingleThreadScheduledExecutor();
        this.fetcherTimer.scheduleAtFixedRate(() -> this.clientThread.invoke(() -> this.fetchStarList(CollectionConvert.toSet(this.groups.values()))), 0L, 15L, TimeUnit.MINUTES);
        this.clientThread.invoke(() -> this.updatePanel());
        log.info("F2P Star Assist started!");
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.doubleHoppingTilesOverlay);
        this.clientToolbar.removeNavigation(this.navButton);
        this.fetcherTimer.shutdownNow();
        this.fetcherTimer = null;
        this.starCache.clear();
        this.owningGroups.clear();
        this.groups.clear();
        log.info("F2P Star Assist stopped!");
    }

    public void fetchStarList(Set<GroupKey> sharingGroups) {
        if (this.config.httpConnectionEnabled()) {
            CompletableFuture<StarList> starFuture = this.starClient.requestStars(sharingGroups, this.starCache.getStars());
            starFuture.whenCompleteAsync((receivedStars, ex) -> {
                if (ex != null) {
                    log.error("Error when receiving star data", ex);
                } else {
                    log.debug("received stars from webserver: " + receivedStars);
                    this.clientThread.invoke(() -> this.receiveStars((StarList)receivedStars));
                }
            });
        }
    }

    public void hopAndHint(CrashedStar star) {
        WorldResult worldResult;
        assert (!this.client.isClientThread());
        int starWorld = star.getWorld();
        int currentWorld = this.client.getWorld();
        if (currentWorld != starWorld && (worldResult = this.worldService.getWorlds()) != null) {
            this.clientThread.invoke(() -> {
                World world = this.rsWorld(worldResult.findWorld(starWorld));
                if (world != null) {
                    this.client.hopToWorld(world);
                }
                if (this.config.hintArrowEnabled()) {
                    WorldPoint starPoint = StarPoints.fromLocation(star.getLocation());
                    this.client.setHintArrow(starPoint);
                }
            });
        }
    }

    public void showHintArrow(boolean whetherTo) {
        assert (this.client.isClientThread());
        int playerWorld = this.client.getWorld();
        for (CrashedStar star : this.starCache.getStars()) {
            if (star.getWorld() != playerWorld) continue;
            WorldPoint starPoint = StarPoints.fromLocation(star.getLocation());
            if (whetherTo) {
                this.client.setHintArrow(starPoint);
                break;
            }
            if (!this.client.hasHintArrow() || !this.client.getHintArrowPoint().equals((Object)starPoint)) break;
            this.client.clearHintArrow();
            break;
        }
    }

    @Nullable
    private World rsWorld(net.runelite.http.api.worlds.World world) {
        if (world == null) {
            return null;
        }
        assert (this.client.isClientThread());
        World rsWorld = this.client.createWorld();
        rsWorld.setActivity(world.getActivity());
        rsWorld.setAddress(world.getAddress());
        rsWorld.setId(world.getId());
        rsWorld.setPlayerCount(world.getPlayers());
        rsWorld.setLocation(world.getLocation());
        rsWorld.setTypes(WorldUtil.toWorldTypes((EnumSet)world.getTypes()));
        return rsWorld;
    }

    private Set<GroupKey> getOwningGroups(StarKey starKey) {
        Set<GroupKey> groups = this.owningGroups.get(starKey);
        if (groups == null) {
            groups = Collections.emptySet();
        }
        return groups;
    }

    private Map<String, GroupKey> getGroups() {
        return this.groups;
    }

    private void setGroups(Map<String, GroupKey> groups) {
        this.groups.clear();
        this.groups.putAll(groups);
    }

    private Map<String, GroupKey> loadGroups() {
        return this.loadGroups(this.config.groups());
    }

    private Map<String, GroupKey> loadGroups(String groupsJson) {
        JsonParser jsonParser = new JsonParser();
        try {
            JsonElement jsonElement = jsonParser.parse(groupsJson);
            if (jsonElement instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)jsonElement;
                HashMap<String, GroupKey> result = new HashMap<String, GroupKey>();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String groupName = (String)entry.getKey();
                    JsonElement groupKeyString = (JsonElement)entry.getValue();
                    GroupKey groupKey = new GroupKey(groupKeyString.getAsString());
                    result.put(groupName, groupKey);
                }
                return result;
            }
            log.error("groups must be defined as a json object!");
            return Collections.emptyMap();
        }
        catch (RuntimeException e) {
            log.error("Invalid groups JSON in config", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private Set<GroupKey> getSharingGroups(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(groupName.split(";")).flatMap(name -> {
            GroupKey key = this.getGroups().get(name);
            if (key == null) {
                return Stream.empty();
            }
            return Stream.of(key);
        }).collect(Collectors.toSet());
    }

    private Set<GroupKey> getSharingGroupsOwnFoundStars() {
        return this.getSharingGroups(this.config.getGroupsToShareFoundStarsWith());
    }

    private Set<GroupKey> getSharingGroupsFriendsChat() {
        return this.getSharingGroups(this.config.shareCallsReceivedByFriendsChat());
    }

    private Set<GroupKey> getSharingGroupsClanChat() {
        return this.getSharingGroups(this.config.shareCallsReceivedByClanChat());
    }

    private Set<GroupKey> getSharingGroupsPrivateChat() {
        return this.getSharingGroups(this.config.shareCallsReceivedByPrivateChat());
    }

    private Set<GroupKey> getSharingGroupsPublicChat() {
        return this.getSharingGroups(this.config.shareCallsReceivedByPublicChat());
    }

    private boolean shouldBroadcastStar(StarKey starKey) {
        if (!this.config.httpConnectionEnabled()) {
            return false;
        }
        WorldResult worldResult = this.worldService.getWorlds();
        boolean isPvP = worldResult != null && worldResult.findWorld(starKey.getWorld()).getTypes().contains(WorldType.PVP);
        boolean isWilderness = starKey.getLocation().isInWilderness();
        return !(!this.config.sharePvpWorldStars() && isPvP || !this.config.shareWildernessStars() && isWilderness);
    }

    public void receiveStars(StarList starList) {
        Map<Set<CrashedStar>, Set<GroupKey>> fresh = starList.getFreshStars();
        Set<StarUpdate> updates = starList.getStarUpdates();
        Set<StarKey> deleted = starList.getDeletedStars();
        for (Map.Entry<Set<CrashedStar>, Set<GroupKey>> entry : fresh.entrySet()) {
            Set<CrashedStar> freshStars = entry.getKey();
            Set<GroupKey> ownedBy = entry.getValue();
            this.starCache.addAll(freshStars);
            for (CrashedStar freshStar : freshStars) {
                this.owningGroups.computeIfAbsent(freshStar.getKey(), k -> new HashSet()).addAll(ownedBy);
            }
        }
        for (StarUpdate starUpdate : updates) {
            StarKey starKey = starUpdate.getKey();
            CrashedStar star = this.starCache.get(starKey);
            if (star == null) {
                this.starCache.add(new CrashedStar(starKey, starUpdate.getTier(), Instant.now(), User.unknown()));
                continue;
            }
            if (starUpdate.getTier().compareTo(star.getTier()) >= 0) continue;
            star.setTier(starUpdate.getTier());
        }
        for (StarKey deletedStar : deleted) {
            this.reportStarGone(deletedStar, false);
        }
        this.updatePanel();
    }

    public void reportStarNew(CrashedStar star, Set<GroupKey> groupsToShareTheStarWith) {
        boolean isNew;
        log.debug("reporting new star: " + star);
        StarKey starKey = star.getKey();
        boolean bl = isNew = this.starCache.add(star) == null;
        if (isNew) {
            this.updatePanel();
            this.owningGroups.put(starKey, groupsToShareTheStarWith);
        }
        if (this.config.shareFoundStars() && this.shouldBroadcastStar(starKey)) {
            CompletableFuture<Optional<CrashedStar>> upToDateStar = this.starClient.sendStar(groupsToShareTheStarWith, star);
            upToDateStar.whenCompleteAsync((optionalStar, ex) -> {
                if (ex != null) {
                    this.logServerError((Throwable)ex);
                } else if (optionalStar.isPresent()) {
                    CrashedStar receivedStar = (CrashedStar)optionalStar.get();
                    StarKey receivedStarKey = receivedStar.getKey();
                    this.clientThread.invoke(() -> {
                        CrashedStar existingStar = this.starCache.get(receivedStarKey);
                        if (existingStar == null) {
                            this.starCache.forceAdd(receivedStar);
                        }
                        this.updatePanel();
                    });
                }
            });
        }
    }

    public void reportStarUpdate(StarKey starKey, StarTier newTier, boolean broadcast) {
        log.debug("reporting star update: " + starKey + "->" + newTier);
        CrashedStar star = this.starCache.get(starKey);
        if (star.getTier() == newTier) {
            return;
        }
        star.setTier(newTier);
        this.updatePanel();
        if (broadcast && this.shouldBroadcastStar(starKey)) {
            Set<GroupKey> shareGroups = this.getOwningGroups(starKey);
            CompletableFuture<CrashedStar> upToDateStar = this.starClient.updateStar(shareGroups, starKey, newTier);
            upToDateStar.whenCompleteAsync((receivedStar, ex) -> {
                if (ex != null) {
                    this.logServerError((Throwable)ex);
                } else if (!receivedStar.equals(star)) {
                    this.clientThread.invoke(() -> {
                        this.starCache.forceAdd((CrashedStar)receivedStar);
                        this.updatePanel();
                    });
                }
            });
        }
    }

    public void reportStarGone(StarKey starKey, boolean broadcast) {
        log.debug("reporting star gone: " + starKey);
        Set<GroupKey> broadcastGroups = this.removeStar(starKey);
        this.updatePanel();
        if (broadcast && this.shouldBroadcastStar(starKey) && broadcastGroups != null) {
            CompletableFuture<Void> deleteAction = this.starClient.deleteStar(broadcastGroups, starKey);
            deleteAction.whenComplete((v, ex) -> {
                if (ex != null) {
                    this.logServerError((Throwable)ex);
                } else {
                    log.debug("star " + starKey + " deleted from server");
                }
            });
        }
    }

    @Nullable
    Set<GroupKey> removeStar(StarKey starKey) {
        assert (this.client.isClientThread());
        this.starCache.remove(starKey);
        return this.owningGroups.remove(starKey);
    }

    private void logServerError(Throwable ex) {
        log.warn("Unexpected result from web server", ex);
        if (ex instanceof ResponseException) {
            Call call = ((ResponseException)ex).getCall();
            log.debug("Request that caused it: " + call.request());
            Buffer buffer = new Buffer();
            try {
                call.request().body().writeTo((BufferedSink)buffer);
                log.debug("Request body: " + buffer.readString(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                log.error("Error reading call request body", (Throwable)e);
            }
        }
    }

    @Nullable
    WorldPoint getLocalPlayerLocation() {
        assert (this.client.isClientThread()) : "getLocalPlayerLocation must be called from the client thread!";
        Player localPlayer = this.client.getLocalPlayer();
        return localPlayer == null ? null : localPlayer.getWorldLocation();
    }

    private void updatePanel() {
        log.debug("Panel repaint!");
        assert (this.client.isClientThread()) : "updatePanel must be called from the client thread!";
        HashSet<CrashedStar> stars = new HashSet<CrashedStar>(this.starCache.getStars());
        WorldPoint playerLocation = this.getLocalPlayerLocation();
        SwingUtilities.invokeLater(() -> this.panel.setStars(stars, playerLocation));
    }

    private boolean playerInStarRange(WorldPoint starLocation) {
        return this.playerInRange(starLocation, 25);
    }

    private boolean playerInRange(WorldPoint worldPoint, int distance) {
        return StarAssistPlugin.inManhattanRange(this.client.getLocalPlayer().getWorldLocation(), worldPoint, distance);
    }

    private static boolean inManhattanRange(WorldPoint playerLoc, WorldPoint targetLoc, int distance) {
        int playerX = playerLoc.getX();
        int playerY = playerLoc.getY();
        int starX = targetLoc.getX();
        int starY = targetLoc.getY();
        return playerLoc.getPlane() == targetLoc.getPlane() && starX - distance <= playerX && playerX <= starX + distance && starY - distance <= playerY && playerY <= starY + distance;
    }

    private static StarTier getStar(Tile tile) {
        for (GameObject gameObject : tile.getGameObjects()) {
            StarTier starTier;
            if (gameObject == null || (starTier = StarIds.getTier(gameObject.getId())) == null) continue;
            return starTier;
        }
        return null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if ("F2P Star Assist".equals(event.getGroup())) {
            if ("groups".equals(event.getKey())) {
                try {
                    this.setGroups(this.loadGroups(event.getNewValue()));
                }
                catch (RuntimeException e) {
                    log.error("Invalid groups JSON in config", (Throwable)e);
                }
            } else if ("hint enabled".equals(event.getKey())) {
                this.showHintArrow(Boolean.parseBoolean(event.getNewValue()));
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.showHintArrow(this.config.hintArrowEnabled());
        }
    }

    @Subscribe
    public void onWorldChanged(WorldChanged event) {
        this.showHintArrow(this.config.hintArrowEnabled());
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        for (CrashedStar star : this.starCache.getStars()) {
            WorldPoint starPoint;
            if (this.client.getWorld() != star.getWorld() || (starPoint = StarPoints.fromLocation(star.getLocation())) == null || !this.playerInStarRange(starPoint)) continue;
            LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)starPoint);
            Tile tile = this.client.getScene().getTiles()[starPoint.getPlane()][localPoint.getSceneX()][localPoint.getSceneY()];
            StarTier starTier = StarAssistPlugin.getStar(tile);
            if (starTier == null) {
                this.clientThread.invokeLater(() -> {
                    if (StarAssistPlugin.getStar(tile) == null) {
                        this.reportStarGone(star.getKey(), true);
                        if (starPoint.equals((Object)this.client.getHintArrowPoint())) {
                            this.client.clearHintArrow();
                        }
                    }
                });
                continue;
            }
            if (!this.playerInRange(starPoint, 4) || !starPoint.equals((Object)this.client.getHintArrowPoint())) continue;
            this.client.clearHintArrow();
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        StarTier starTier = StarIds.getTier(gameObject.getId());
        if (starTier == null) {
            return;
        }
        WorldPoint worldPoint = gameObject.getWorldLocation();
        StarLocation starLocation = StarPoints.toLocation(worldPoint);
        if (starLocation == null) {
            log.error("Unrecognised star location at world point: " + worldPoint);
            return;
        }
        StarKey starKey = new StarKey(starLocation, this.client.getWorld());
        log.debug("A " + starTier + " star spawned at location: " + worldPoint + ".");
        CrashedStar knownStar = this.starCache.get(starKey);
        if (knownStar == null) {
            CrashedStar newStar = new CrashedStar(starKey, starTier, Instant.now(), new RunescapeUser(this.client.getLocalPlayer().getName()));
            this.reportStarNew(newStar, this.getSharingGroupsOwnFoundStars());
        } else {
            StarTier upToDateTier = StarIds.getTier(gameObject.getId());
            if (upToDateTier != null) {
                this.reportStarUpdate(starKey, upToDateTier, true);
            }
        }
        if (this.config.hintArrowEnabled() && !this.client.hasHintArrow()) {
            this.client.setHintArrow(worldPoint);
        }
    }

    private boolean isWorld(int world) {
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null) {
            return false;
        }
        return worldResult.findWorld(world) != null;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String message = event.getMessage();
        switch (event.getType()) {
            case FRIENDSCHAT: {
                int world;
                StarLocation location;
                StarTier tier;
                if (!this.config.interpretFriendsChat() || (tier = StarLingo.interpretTier(message)) == null || (location = StarLingo.interpretLocation(message)) == null || (world = StarLingo.interpretWorld(message)) == -1 || !this.isWorld(world)) break;
                CrashedStar star = new CrashedStar(tier, location, world, Instant.now(), new RunescapeUser(TextUtil.stripChatIcon(event.getName())));
                this.reportStarNew(star, this.getSharingGroupsFriendsChat());
                break;
            }
            case CLAN_CHAT: {
                int world;
                StarLocation location;
                StarTier tier;
                if (!this.config.interpretClanChat() || (tier = StarLingo.interpretTier(message)) == null || (location = StarLingo.interpretLocation(message)) == null || (world = StarLingo.interpretWorld(message)) == -1 || !this.isWorld(world)) break;
                CrashedStar star = new CrashedStar(tier, location, world, Instant.now(), new RunescapeUser(TextUtil.stripChatIcon(event.getName())));
                this.reportStarNew(star, this.getSharingGroupsClanChat());
                break;
            }
            case PRIVATECHAT: 
            case MODPRIVATECHAT: {
                int world;
                StarLocation location;
                StarTier tier;
                if (!this.config.interpretPrivateChat() || (tier = StarLingo.interpretTier(message)) == null || (location = StarLingo.interpretLocation(message)) == null || (world = StarLingo.interpretWorld(message)) == -1 || !this.isWorld(world)) break;
                CrashedStar star = new CrashedStar(tier, location, world, Instant.now(), new RunescapeUser(TextUtil.stripChatIcon(event.getName())));
                this.reportStarNew(star, this.getSharingGroupsPrivateChat());
                break;
            }
            case PUBLICCHAT: 
            case MODCHAT: {
                int world;
                StarLocation location;
                StarTier tier;
                if (!this.config.interpretPublicChat() || (tier = StarLingo.interpretTier(message)) == null || (location = StarLingo.interpretLocation(message)) == null || (world = StarLingo.interpretWorld(message)) == -1 || !this.isWorld(world)) break;
                CrashedStar star = new CrashedStar(tier, location, world, Instant.now(), new RunescapeUser(TextUtil.stripChatIcon(event.getName())));
                this.reportStarNew(star, this.getSharingGroupsPublicChat());
            }
        }
    }
}

