/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.f2pstarassist.plugin;

import com.janboerman.f2pstarassist.plugin.StarAssistConfig;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class DoubleHoppingTilesOverlay
extends Overlay {
    private static final DoubleHoppingTile[] doubleHoppingTiles = new DoubleHoppingTile[]{new DoubleHoppingTile("Crafting Guild / Rimmington hopping location", new WorldPoint(2958, 3265, 0)), new DoubleHoppingTile("Desert mine / PvP Arena hopping location", new WorldPoint(3323, 3289, 0)), new DoubleHoppingTile("Varrock west bank hopping location", new WorldPoint(3264, 3384, 0)), new DoubleHoppingTile("Varrock south east mine hopping location", new WorldPoint(3264, 3383, 0)), new DoubleHoppingTile("Al Kharid bank hopping location", new WorldPoint(3248, 3186, 0)), new DoubleHoppingTile("Lumbridge Swamp east mine hopping location", new WorldPoint(3246, 3183, 0))};
    private static final int MAX_DRAW_DISTANCE = 32;
    private final Client client;
    private final StarAssistConfig config;

    @Inject
    public DoubleHoppingTilesOverlay(Client client, StarAssistConfig config) {
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.markDoubleHoppingTiles()) {
            return null;
        }
        BasicStroke stroke = new BasicStroke(2.0f);
        for (DoubleHoppingTile tile : doubleHoppingTiles) {
            if (tile.worldPoint.getPlane() != this.client.getPlane()) continue;
            Color tileColour = new Color(0, 94, 53);
            this.drawTile(graphics, tile.worldPoint, tileColour, tile.label, stroke);
        }
        return null;
    }

    private void drawTile(Graphics2D graphics, WorldPoint point, Color colour, String label, Stroke borderStroke) {
        Point canvasTextLocation;
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (point.distanceTo(playerLocation) >= 32) {
            return;
        }
        LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        if (localPoint == null) {
            return;
        }
        Polygon polygon = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)localPoint);
        if (polygon != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)polygon, (Color)colour, (Color)new Color(0, 0, 0, 50), (Stroke)borderStroke);
        }
        if ((canvasTextLocation = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)localPoint, (String)label, (int)0)) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)canvasTextLocation, (String)label, (Color)colour);
        }
    }

    private static final class DoubleHoppingTile {
        private WorldPoint worldPoint;
        private String label;

        private DoubleHoppingTile(String label, WorldPoint worldPoint) {
            this.worldPoint = worldPoint;
            this.label = label;
        }
    }
}

