/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.f2pstarassist.common.web;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.janboerman.f2pstarassist.common.CrashedStar;
import com.janboerman.f2pstarassist.common.DiscordUser;
import com.janboerman.f2pstarassist.common.GroupKey;
import com.janboerman.f2pstarassist.common.Payload;
import com.janboerman.f2pstarassist.common.RunescapeUser;
import com.janboerman.f2pstarassist.common.StarKey;
import com.janboerman.f2pstarassist.common.StarList;
import com.janboerman.f2pstarassist.common.StarLocation;
import com.janboerman.f2pstarassist.common.StarPacket;
import com.janboerman.f2pstarassist.common.StarRequest;
import com.janboerman.f2pstarassist.common.StarTier;
import com.janboerman.f2pstarassist.common.StarUpdate;
import com.janboerman.f2pstarassist.common.User;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class StarJson {
    private StarJson() {
    }

    public static StarList starList(JsonObject starList) {
        Map<Set<CrashedStar>, Set<GroupKey>> freshStars = StarJson.readFreshStars(starList);
        Set<StarUpdate> starUpdates = StarJson.readStarUpdates(starList);
        Set<StarKey> deletedStars = StarJson.readDeletedStars(starList);
        return new StarList(freshStars, starUpdates, deletedStars);
    }

    public static JsonObject starListJson(StarList starList) {
        JsonObject result = new JsonObject();
        StarJson.writeFreshStars(result, starList.getFreshStars());
        StarJson.writeStarUpdates(result, starList.getStarUpdates());
        StarJson.writeDeletedStars(result, starList.getDeletedStars());
        return result;
    }

    public static StarRequest starRequest(JsonArray starRequest) {
        return new StarRequest(StarJson.crashedStars(starRequest));
    }

    public static JsonArray starRequestJson(StarRequest starRequest) {
        return StarJson.crashedStarsJson(starRequest.getKnownStars());
    }

    public static StarPacket starPacket(JsonObject starPacket) {
        Set<GroupKey> groups = StarJson.readGroupKeys(starPacket);
        Payload payload = StarJson.readPayload(starPacket);
        return new StarPacket(groups, payload);
    }

    public static JsonObject starPacketJson(StarPacket packet) {
        JsonObject result = new JsonObject();
        StarJson.writeGroupKeys(result, packet.getGroups());
        StarJson.writePayload(result, packet.getPayload());
        return result;
    }

    public static CrashedStar crashedStar(JsonObject crashedStar) {
        StarTier tier = StarJson.readTier(crashedStar);
        StarLocation location = StarJson.readLocation(crashedStar);
        int world = StarJson.readWorld(crashedStar);
        Instant detectedAt = StarJson.readDetectedAt(crashedStar);
        User discoveredBy = StarJson.readDiscoveredBy(crashedStar);
        return new CrashedStar(tier, location, world, detectedAt, discoveredBy);
    }

    public static JsonObject crashedStarJson(CrashedStar crashedStar) {
        JsonObject result = new JsonObject();
        StarJson.writeTier(result, crashedStar.getTier());
        StarJson.writeLocation(result, crashedStar.getLocation());
        StarJson.writeWorld(result, crashedStar.getWorld());
        StarJson.writeDetectedAt(result, crashedStar.getDetectedAt());
        StarJson.writeDiscoveredBy(result, crashedStar.getDiscoveredBy());
        return result;
    }

    public static Set<CrashedStar> crashedStars(JsonArray jsonArray) {
        TreeSet<CrashedStar> result = new TreeSet<CrashedStar>();
        for (JsonElement element : jsonArray) {
            if (!(element instanceof JsonObject)) continue;
            JsonObject jsonObject = (JsonObject)element;
            result.add(StarJson.crashedStar(jsonObject));
        }
        return result;
    }

    public static JsonArray crashedStarsJson(Set<CrashedStar> crashedStars) {
        JsonArray jsonArray = new JsonArray(crashedStars.size());
        for (CrashedStar star : crashedStars) {
            jsonArray.add((JsonElement)StarJson.crashedStarJson(star));
        }
        return jsonArray;
    }

    public static StarUpdate starUpdate(JsonObject starUpdate) {
        StarTier tier = StarJson.readTier(starUpdate);
        StarLocation location = StarJson.readLocation(starUpdate);
        int world = StarJson.readWorld(starUpdate);
        return new StarUpdate(tier, location, world);
    }

    public static JsonObject starUpdateJson(StarUpdate starUpdate) {
        JsonObject result = new JsonObject();
        StarJson.writeTier(result, starUpdate.getTier());
        StarJson.writeLocation(result, starUpdate.getLocation());
        StarJson.writeWorld(result, starUpdate.getWorld());
        return result;
    }

    public static Set<StarUpdate> starUpdates(JsonArray jsonArray) {
        return StreamSupport.stream(jsonArray.spliterator(), false).filter(jsonElement -> jsonElement instanceof JsonObject).map(jsonElement -> StarJson.starUpdate((JsonObject)jsonElement)).collect(Collectors.toSet());
    }

    public static JsonArray starUpdatesJson(Set<StarUpdate> starUpdates) {
        return starUpdates.stream().map(StarJson::starUpdateJson).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
    }

    public static StarKey starKey(JsonObject starKey) {
        StarLocation starLocation = StarJson.readLocation(starKey);
        int world = StarJson.readWorld(starKey);
        return new StarKey(starLocation, world);
    }

    public static JsonObject starKeyJson(StarKey starKey) {
        JsonObject result = new JsonObject();
        StarJson.writeLocation(result, starKey.getLocation());
        StarJson.writeWorld(result, starKey.getWorld());
        return result;
    }

    public static Set<StarKey> starKeys(JsonArray jsonArray) {
        return StreamSupport.stream(jsonArray.spliterator(), false).filter(jsonElement -> jsonElement instanceof JsonObject).map(jsonElement -> StarJson.starKey((JsonObject)jsonElement)).collect(Collectors.toSet());
    }

    public static JsonArray starKeysJson(Set<StarKey> deletedStars) {
        return deletedStars.stream().map(StarJson::starKeyJson).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
    }

    public static Set<GroupKey> groupKeys(JsonArray groupKeys) {
        return StreamSupport.stream(groupKeys.spliterator(), false).map(jsonElem -> new GroupKey(jsonElem.getAsString())).collect(Collectors.toSet());
    }

    public static JsonArray groupKeysJson(Set<GroupKey> groupKeys) {
        return groupKeys.stream().map(groupKey -> new JsonPrimitive(groupKey.toString())).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
    }

    private static StarTier readTier(JsonObject crashedStar) {
        return StarTier.bySize(crashedStar.get("tier").getAsInt());
    }

    private static void writeTier(JsonObject crashedStar, StarTier tier) {
        crashedStar.add("tier", (JsonElement)new JsonPrimitive((Number)tier.getSize()));
    }

    private static StarLocation readLocation(JsonObject crashedStar) {
        String locationString = crashedStar.get("location").getAsString();
        if ("DUEL_ARENA".equals(locationString)) {
            return StarLocation.PVP_ARENA;
        }
        return StarLocation.valueOf(locationString);
    }

    private static void writeLocation(JsonObject crashedStar, StarLocation starLocation) {
        crashedStar.add("location", (JsonElement)new JsonPrimitive(starLocation.name()));
    }

    private static int readWorld(JsonObject crashedStar) {
        return crashedStar.get("world").getAsInt();
    }

    private static void writeWorld(JsonObject crashedStar, int world) {
        crashedStar.add("world", (JsonElement)new JsonPrimitive((Number)world));
    }

    private static Instant readDetectedAt(JsonObject crashedStar) {
        return Instant.ofEpochMilli(crashedStar.get("detected at").getAsLong());
    }

    private static void writeDetectedAt(JsonObject crashedStar, Instant detectedAt) {
        crashedStar.add("detected at", (JsonElement)new JsonPrimitive((Number)detectedAt.toEpochMilli()));
    }

    private static User readDiscoveredBy(JsonObject crashedStar) {
        String type;
        JsonElement jsonElement = crashedStar.get("discovered by");
        if (jsonElement == null) {
            return User.unknown();
        }
        JsonObject user = jsonElement.getAsJsonObject();
        switch (type = user.get("type").getAsString()) {
            case "RuneScape": {
                return new RunescapeUser(user.get("name").getAsString());
            }
            case "Discord": {
                return new DiscordUser(user.get("name").getAsString());
            }
        }
        return User.unknown();
    }

    private static void writeDiscoveredBy(JsonObject crashedStar, User discoveredBy) {
        if (discoveredBy instanceof RunescapeUser) {
            RunescapeUser user = (RunescapeUser)discoveredBy;
            JsonObject jsonUser = new JsonObject();
            jsonUser.add("type", (JsonElement)new JsonPrimitive("RuneScape"));
            jsonUser.add("name", (JsonElement)new JsonPrimitive(user.getName()));
            crashedStar.add("discovered by", (JsonElement)jsonUser);
        } else if (discoveredBy instanceof DiscordUser) {
            DiscordUser user = (DiscordUser)discoveredBy;
            JsonObject jsonUser = new JsonObject();
            jsonUser.add("type", (JsonElement)new JsonPrimitive("Discord"));
            jsonUser.add("name", (JsonElement)new JsonPrimitive(user.getName()));
            crashedStar.add("discovered by", (JsonElement)jsonUser);
        }
    }

    private static Set<GroupKey> readGroupKeys(JsonObject starPacket) {
        JsonArray jsonArray = starPacket.getAsJsonArray("groups");
        return StarJson.groupKeys(jsonArray);
    }

    private static void writeGroupKeys(JsonObject starPacket, Set<GroupKey> groupKeys) {
        starPacket.add("groups", (JsonElement)StarJson.groupKeysJson(groupKeys));
    }

    private static Payload readPayload(JsonObject starPacket) {
        String type;
        JsonElement payload = starPacket.get("payload");
        switch (type = starPacket.get("type").getAsString()) {
            case "star key": {
                JsonObject starKeyPayload = (JsonObject)payload;
                return StarJson.starKey(starKeyPayload);
            }
            case "crashed star": {
                JsonObject crashedStarPayload = (JsonObject)payload;
                return StarJson.crashedStar(crashedStarPayload);
            }
            case "star update": {
                JsonObject starUpdatePayload = (JsonObject)payload;
                return StarJson.starUpdate(starUpdatePayload);
            }
            case "star request": {
                JsonArray starRequestPayload = (JsonArray)payload;
                return StarJson.starRequest(starRequestPayload);
            }
        }
        return null;
    }

    private static void writePayload(JsonObject starPacket, Payload payload) {
        if (payload instanceof StarKey) {
            StarKey starKey = (StarKey)payload;
            starPacket.add("type", (JsonElement)new JsonPrimitive("star key"));
            starPacket.add("payload", (JsonElement)StarJson.starKeyJson(starKey));
        } else if (payload instanceof CrashedStar) {
            CrashedStar crashedStar = (CrashedStar)payload;
            starPacket.add("type", (JsonElement)new JsonPrimitive("crashed star"));
            starPacket.add("payload", (JsonElement)StarJson.crashedStarJson(crashedStar));
        } else if (payload instanceof StarUpdate) {
            StarUpdate starUpdate = (StarUpdate)payload;
            starPacket.add("type", (JsonElement)new JsonPrimitive("star update"));
            starPacket.add("payload", (JsonElement)StarJson.starUpdateJson(starUpdate));
        } else if (payload instanceof StarRequest) {
            StarRequest starRequest = (StarRequest)payload;
            starPacket.add("type", (JsonElement)new JsonPrimitive("star request"));
            starPacket.add("payload", (JsonElement)StarJson.starRequestJson(starRequest));
        }
    }

    private static void writeFreshStars(JsonObject starList, Map<Set<CrashedStar>, Set<GroupKey>> freshStars) {
        JsonArray fresh = new JsonArray();
        for (Map.Entry<Set<CrashedStar>, Set<GroupKey>> entry : freshStars.entrySet()) {
            JsonObject jsonEntry = new JsonObject();
            jsonEntry.add("stars", (JsonElement)StarJson.crashedStarsJson(entry.getKey()));
            jsonEntry.add("owned by", (JsonElement)StarJson.groupKeysJson(entry.getValue()));
            fresh.add((JsonElement)jsonEntry);
        }
        starList.add("fresh", (JsonElement)fresh);
    }

    private static Map<Set<CrashedStar>, Set<GroupKey>> readFreshStars(JsonObject starList) {
        LinkedHashMap<Set<CrashedStar>, Set<GroupKey>> result = new LinkedHashMap<Set<CrashedStar>, Set<GroupKey>>();
        JsonArray fresh = starList.getAsJsonArray("fresh");
        for (JsonElement jsonEntry : fresh) {
            JsonObject entry = (JsonObject)jsonEntry;
            Set<CrashedStar> stars = StarJson.crashedStars(entry.getAsJsonArray("stars"));
            Set<GroupKey> ownedBy = StarJson.groupKeys(entry.getAsJsonArray("owned by"));
            result.put(stars, ownedBy);
        }
        return result;
    }

    private static void writeStarUpdates(JsonObject starList, Set<StarUpdate> starUpdates) {
        starList.add("updates", (JsonElement)StarJson.starUpdatesJson(starUpdates));
    }

    private static Set<StarUpdate> readStarUpdates(JsonObject starList) {
        return StarJson.starUpdates(starList.getAsJsonArray("updates"));
    }

    private static void writeDeletedStars(JsonObject starList, Set<StarKey> deletedStars) {
        starList.add("deleted", (JsonElement)StarJson.starKeysJson(deletedStars));
    }

    public static Set<StarKey> readDeletedStars(JsonObject starList) {
        return StarJson.starKeys(starList.getAsJsonArray("deleted"));
    }
}

