/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.f2pstarassist.common.lingo;

import com.janboerman.f2pstarassist.common.StarLocation;
import com.janboerman.f2pstarassist.common.StarTier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StarLingo {
    private static final Pattern TIER_PATTERN = Pattern.compile(".*?[t|T|s|S](ier|ize)?\\s*(?<tier>[1-9]).*");
    private static final Pattern WORLD_PATTERN = Pattern.compile(".*?([w|W](orld)?)?\\s*(?<world>\\d{3}).*");

    private StarLingo() {
    }

    public static int interpretWorld(String text) {
        Matcher matcher = WORLD_PATTERN.matcher(text);
        if (matcher.matches()) {
            String world = matcher.group("world");
            return Integer.parseInt(world);
        }
        return -1;
    }

    public static StarTier interpretTier(String text) {
        Matcher matcher = TIER_PATTERN.matcher(text);
        if (matcher.matches()) {
            String tier;
            switch (tier = matcher.group("tier")) {
                case "9": {
                    return StarTier.SIZE_9;
                }
                case "8": {
                    return StarTier.SIZE_8;
                }
                case "7": {
                    return StarTier.SIZE_7;
                }
                case "6": {
                    return StarTier.SIZE_6;
                }
                case "5": {
                    return StarTier.SIZE_5;
                }
                case "4": {
                    return StarTier.SIZE_4;
                }
                case "3": {
                    return StarTier.SIZE_3;
                }
                case "2": {
                    return StarTier.SIZE_2;
                }
                case "1": {
                    return StarTier.SIZE_1;
                }
            }
        }
        return null;
    }

    public static StarLocation interpretLocation(String text) {
        if (StarLingo.containsAnyIgnoreCase(text, "dwarf", "dwarven")) {
            return StarLocation.DWARVEN_MINE;
        }
        if (StarLingo.containsAnyIgnoreCase(text, "falador", "fally", "mining guild")) {
            return StarLocation.MINING_GUILD;
        }
        if (StarLingo.containsIgnoreCase(text, "craft")) {
            return StarLocation.CRAFTING_GUILD;
        }
        if (StarLingo.containsIgnoreCase(text, "rim")) {
            return StarLocation.RIMMINGTON_MINE;
        }
        if (StarLingo.containsIgnoreCase(text, "draynor")) {
            return StarLocation.DRAYNOR_VILLAGE_BANK;
        }
        if (StarLingo.containsAnyIgnoreCase(text, "lumbridge", "swamp", "lumby")) {
            if (StarLingo.containsAnyIgnoreCase(text, "east", "se")) {
                return StarLocation.LUMBRIDGE_SWAMP_SOUTH_EAST_MINE;
            }
            if (StarLingo.containsAnyIgnoreCase(text, "west", "sw")) {
                return StarLocation.LUMBRIDGE_SWAMP_SOUTH_WEST_MINE;
            }
        }
        if (StarLingo.containsAnyIgnoreCase(text, "lsw", "lmw", "swl")) {
            return StarLocation.LUMBRIDGE_SWAMP_SOUTH_WEST_MINE;
        }
        if (StarLingo.containsAnyIgnoreCase(text, "lse", "lme", "sel")) {
            return StarLocation.LUMBRIDGE_SWAMP_SOUTH_EAST_MINE;
        }
        if (StarLingo.containsIgnoreCase(text, "varrock")) {
            if (StarLingo.containsIgnoreCase(text, "bank")) {
                return StarLocation.VARROCK_AUBURY;
            }
            if (StarLingo.containsAnyIgnoreCase(text, "west", "sw")) {
                return StarLocation.VARROCK_SOUTH_WEST_MINE;
            }
            if (StarLingo.containsAnyIgnoreCase(text, "east", "se")) {
                return StarLocation.VARROCK_SOUTH_EAST_MINE;
            }
            return StarLocation.VARROCK_AUBURY;
        }
        if (StarLingo.containsIgnoreCase(text, "aubury")) {
            return StarLocation.VARROCK_AUBURY;
        }
        if (StarLingo.containsAnyIgnoreCase(text, "vsw", "vmw", "swv") || StarLingo.containsAllIgnoreCase(text, "champ", "guild")) {
            return StarLocation.VARROCK_SOUTH_WEST_MINE;
        }
        if (StarLingo.containsAnyIgnoreCase(text, "vse", "vme", "sev")) {
            return StarLocation.VARROCK_SOUTH_EAST_MINE;
        }
        if (StarLingo.containsIgnoreCase(text, "veb")) {
            return StarLocation.VARROCK_AUBURY;
        }
        if (StarLingo.containsAllIgnoreCase(text, "al", "kharid") || StarLingo.containsAnyIgnoreCase(text, "alk", "ally", "ak")) {
            if (StarLingo.containsIgnoreCase(text, "bank")) {
                return StarLocation.AL_KHARID_BANK;
            }
            if (StarLingo.containsIgnoreCase(text, "mine")) {
                return StarLocation.AL_KHARID_MINE;
            }
        }
        if (StarLingo.containsAllIgnoreCase(text, "desert", "mine")) {
            return StarLocation.AL_KHARID_MINE;
        }
        if (StarLingo.containsAnyIgnoreCase(text, "duel", "da", "arena", "pvp", "pa")) {
            return StarLocation.PVP_ARENA;
        }
        if (StarLingo.containsIgnoreCase(text, "crandor")) {
            if (StarLingo.containsIgnoreCase(text, "north")) {
                return StarLocation.CRANDOR_NORTH_MINE;
            }
            if (StarLingo.containsIgnoreCase(text, "south")) {
                return StarLocation.CRANDOR_SOUTH_MINE;
            }
        }
        if (StarLingo.containsIgnoreCase(text, "corsair")) {
            if (StarLingo.containsIgnoreCase(text, "bank")) {
                return StarLocation.CORSAIR_COVE_BANK;
            }
            return StarLocation.CORSAIR_COVE_RESOURCE_AREA;
        }
        if (StarLingo.containsAnyIgnoreCase(text, "wildy", "wilderness")) {
            if (StarLingo.containsAnyIgnoreCase(text, "centre", "center", "bandit", "camp", "hobgoblins")) {
                return StarLocation.WILDERNESS_CENTRE_MINE;
            }
            if (StarLingo.containsAnyIgnoreCase(text, "dark", "warrior", "fortress", "skeles", "skeletons") || StarLingo.containsAllIgnoreCase(text, "south", "west")) {
                return StarLocation.WILDERNESS_SOUTH_WEST_MINE;
            }
            if (StarLingo.containsIgnoreCase(text, "south") && !StarLingo.containsIgnoreCase(text, "west") || StarLingo.containsAnyIgnoreCase(text, "mage", "zamorak", "zammy")) {
                return StarLocation.WILDERNESS_SOUTH_MINE;
            }
        }
        if (StarLingo.containsAnyIgnoreCase(text, "rune", "runite", "lava", "maze", "rr")) {
            return StarLocation.WILDERNESS_RUNITE_MINE;
        }
        return null;
    }

    public static boolean containsAnyIgnoreCase(String string, String ... lookups) {
        for (String lookup : lookups) {
            if (!StarLingo.containsIgnoreCase(string, lookup)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllIgnoreCase(String string, String ... lookups) {
        for (String lookup : lookups) {
            if (StarLingo.containsIgnoreCase(string, lookup)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsIgnoreCase(String string, String lookup) {
        return string.toLowerCase().contains(lookup.toLowerCase());
    }
}

