/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.f2pstarassist.common;

import com.janboerman.f2pstarassist.common.Payload;
import com.janboerman.f2pstarassist.common.StarKey;
import com.janboerman.f2pstarassist.common.StarLocation;
import com.janboerman.f2pstarassist.common.StarTier;
import java.util.Objects;

public final class StarUpdate
implements Payload {
    private final StarLocation location;
    private final int world;
    private final StarTier tier;

    public StarUpdate(StarTier tier, StarLocation location, int world) {
        this.tier = Objects.requireNonNull(tier);
        this.location = Objects.requireNonNull(location);
        this.world = world;
    }

    public StarUpdate(StarKey starKey, StarTier tier) {
        this(tier, starKey.getLocation(), starKey.getWorld());
    }

    public StarLocation getLocation() {
        return this.location;
    }

    public int getWorld() {
        return this.world;
    }

    public StarTier getTier() {
        return this.tier;
    }

    public StarKey getKey() {
        return new StarKey(this.getLocation(), this.getWorld());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getLocation(), this.getWorld(), this.getTier()});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StarUpdate)) {
            return false;
        }
        StarUpdate that = (StarUpdate)o;
        return this.getLocation() == that.getLocation() && this.getWorld() == that.getWorld() && this.getTier() == that.getTier();
    }

    public String toString() {
        return "StarUpdate{location=" + this.getLocation() + ",world=" + this.getWorld() + ",tier=" + this.getTier() + "}";
    }
}

