/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.f2pstarassist.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.janboerman.f2pstarassist.common.CrashedStar;
import com.janboerman.f2pstarassist.common.StarKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;

public class StarCache {
    private final Cache<StarKey, CrashedStar> cache;

    private static CacheBuilder<StarKey, CrashedStar> newCacheBuilder() {
        return CacheBuilder.newBuilder();
    }

    private StarCache(CacheBuilder<StarKey, CrashedStar> cacheBuilder) {
        this.cache = cacheBuilder.expireAfterWrite(150L, TimeUnit.MINUTES).build();
    }

    public StarCache(RemovalListener<StarKey, CrashedStar> removalListener) {
        this((CacheBuilder<StarKey, CrashedStar>)StarCache.newCacheBuilder().removalListener(removalListener));
    }

    public StarCache() {
        this(StarCache.newCacheBuilder());
    }

    public CrashedStar add(CrashedStar newStar) {
        StarKey key = newStar.getKey();
        CrashedStar oldStar = (CrashedStar)this.cache.getIfPresent((Object)key);
        if (oldStar != null) {
            if (newStar.getTier().getSize() > oldStar.getTier().getSize()) {
                this.cache.put((Object)key, (Object)newStar);
            }
        } else {
            this.cache.put((Object)key, (Object)newStar);
        }
        return oldStar;
    }

    public boolean addAll(Collection<CrashedStar> stars) {
        boolean result = false;
        for (CrashedStar star : stars) {
            result |= this.add(star) == null;
        }
        return result;
    }

    public CrashedStar get(StarKey key) {
        CrashedStar crashedStar = (CrashedStar)this.cache.getIfPresent((Object)key);
        if (crashedStar == null || crashedStar.getDetectedAt().isBefore(Instant.now().minus(2L, ChronoUnit.HOURS))) {
            return null;
        }
        return crashedStar;
    }

    public CrashedStar forceAdd(CrashedStar star) {
        return this.cache.asMap().put(star.getKey(), star);
    }

    public CrashedStar remove(StarKey starKey) {
        CrashedStar existing = this.get(starKey);
        this.cache.invalidate((Object)starKey);
        return existing;
    }

    public boolean contains(StarKey starKey) {
        return this.get(starKey) != null;
    }

    public Set<CrashedStar> getStars() {
        return new HashSet<CrashedStar>(this.cache.asMap().values());
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", "StarCache{", "}");
        for (Map.Entry entry : this.cache.asMap().entrySet()) {
            stringJoiner.add(entry.getKey() + "=" + ((CrashedStar)entry.getValue()).getTier());
        }
        return stringJoiner.toString();
    }
}

