/*
 * Decompiled with CFR 0.152.
 */
package com.timeplayed;

import com.google.inject.Provides;
import com.timeplayed.TimePlayedConfig;
import com.timeplayed.TimePlayedOverlay;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.RuneScapeProfileChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Time Played", description="Displays time played", enabledByDefault=true, tags={"time played, playtime, play, time, timer, ingame, in game"})
public class TimePlayedPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TimePlayedPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TimePlayedOverlay myOverlay;
    @Inject
    private TimePlayedConfig config;
    @Inject
    private ConfigManager configManager;
    private boolean paused = true;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.myOverlay);
        this.myOverlay.seconds = this.getStoredSeconds();
        this.myOverlay.minutes = this.getStoredMinutes();
    }

    protected void shutDown() throws Exception {
        Widget reportButton;
        if ((this.config.clearReportButton() || this.config.showOnReportButton()) && (reportButton = this.client.getWidget(WidgetInfo.CHATBOX_REPORT_TEXT)) != null) {
            reportButton.setText("Report");
        }
        this.setStoredSeconds(this.myOverlay.seconds);
        this.setStoredMinutes(this.myOverlay.minutes);
        this.overlayManager.remove((Overlay)this.myOverlay);
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        Widget reportButton;
        if (!event.getGroup().equals("timeplayed")) {
            return;
        }
        if (event.getKey().equals("ontop")) {
            if (this.config.ontop()) {
                this.myOverlay.setLayer(OverlayLayer.ABOVE_WIDGETS);
            } else {
                this.myOverlay.setLayer(OverlayLayer.ABOVE_SCENE);
            }
        }
        if ((event.getKey().equals("showonreportbutton") || event.getKey().equals("clearreportbutton")) && (reportButton = this.client.getWidget(WidgetInfo.CHATBOX_REPORT_TEXT)) != null) {
            if (this.config.showOnReportButton() || this.config.clearReportButton()) {
                reportButton.setText("");
            } else {
                reportButton.setText("Report");
            }
        }
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING || event.getGameState() == GameState.LOGGED_IN || event.getGameState() == GameState.CONNECTION_LOST) {
            if (this.paused) {
                int timePlayed;
                this.paused = false;
                this.myOverlay.seconds = this.getStoredSeconds();
                this.myOverlay.minutes = this.getStoredMinutes();
                if (this.myOverlay.minutes == 0) {
                    this.myOverlay.minutes = this.client.getVarcIntValue(526);
                }
                this.myOverlay.seconds += 12;
                if (this.myOverlay.seconds >= 600) {
                    ++this.myOverlay.minutes;
                    this.myOverlay.seconds -= 600;
                }
                if ((timePlayed = this.client.getVarcIntValue(526)) > this.myOverlay.minutes) {
                    this.myOverlay.minutes = timePlayed;
                    this.myOverlay.seconds = 0;
                }
            }
        } else if (!this.paused) {
            this.paused = true;
            this.setStoredSeconds(this.myOverlay.seconds);
            this.setStoredMinutes(this.myOverlay.minutes);
        }
    }

    @Subscribe
    public void onRuneScapeProfileChanged(RuneScapeProfileChanged event) {
        this.myOverlay.seconds = this.getStoredSeconds();
        this.myOverlay.minutes = this.getStoredMinutes();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.myOverlay == null) {
            return;
        }
        this.myOverlay.lastTick = Instant.now().toEpochMilli();
        this.myOverlay.msOffset = 0;
        this.myOverlay.seconds += 6;
        if (this.myOverlay.seconds >= 600) {
            ++this.myOverlay.minutes;
            this.myOverlay.seconds -= 600;
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int timePlayed = this.client.getVarcIntValue(526);
        if (timePlayed > this.myOverlay.minutes) {
            this.myOverlay.minutes = timePlayed;
            this.myOverlay.seconds = 0;
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        Widget reportButton;
        if (this.paused) {
            return;
        }
        if ((this.config.clearReportButton() || this.config.showOnReportButton()) && (reportButton = this.client.getWidget(WidgetInfo.CHATBOX_REPORT_TEXT)) != null && reportButton.getText().equals("Report")) {
            reportButton.setText("");
        }
        if (this.myOverlay != null) {
            long time = Instant.now().toEpochMilli();
            this.myOverlay.msOffset = (int)((time - this.myOverlay.lastTick) / 100L);
        }
    }

    @Provides
    TimePlayedConfig provideConfig(ConfigManager configManager) {
        return (TimePlayedConfig)configManager.getConfig(TimePlayedConfig.class);
    }

    private int getStoredSeconds() {
        try {
            return Integer.parseInt(this.configManager.getRSProfileConfiguration("timeplayed", "seconds"));
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    private void setStoredSeconds(int seconds) {
        this.configManager.setRSProfileConfiguration("timeplayed", "seconds", (Object)seconds);
    }

    private int getStoredMinutes() {
        try {
            return Integer.parseInt(this.configManager.getRSProfileConfiguration("timeplayed", "minutes"));
        }
        catch (NumberFormatException ignored) {
            this.paused = true;
            return 0;
        }
    }

    private void setStoredMinutes(int minutes) {
        this.configManager.setRSProfileConfiguration("timeplayed", "minutes", (Object)minutes);
    }
}

