/*
 * Decompiled with CFR 0.152.
 */
package com.timeplayed;

import com.timeplayed.TimePlayedConfig;
import com.timeplayed.TimePlayedPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ComponentConstants;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;

public class TimePlayedOverlay
extends Overlay {
    private TimePlayedPlugin plugin;
    private TimePlayedConfig config;
    private Client client;
    private TooltipManager tooltipManager;
    private PanelComponent panelComponent = new PanelComponent();
    public int minutes = 0;
    public int seconds = 0;
    public long lastTick = 0L;
    public int msOffset = 0;

    @Inject
    public TimePlayedOverlay(TimePlayedPlugin plugin, TimePlayedConfig config, Client client, TooltipManager tooltipManager) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        if (config.ontop()) {
            this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        } else {
            this.setLayer(OverlayLayer.ABOVE_SCENE);
        }
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.tooltipManager = tooltipManager;
        this.setMinimumSize(10);
        this.panelComponent.setBorder(new Rectangle(4, 4));
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Time played overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        String leftStr = this.buildLeftString();
        String rightStr = this.buildRightString();
        String str = leftStr + rightStr;
        if (this.config.showOnReportButton()) {
            Widget reportButton = this.client.getWidget(WidgetInfo.CHATBOX_REPORT_TEXT);
            if (reportButton != null) {
                reportButton.setText(str);
            }
            return null;
        }
        if (this.config.defStyle()) {
            FontMetrics metrics = graphics.getFontMetrics(FontManager.getRunescapeFont());
            int hgt = metrics.getHeight();
            int adv = metrics.stringWidth(leftStr + rightStr);
            this.panelComponent.getChildren().add(LineComponent.builder().right(str).build());
            Color bgcolor = ComponentConstants.STANDARD_BACKGROUND_COLOR;
            this.panelComponent.setBackgroundColor(bgcolor);
            this.panelComponent.setPreferredSize(new Dimension(adv + 8, hgt + 8));
        } else {
            Font font = new Font(this.config.font(), 0, this.config.fontSize());
            Color color = this.config.fontColor();
            Color bgcolor = this.config.bgColor();
            FontMetrics metrics = graphics.getFontMetrics(font);
            int hgt = metrics.getHeight();
            int adv = metrics.stringWidth(leftStr + rightStr);
            this.panelComponent.getChildren().add(LineComponent.builder().right(leftStr + rightStr).rightFont(font).rightColor(color).build());
            this.panelComponent.setBackgroundColor(bgcolor);
            this.panelComponent.setPreferredSize(new Dimension(adv + 8, hgt + 8));
        }
        return this.panelComponent.render(graphics);
    }

    public String buildLeftString() {
        if (this.config.displayDays()) {
            int days = this.minutes / 1440;
            int hrs = this.minutes % 1440 / 60;
            int mins = this.minutes % 60;
            return String.format("%01dd%02d:%02d", days, hrs, mins);
        }
        int hrs = this.minutes / 60;
        int mins = this.minutes % 60;
        return String.format("%d:%02d", hrs, mins);
    }

    public String buildRightString() {
        int effectiveSec;
        if (this.config.smoothTimer()) {
            if (this.msOffset >= 6) {
                this.msOffset = 5;
            }
            effectiveSec = this.seconds + this.msOffset;
        } else {
            effectiveSec = this.seconds;
        }
        if (this.config.displayMs()) {
            int secs = effectiveSec / 10;
            int ms = effectiveSec % 10;
            return String.format(":%02d.%01d", secs, ms);
        }
        int secs = effectiveSec / 10;
        return String.format(":%02d", secs);
    }
}

