/*
 * Decompiled with CFR 0.152.
 */
package com.chatchannelwatcher;

import com.chatchannelwatcher.ChatChannelEvent;
import com.chatchannelwatcher.ChatChannelWatcherAPI;
import com.chatchannelwatcher.ChatChannelWatcherConfig;
import com.chatchannelwatcher.NotificationMode;
import com.google.inject.Provides;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.ChatPlayer;
import net.runelite.api.Client;
import net.runelite.api.events.ClanMemberJoined;
import net.runelite.api.events.ClanMemberLeft;
import net.runelite.api.events.FriendsChatMemberJoined;
import net.runelite.api.events.FriendsChatMemberLeft;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Chat-Channel Watcher")
public class ChatChannelWatcherPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ChatChannelWatcherPlugin.class);
    @Inject
    private Notifier notifier;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Client client;
    @Inject
    private ChatChannelWatcherConfig config;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OkHttpClient httpClient;
    public long lastUpdateTimestamp = 0L;
    HashMap<String, Integer> lastNotification = new HashMap();

    private List<String> getPlayerNames() {
        return Arrays.asList(this.config.playerList().toLowerCase().split("\n"));
    }

    protected void startUp() throws Exception {
        log.info("ChatChannelWatcher started!");
        if (this.config.highlight()) {
            this.clientThread.invoke(() -> this.colourHighlightedPlayers(this.config.highlightColour()));
        }
    }

    protected void shutDown() throws Exception {
        log.info("ChatChannelWatcher stopped!");
        this.clientThread.invoke(() -> this.colourHighlightedPlayers(Color.WHITE));
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        Color highlightColour = this.config.highlight() ? this.config.highlightColour() : Color.WHITE;
        this.clientThread.invoke(() -> this.colourHighlightedPlayers(highlightColour));
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 1658 && this.config.highlight()) {
            this.colourHighlightedPlayers(this.config.highlightColour());
        }
    }

    @Subscribe
    public void onFriendsChatMemberJoined(FriendsChatMemberJoined friendsChatMemberJoined) {
        if (!this.config.friendChatNotification()) {
            return;
        }
        if (!this.config.getApiURL().isEmpty()) {
            this.updatePlayerList();
        }
        this.handleChangeEvent((ChatPlayer)friendsChatMemberJoined.getMember(), true);
    }

    @Subscribe
    public void onFriendsChatMemberLeft(FriendsChatMemberLeft friendsChatMemberLeft) {
        if (!this.config.friendChatNotification()) {
            return;
        }
        if (!this.config.getApiURL().isEmpty()) {
            this.updatePlayerList();
        }
        this.handleChangeEvent((ChatPlayer)friendsChatMemberLeft.getMember(), false);
    }

    @Subscribe
    public void onClanMemberJoined(ClanMemberJoined clanMemberJoined) {
        if (!this.config.clanChatNotification()) {
            return;
        }
        if (!this.config.getApiURL().isEmpty()) {
            this.updatePlayerList();
        }
        this.handleChangeEvent((ChatPlayer)clanMemberJoined.getClanMember(), true);
    }

    @Subscribe
    public void onClanMemberLeft(ClanMemberLeft clanMemberLeft) {
        if (!this.config.clanChatNotification()) {
            return;
        }
        if (!this.config.getApiURL().isEmpty()) {
            this.updatePlayerList();
        }
        this.handleChangeEvent((ChatPlayer)clanMemberLeft.getClanMember(), false);
    }

    public void handleChangeEvent(ChatPlayer player, boolean joining) {
        String name = Text.toJagexName((String)player.getName().toLowerCase());
        String previousName = "";
        if (this.config.prevName() && player.getPrevName() != null) {
            previousName = Text.toJagexName((String)player.getPrevName().toLowerCase());
        }
        this.handleNotification(name, previousName, joining);
    }

    private void updatePlayerList() {
        if (this.lastUpdateTimestamp + TimeUnit.SECONDS.toMillis(10L) < System.currentTimeMillis()) {
            this.lastUpdateTimestamp = System.currentTimeMillis();
            ChatChannelWatcherAPI.updatePlayerList(this.httpClient, this.config.getApiURL(), this.config.bearerToken(), this.configManager);
        }
    }

    private void handleNotification(String name, String prevName, boolean joining) {
        String notificationMessage;
        String outName;
        boolean containsName;
        List<String> playerNames = this.getPlayerNames();
        int timeStamp = (int)(System.currentTimeMillis() / 1000L);
        boolean bl = containsName = playerNames.contains(name) || !Objects.equals(prevName, "") && playerNames.contains(prevName);
        if (!(this.config.postApiURL().isEmpty() || containsName && !playerNames.isEmpty())) {
            ChatChannelEvent event = new ChatChannelEvent(name, joining, timeStamp, false);
            ChatChannelWatcherAPI.postEvent(this.httpClient, this.config.postApiURL(), this.config.bearerToken(), event);
            return;
        }
        if (!containsName) {
            return;
        }
        String foundName = playerNames.contains(name) ? name : prevName;
        String string = outName = Objects.equals(prevName, "") ? name : name + " (previously: " + prevName + ")";
        if (this.lastNotification.getOrDefault(foundName, 0) + this.config.notificationDelay() >= (int)(System.currentTimeMillis() / TimeUnit.SECONDS.toMillis(1L))) {
            return;
        }
        String string2 = notificationMessage = joining ? this.config.joinNotification().replaceAll("\\{player}", outName) : this.config.leaveNotification().replaceAll("\\{player}", outName);
        if (this.config.notificationMode() == NotificationMode.BOTH || this.config.notificationMode() == NotificationMode.DESKTOP) {
            this.notifier.notify(notificationMessage);
        }
        if (this.config.notificationMode() == NotificationMode.BOTH || this.config.notificationMode() == NotificationMode.CHAT) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "[Chat-Channel Watcher]: " + notificationMessage, null);
        }
        this.lastNotification.put(foundName, timeStamp);
        if (!this.config.postApiURL().isEmpty()) {
            ChatChannelEvent event = new ChatChannelEvent(foundName, joining, timeStamp, true);
            ChatChannelWatcherAPI.postEvent(this.httpClient, this.config.postApiURL(), this.config.bearerToken(), event);
        }
    }

    private void colourHighlightedPlayers(Color highlightColour) {
        Widget chatList = this.client.getWidget(WidgetInfo.FRIENDS_CHAT_LIST);
        if (chatList == null || chatList.getChildren() == null) {
            return;
        }
        for (int i = 0; i < chatList.getChildren().length; i += 3) {
            Widget listWidget = chatList.getChild(i);
            String memberName = listWidget.getText().toLowerCase();
            if (!this.getPlayerNames().contains(memberName)) continue;
            listWidget.setTextColor(highlightColour.getRGB());
        }
    }

    @Provides
    ChatChannelWatcherConfig provideConfig(ConfigManager configManager) {
        return (ChatChannelWatcherConfig)configManager.getConfig(ChatChannelWatcherConfig.class);
    }
}

