/*
 * Decompiled with CFR 0.152.
 */
package com.chatchannelwatcher;

import com.chatchannelwatcher.ChatChannelEvent;
import java.io.IOException;
import net.runelite.client.config.ConfigManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ChatChannelWatcherAPI {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public static void postEvent(OkHttpClient httpClient, String url, String token, ChatChannelEvent event) {
        Request postRequest = new Request.Builder().url(url).header("Authorization", "Bearer: " + token).post(RequestBody.create((MediaType)JSON, (String)event.getJson())).build();
        httpClient.newCall(postRequest).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
            }
        });
    }

    public static void updatePlayerList(OkHttpClient httpClient, String url, String token, final ConfigManager configManager) {
        Request getRequest = new Request.Builder().url(url).header("Authorization", "Bearer: " + token).get().build();
        httpClient.newCall(getRequest).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    configManager.setConfiguration("chatchannelwatcher", "playerlist", response.body().string());
                }
                response.close();
            }
        });
    }
}

