/*
 * Decompiled with CFR 0.152.
 */
package com.BaPB;

import com.BaPB.BaPBConfig;
import com.BaPB.GameTimer;
import com.google.inject.Provides;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.Instant;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MessageNode;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.RuneLite;
import net.runelite.client.chat.ChatClient;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatCommandManager;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ChatInput;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Barbarian Assault Personal Bests", description="Emulates the normal plugin as well as saving personal bests", tags={"minigame", "overlay", "timer", "Personal Bests", "Time"})
public class BaPBPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BaPBPlugin.class);
    private static final int BA_WAVE_NUM_INDEX = 2;
    private static final String START_WAVE = "1";
    private static final String ENDGAME_REWARD_NEEDLE_TEXT = "<br>5";
    private double currentpb;
    private double rolecurrentpb;
    private static final String BA_COMMAND_STRING = "!ba";
    private int gc;
    private int inGameBit = 0;
    private String currentWave = "1";
    private GameTimer gameTime;
    private String round_role;
    private Boolean scanning;
    private int round_roleID;
    private Boolean leech;
    private Integer BaRoleWidget = 256;
    private Integer BaScrollWidget = 159;
    private Integer leaderID = 8;
    private Integer player1ID = 9;
    private Integer player2ID = 10;
    private Integer player3ID = 11;
    private Integer player4ID = 12;
    private Integer leadericonID = 18;
    private Integer player1iconID = 19;
    private Integer player2iconID = 20;
    private Integer player3iconID = 21;
    private Integer player4iconID = 22;
    private Integer attackerIcon = 20561;
    private Integer defenderIcon = 20566;
    private Integer collectorIcon = 20563;
    private Integer healerIcon = 20569;
    private PrintWriter out;
    private BufferedWriter bw;
    private FileWriter fw;
    @Inject
    private Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BaPBConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ChatCommandManager chatCommandManager;
    @Inject
    private ChatClient chatClient;
    @Inject
    private ScheduledExecutorService executor;
    StringBuilder str = new StringBuilder();

    @Provides
    BaPBConfig provideConfig(ConfigManager configManager) {
        return (BaPBConfig)configManager.getConfig(BaPBConfig.class);
    }

    protected void startUp() throws Exception {
        File logFile = new File(RuneLite.RUNELITE_DIR, "barbarian-assault-pbs.csv");
        this.fw = new FileWriter(logFile, true);
        this.bw = new BufferedWriter(this.fw);
        this.out = new PrintWriter(this.bw);
        this.chatCommandManager.registerCommandAsync(BA_COMMAND_STRING, this::baLookup, this::baSubmit);
        this.scanning = false;
        this.str = new StringBuilder();
    }

    protected void shutDown() throws Exception {
        this.chatCommandManager.unregisterCommand(BA_COMMAND_STRING);
        this.scanning = false;
        this.shutDownActions();
        this.out.close();
        this.bw.close();
        this.fw.close();
        this.str = new StringBuilder();
    }

    private void shutDownActions() throws IOException {
        this.out.flush();
        this.bw.flush();
        this.fw.flush();
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) throws IOException {
        switch (event.getGroupId()) {
            case 497: {
                Widget rewardWidget = this.client.getWidget(WidgetInfo.BA_REWARD_TEXT);
                if (rewardWidget == null || !rewardWidget.getText().contains(ENDGAME_REWARD_NEEDLE_TEXT) || this.gameTime == null) break;
                if (((double)this.gameTime.getPBTime() < this.rolecurrentpb || this.rolecurrentpb == 0.0) && this.config.Seperate()) {
                    this.configManager.setRSProfileConfiguration("BaPB", this.round_role, (Object)this.gameTime.getPBTime());
                    log.debug("Personal best of: {} saved in {}", (Object)this.gameTime.getPBTime(), (Object)this.round_role);
                }
                this.currentpb = this.getCurrentPB("Barbarian Assault");
                if ((double)this.gameTime.getPBTime() < this.currentpb || this.currentpb == 0.0) {
                    this.configManager.setRSProfileConfiguration("BaPB", "Barbarian Assault", (Object)this.gameTime.getPBTime());
                    log.debug("Personal best of: {} saved in Barbarian Assault", (Object)this.gameTime.getPBTime());
                }
                this.configManager.setRSProfileConfiguration("BaPB", "Recent", (Object)((double)this.gameTime.getPBTime() + this.roleToDouble(this.round_role)));
                if (this.config.Logging()) {
                    this.str.append(Instant.now().toString()).append(",").append(String.valueOf(this.gameTime.getPBTime()));
                    this.out.println(this.str);
                    this.str = new StringBuilder();
                    this.shutDownActions();
                }
                this.gameTime = null;
                this.leech = false;
                break;
            }
            case 256: {
                this.scanning = true;
                this.leech = false;
            }
            case 159: {
                this.scanning = true;
            }
            case 158: {
                this.scanning = true;
            }
        }
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed event) {
        if (event.getGroupId() == this.BaRoleWidget.intValue()) {
            this.scanning = false;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) throws IOException {
        if (this.config.SubmitPbs() && this.gc > 0 && this.client.getGameState() == GameState.LOGGED_IN) {
            this.submit_pb(this.gc);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.config.SubmitPbs()) {
            this.gc = this.client.getVar(4768);
        }
        if (this.scanning.booleanValue()) {
            String player = this.client.getLocalPlayer().getName();
            Widget leader = this.client.getWidget(this.BaRoleWidget.intValue(), this.leaderID.intValue());
            Widget leaderIcon = this.client.getWidget(this.BaRoleWidget.intValue(), this.leadericonID.intValue());
            Widget player1 = this.client.getWidget(this.BaRoleWidget.intValue(), this.player1ID.intValue());
            Widget player1Icon = this.client.getWidget(this.BaRoleWidget.intValue(), this.player1iconID.intValue());
            Widget player2 = this.client.getWidget(this.BaRoleWidget.intValue(), this.player2ID.intValue());
            Widget player2Icon = this.client.getWidget(this.BaRoleWidget.intValue(), this.player2iconID.intValue());
            Widget player3 = this.client.getWidget(this.BaRoleWidget.intValue(), this.player3ID.intValue());
            Widget player3Icon = this.client.getWidget(this.BaRoleWidget.intValue(), this.player3iconID.intValue());
            Widget player4 = this.client.getWidget(this.BaRoleWidget.intValue(), this.player4ID.intValue());
            Widget player4Icon = this.client.getWidget(this.BaRoleWidget.intValue(), this.player4iconID.intValue());
            log.debug("Scanning Team");
            if (player4Icon.getModelId() != leaderIcon.getModelId() && player4Icon.getModelId() != 65535 && leaderIcon.getModelId() != 65535) {
                log.debug("Scanning Complete");
                log.debug("Leader is {}", (Object)leader.getText());
                log.debug("Player1 is {}", (Object)player1.getText());
                log.debug("Player2 is {}", (Object)player2.getText());
                log.debug("Player3 is {}", (Object)player3.getText());
                log.debug("Player4 is {}", (Object)player4.getText());
                if (this.str.length() == 0 && this.config.Logging()) {
                    log.debug("Created Log start");
                    this.str.append(leader.getText()).append(",").append(this.IDfinder(leaderIcon.getModelId())).append(",").append(player1.getText()).append(",").append(this.IDfinder(player1Icon.getModelId())).append(",").append(player2.getText()).append(",").append(this.IDfinder(player2Icon.getModelId())).append(",").append(player3.getText()).append(",").append(this.IDfinder(player3Icon.getModelId())).append(",").append(player4.getText()).append(",").append(this.IDfinder(player4Icon.getModelId())).append(",");
                }
                this.scanning = false;
                for (int i = 8; i < 13; ++i) {
                    String player_in_list = this.client.getWidget(this.BaRoleWidget.intValue(), i).getText();
                    String playerRole = this.IDfinder(this.client.getWidget(this.BaRoleWidget.intValue(), i + 10).getModelId());
                    if (player.compareTo(player_in_list) != 0) continue;
                    this.round_roleID = this.client.getWidget(this.BaRoleWidget.intValue(), i + 10).getModelId();
                    this.round_role = this.IDfinder(this.round_roleID);
                    log.debug("Your role has been identified as {}", (Object)this.round_role);
                }
                if (leaderIcon.getModelId() == this.attackerIcon.intValue() && player1Icon.getModelId() == this.collectorIcon.intValue() && player2Icon.getModelId() == this.healerIcon.intValue() && player4Icon.getModelId() == this.defenderIcon.intValue()) {
                    this.round_role = "Leech " + this.round_role;
                    log.debug("This has been identified as a leech run as {}", (Object)this.round_role);
                    this.leech = true;
                }
                if (player.contains(leader.getText()) && leaderIcon.getModelId() == this.attackerIcon.intValue() && !this.leech.booleanValue()) {
                    this.round_role = "Main Attacker";
                    log.debug("You have been identified as Main Attacker");
                }
                if (this.config.Message()) {
                    this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage("Run identified as " + this.round_role + " good luck :)").build());
                }
                this.rolecurrentpb = this.getCurrentPB(this.round_role);
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.GAMEMESSAGE && event.getMessage().startsWith("---- Wave:")) {
            String[] message = event.getMessage().split(" ");
            this.currentWave = message[2];
            if (this.currentWave.equals(START_WAVE)) {
                this.gameTime = new GameTimer();
            }
        }
    }

    private double getCurrentPB(String pbKey) {
        try {
            return (Double)this.configManager.getRSProfileConfiguration("BaPB", pbKey, Double.TYPE);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    void recentLookup(ChatMessage chatMessage, String message) {
        double BaPb;
        ChatMessageType type = chatMessage.getType();
        String search = message.substring(BA_COMMAND_STRING.length() + 1);
        String player = type.equals((Object)ChatMessageType.PRIVATECHATOUT) ? this.client.getLocalPlayer().getName() : Text.removeTags((String)chatMessage.getName()).replace('\u00a0', ' ');
        try {
            BaPb = this.chatClient.getPb(player, "Recent");
        }
        catch (IOException ex) {
            log.debug("unable to retrieve PB", (Throwable)ex);
            return;
        }
        double roleDouble = BaPb - (double)((int)BaPb);
        roleDouble = (double)Math.round(roleDouble * 100.0) / 100.0;
        log.debug(String.valueOf(roleDouble));
        String role = this.doubleToRole(roleDouble);
        int minutes = (int)(Math.floor(BaPb) / 60.0);
        double seconds = (int)BaPb % 60;
        String time = Math.floor(seconds) == seconds ? String.format("%d:%02d", minutes, (int)seconds) : String.format("%d:%05.2f", minutes, seconds);
        String response = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Recent ").append(ChatColorType.NORMAL).append(role).append(" run: ").append(ChatColorType.HIGHLIGHT).append(time).build();
        log.debug("Setting response {}", (Object)response);
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setRuneLiteFormatMessage(response);
        this.chatMessageManager.update(messageNode);
        this.client.refreshChat();
    }

    private void gcLookup(ChatMessage chatMessage, String message) {
        int gc;
        ChatMessageType type = chatMessage.getType();
        String player = type == ChatMessageType.PRIVATECHATOUT ? this.client.getLocalPlayer().getName() : Text.sanitize((String)chatMessage.getName());
        try {
            gc = this.grabgc(player);
        }
        catch (IOException ex) {
            log.debug("unable to lookup gamble count", (Throwable)ex);
            return;
        }
        String response = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Barbarian Assault High-level gambles: ").append(ChatColorType.HIGHLIGHT).append(String.format("%,d", gc)).build();
        log.debug("Setting response {}", (Object)response);
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setRuneLiteFormatMessage(response);
        this.client.refreshChat();
    }

    void baLookup(ChatMessage chatMessage, String message) {
        double BaPb;
        ChatMessageType type = chatMessage.getType();
        String search = message.substring(BA_COMMAND_STRING.length() + 1);
        String player = type.equals((Object)ChatMessageType.PRIVATECHATOUT) ? this.client.getLocalPlayer().getName() : Text.removeTags((String)chatMessage.getName()).replace('\u00a0', ' ');
        if ((search = BaPBPlugin.longBossName(search)) == "Recent") {
            this.recentLookup(chatMessage, message);
            return;
        }
        if (search == "Gc" && this.config.baGC()) {
            this.gcLookup(chatMessage, message);
            return;
        }
        try {
            BaPb = this.chatClient.getPb(player, search);
        }
        catch (IOException ex) {
            log.debug("unable to retrieve PB", (Throwable)ex);
            return;
        }
        int minutes = (int)(Math.floor(BaPb) / 60.0);
        double seconds = BaPb % 60.0;
        String time = Math.floor(seconds) == seconds ? String.format("%d:%02d", minutes, (int)seconds) : String.format("%d:%05.2f", minutes, seconds);
        String response = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(search).append(ChatColorType.NORMAL).append(" personal best: ").append(ChatColorType.HIGHLIGHT).append(time).build();
        log.debug("Setting response {}", (Object)response);
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setRuneLiteFormatMessage(response);
        this.chatMessageManager.update(messageNode);
        this.client.refreshChat();
    }

    private boolean baSubmit(ChatInput chatInput, String value) {
        int idx = value.indexOf(32);
        String boss = BaPBPlugin.longBossName(value.substring(idx + 1));
        double pb = (Double)this.configManager.getRSProfileConfiguration("BaPB", boss, Double.TYPE);
        if (pb <= 0.0) {
            return false;
        }
        String playerName = this.client.getLocalPlayer().getName();
        this.executor.execute(() -> {
            try {
                this.chatClient.submitPb(playerName, boss, pb);
            }
            catch (Exception ex) {
                log.warn("unable to submit personal best", (Throwable)ex);
            }
            finally {
                chatInput.resume();
            }
        });
        return true;
    }

    private String IDfinder(int roleID) {
        if (roleID == this.attackerIcon) {
            return "Attacker";
        }
        if (roleID == this.defenderIcon) {
            return "Defender";
        }
        if (roleID == this.collectorIcon) {
            return "Collector";
        }
        if (roleID == this.healerIcon) {
            return "Healer";
        }
        return "";
    }

    private String doubleToRole(double time) {
        if (time == 0.1) {
            return "Attacker";
        }
        if (time == 0.2) {
            return "Defender";
        }
        if (time == 0.3) {
            return "Collector";
        }
        if (time == 0.4) {
            return "Healer";
        }
        if (time == 0.5) {
            return "Leech Attacker";
        }
        if (time == 0.6) {
            return "Leech Defender";
        }
        if (time == 0.7) {
            return "Leech Collector";
        }
        if (time == 0.8) {
            return "Leech Healer";
        }
        if (time == 0.9) {
            return "Main Attacker";
        }
        return "Please relaunch client and do another run to fix this bug";
    }

    private double roleToDouble(String role) {
        if (role == "Attacker") {
            return 0.1;
        }
        if (role == "Defender") {
            return 0.2;
        }
        if (role == "Collector") {
            return 0.3;
        }
        if (role == "Healer") {
            return 0.4;
        }
        if (role.equals("Leech Attacker")) {
            return 0.5;
        }
        if (role.equals("Leech Defender")) {
            return 0.6;
        }
        if (role.equals("Leech Collector")) {
            return 0.7;
        }
        if (role.equals("Leech Healer")) {
            return 0.8;
        }
        if (role == "Main Attacker") {
            return 0.9;
        }
        return 0.0;
    }

    private static String longBossName(String boss) {
        switch (boss.toLowerCase()) {
            case "att": 
            case "a": 
            case "main": {
                return "Main Attacker";
            }
            case "2a": {
                return "Attacker";
            }
            case "la": {
                return "Leech Attacker";
            }
            case "heal": 
            case "h": {
                return "Healer";
            }
            case "lh": {
                return "Leech Healer";
            }
            case "def": 
            case "d": {
                return "Defender";
            }
            case "ld": {
                return "Leech Defender";
            }
            case "eggboi": 
            case "coll": 
            case "col": 
            case "c": {
                return "Collector";
            }
            case "lc": {
                return "Leech Collector";
            }
            case "": 
            case " ": 
            case "ba": {
                return "Barbarian Assault";
            }
            case "r": {
                return "Recent";
            }
            case "gc": {
                return "Gc";
            }
        }
        return WordUtils.capitalize((String)boss);
    }

    private void submit_pb(int gc) throws IOException {
        String json = "{\"jwt\":\"" + this.config.api_key() + "\",\"name\":\"" + this.client.getLocalPlayer().getName() + "\",\"Main Attacker\":\"" + this.getCurrentPB("Main Attacker") + "\",\"Attacker\":\"" + this.getCurrentPB("Attacker") + "\",\"Leech Attacker\":\"" + this.getCurrentPB("Leech Attacker") + "\",\"Healer\":\"" + this.getCurrentPB("Healer") + "\",\"Leech Healer\":\"" + this.getCurrentPB("Leech Healer") + "\",\"Defender\":\"" + this.getCurrentPB("Defender") + "\",\"Leech Defender\":\"" + this.getCurrentPB("Leech Defender") + "\",\"Collector\":\"" + this.getCurrentPB("Collector") + "\",\"Leech Collector\":\"" + this.getCurrentPB("Leech Collector") + "\",\"Barbarian Assault\":\"" + this.getCurrentPB("Barbarian Assault") + "\",\"gc\":\"" + gc + "\"}";
        OkHttpClient httpClient = RuneLiteAPI.CLIENT;
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json);
        Request request = new Request.Builder().url("https://babackend.herokuapp.com/submit/pbs").post(body).build();
        Call call = httpClient.newCall(request);
        Response response = call.execute();
        String chatMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(response.body().string()).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
    }

    int grabgc(String name) throws IOException {
        String json = "{\"jwt\":\"" + this.config.api_key() + "\",\"player_name\":\"" + name + "\"}";
        OkHttpClient httpClient = RuneLiteAPI.CLIENT;
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json);
        Request request = new Request.Builder().url("https://babackend.herokuapp.com/grab/gc").post(body).build();
        Call call = httpClient.newCall(request);
        Response response = call.execute();
        return Integer.parseInt(response.body().string());
    }

    int getInGameBit() {
        return this.inGameBit;
    }
}

