/*
 * Decompiled with CFR 0.152.
 */
package sgf.multihighlight;

import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sgf.multihighlight.MulticolorHighlightsConfig;
import sgf.multihighlight.MulticolorHighlightsOverlay;

@PluginDescriptor(name="Multicolor Highlights")
public class MulticolorHighlightsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MulticolorHighlightsPlugin.class);
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private MulticolorHighlightsConfig config;
    @Inject
    private MulticolorHighlightsOverlay overlay;
    @Inject
    private ClientThread clientThread;
    private final Set<NPC> highlights1 = new HashSet<NPC>();
    private final Set<NPC> highlights2 = new HashSet<NPC>();
    private final Set<NPC> highlights3 = new HashSet<NPC>();
    private final Set<NPC> highlights4 = new HashSet<NPC>();
    private final Set<NPC> highlights5 = new HashSet<NPC>();
    private final List<Set<NPC>> groupHighlights = ImmutableList.of(this.highlights1, this.highlights2, this.highlights3, this.highlights4, this.highlights5);

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.clientThread.invoke(() -> this.buildHighlights());
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.clientThread.invoke(() -> {
            for (Set<NPC> highlights : this.groupHighlights) {
                highlights.clear();
            }
        });
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            for (Set<NPC> highlights : this.groupHighlights) {
                highlights.clear();
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("multicolorhighlights")) {
            return;
        }
        this.clientThread.invoke(this::buildHighlights);
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        String npcName = npc.getName();
        if (npcName == null) {
            return;
        }
        int group = 1;
        for (Set<NPC> highlights : this.groupHighlights) {
            if (this.matchesNpcName(npcName, this.getHighlightNames(group))) {
                highlights.add(npc);
            }
            ++group;
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        for (Set<NPC> highlights : this.groupHighlights) {
            highlights.remove(npc);
        }
    }

    @Provides
    MulticolorHighlightsConfig provideConfig(ConfigManager configManager) {
        return (MulticolorHighlightsConfig)configManager.getConfig(MulticolorHighlightsConfig.class);
    }

    private void buildHighlights() {
        int group = 1;
        for (Set<NPC> highlights : this.groupHighlights) {
            highlights.clear();
            if (this.client.getGameState() != GameState.LOGGED_IN && this.client.getGameState() != GameState.LOADING) {
                return;
            }
            for (NPC npc : this.client.getNpcs()) {
                String npcName = npc.getName();
                if (npcName == null || !this.matchesNpcName(npcName, this.getHighlightNames(group))) continue;
                highlights.add(npc);
            }
            ++group;
        }
    }

    private List<String> getHighlightNames(int groupNum) {
        String npcCsv = "";
        switch (groupNum) {
            case 1: {
                npcCsv = this.config.getNpcs1();
                break;
            }
            case 2: {
                npcCsv = this.config.getNpcs2();
                break;
            }
            case 3: {
                npcCsv = this.config.getNpcs3();
                break;
            }
            case 4: {
                npcCsv = this.config.getNpcs4();
                break;
            }
            case 5: {
                npcCsv = this.config.getNpcs5();
            }
        }
        return Text.fromCSV((String)npcCsv);
    }

    protected Color getGroupColor(int groupNum) {
        switch (groupNum) {
            case 1: {
                return this.config.getGroup1Color();
            }
            case 2: {
                return this.config.getGroup2Color();
            }
            case 3: {
                return this.config.getGroup3Color();
            }
            case 4: {
                return this.config.getGroup4Color();
            }
            case 5: {
                return this.config.getGroup5Color();
            }
        }
        return null;
    }

    protected Color getGroupFillColor(int groupNum) {
        int alpha = 0;
        switch (groupNum) {
            case 1: {
                alpha = this.config.getGroup1FillAlpha();
                break;
            }
            case 2: {
                alpha = this.config.getGroup2FillAlpha();
                break;
            }
            case 3: {
                alpha = this.config.getGroup3FillAlpha();
                break;
            }
            case 4: {
                alpha = this.config.getGroup4FillAlpha();
                break;
            }
            case 5: {
                alpha = this.config.getGroup5FillAlpha();
                break;
            }
            default: {
                return null;
            }
        }
        Color color = this.getGroupColor(groupNum);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    private boolean matchesNpcName(String name, List<String> highlightNames) {
        for (String highlight : highlightNames) {
            if (!WildcardMatcher.matches((String)highlight, (String)name)) continue;
            return true;
        }
        return false;
    }

    List<Set<NPC>> getGroupHighlights() {
        return this.groupHighlights;
    }
}

