/*
 * Decompiled with CFR 0.152.
 */
package sgf.multihighlight;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.NPC;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import sgf.multihighlight.MulticolorHighlightsConfig;
import sgf.multihighlight.MulticolorHighlightsPlugin;

public class MulticolorHighlightsOverlay
extends Overlay {
    private MulticolorHighlightsPlugin plugin;
    private MulticolorHighlightsConfig config;

    @Inject
    public MulticolorHighlightsOverlay(MulticolorHighlightsPlugin plugin, MulticolorHighlightsConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        int group = 1;
        for (Set<NPC> highlights : this.plugin.getGroupHighlights()) {
            for (NPC npc : highlights) {
                this.renderNpcOverlay(graphics, npc, this.plugin.getGroupColor(group), this.plugin.getGroupFillColor(group));
            }
            ++group;
        }
        return null;
    }

    private void renderNpcOverlay(Graphics2D graphics, NPC npc, Color color, Color fillColor) {
        Shape shape;
        if (this.config.highlightHullOutline() && (shape = npc.getConvexHull()) != null) {
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(this.config.getOutlineStrokeWidth()));
            graphics.draw(shape);
        }
        if (this.config.highlightHullFill() && (shape = npc.getConvexHull()) != null) {
            graphics.setColor(fillColor);
            graphics.fill(shape);
        }
    }
}

