/*
 * Decompiled with CFR 0.152.
 */
package autoretaliatewarning;

import autoretaliatewarning.AutoRetaliateWarningConfig;
import autoretaliatewarning.AutoRetaliateWarningOverlay;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Auto Retaliate Warning", description="Warns you when you have auto retaliate on, or NPC attack options not hidden. Helps to prevent misclicks on limited accounts.", tags={"hidden", "attack options", "retaliate", "auto", "auto retaliate", "warning"})
public class AutoRetaliateWarningPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AutoRetaliateWarningPlugin.class);
    private final int AUTO_RETALIATE_VARBIT = 172;
    private final int NPC_ATTACK_OPTIONS_VARBIT = 1306;
    @Inject
    private Client client;
    @Inject
    private AutoRetaliateWarningConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private AutoRetaliateWarningOverlay overlay;

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.hideWidget(this.client.getWidget(WidgetInfo.COMBAT_AUTO_RETALIATE), this.config.hideRetaliateConfig());
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.hideWidget(this.client.getWidget(WidgetInfo.COMBAT_AUTO_RETALIATE), this.config.hideRetaliateConfig());
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        log.info("Auto Retaliate Warning stopped!");
        this.hideWidget(this.client.getWidget(WidgetInfo.COMBAT_AUTO_RETALIATE), false);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            return;
        }
    }

    @Provides
    AutoRetaliateWarningConfig provideConfig(ConfigManager configManager) {
        return (AutoRetaliateWarningConfig)configManager.getConfig(AutoRetaliateWarningConfig.class);
    }

    private void hideWidget(Widget widget, boolean hidden) {
        if (widget != null) {
            widget.setHidden(hidden);
        }
    }

    public boolean getAutoRetaliateStatus() {
        return this.client.getVarpValue(172) == 0;
    }

    public boolean getNPCAttackOptions() {
        return this.client.getVarpValue(1306) != 3;
    }
}

