/*
 * Decompiled with CFR 0.152.
 */
package autoretaliatewarning;

import autoretaliatewarning.AutoRetaliateWarningConfig;
import autoretaliatewarning.AutoRetaliateWarningPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class AutoRetaliateWarningOverlay
extends OverlayPanel {
    private final AutoRetaliateWarningPlugin plugin;
    private final AutoRetaliateWarningConfig config;

    @Inject
    private AutoRetaliateWarningOverlay(AutoRetaliateWarningPlugin plugin, AutoRetaliateWarningConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        graphics.setFont(new Font(FontManager.getRunescapeFont().getName(), 0, this.config.fontSize()));
        String autoRetaliateWarning = "AUTO RETALIATE IS SELECTED";
        String NPCAttackWarning = "NPC ATTACK OPTIONS NOT HIDDEN";
        boolean autoRetaliateSelected = this.plugin.getAutoRetaliateStatus();
        boolean getNPCAttackSelected = this.plugin.getNPCAttackOptions();
        if (autoRetaliateSelected && this.config.autoRetaliateWarn()) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text(autoRetaliateWarning).color(Color.RED).build());
        }
        if (getNPCAttackSelected && this.config.npcAttackOptionsWarn()) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text(NPCAttackWarning).color(Color.RED).build());
        }
        this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(NPCAttackWarning) + 10, graphics.getFontMetrics().getHeight()));
        return super.render(graphics);
    }
}

