/*
 * Decompiled with CFR 0.152.
 */
package com.histogram;

import com.google.inject.Provides;
import com.histogram.EventType;
import com.histogram.HistogramConfig;
import com.histogram.HistogramOverlay;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.worldhopper.ping.Ping;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.http.api.worlds.World;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Histogram")
public class HistogramPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HistogramPlugin.class);
    @Inject
    private Client client;
    @Inject
    private HistogramConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private WorldService worldService;
    private HistogramOverlay histogramOverlay;
    private ScheduledExecutorService pingThreads;
    private int ping = -1;
    private int checksTilPing = 0;
    private static final int HOP_GAMESTATE = 45;

    protected void startUp() throws Exception {
        this.histogramOverlay = new HistogramOverlay(this.config);
        this.overlayManager.add((Overlay)this.histogramOverlay);
        this.pingThreads = Executors.newScheduledThreadPool(20);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.histogramOverlay);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.histogramOverlay.addEvent(EventType.TICK);
        if (this.config.useIdealTicks()) {
            this.histogramOverlay.addEvent(EventType.IDEAL_TICK, 0.6f);
        }
        this.pingThreads.schedule(this::updatePing, 0L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked e) {
        String menuOption = this.removeFormatting(e.getMenuOption());
        String menuTarget = this.removeFormatting(e.getMenuTarget());
        if (menuOption.equals("Wield") || menuOption.equals("Wear") || menuOption.equals("Remove") || menuOption.equals("Hold")) {
            this.histogramOverlay.addEvent(EventType.EQUIP, this.getInputDelay(EventType.EQUIP), this.getServerDelay(EventType.EQUIP));
            return;
        }
        if (menuOption.equals("Eat") || menuOption.equals("Drink")) {
            this.histogramOverlay.addEvent(EventType.EAT, this.getInputDelay(EventType.EAT), this.getServerDelay(EventType.EAT));
            return;
        }
        if (menuOption.equals("Walk here")) {
            this.histogramOverlay.addEvent(EventType.MOVE, this.getInputDelay(EventType.MOVE), this.getServerDelay(EventType.MOVE));
            return;
        }
        if (menuOption.equals("Use")) {
            if (menuTarget.equals("Special Attack")) {
                this.histogramOverlay.addEvent(EventType.SPECIAL_ATTACK, this.getInputDelay(EventType.SPECIAL_ATTACK), this.getServerDelay(EventType.SPECIAL_ATTACK));
                return;
            }
            this.histogramOverlay.addEvent(EventType.USE, this.getInputDelay(EventType.USE), this.getServerDelay(EventType.USE));
            return;
        }
        if (this.removeFormatting(menuOption).equals("Use Special Attack")) {
            this.histogramOverlay.addEvent(EventType.SPECIAL_ATTACK, this.getInputDelay(EventType.SPECIAL_ATTACK), this.getServerDelay(EventType.SPECIAL_ATTACK));
            return;
        }
        if (menuOption.equals("Attack")) {
            this.histogramOverlay.addEvent(EventType.ATTACK, this.getInputDelay(EventType.ATTACK), this.getServerDelay(EventType.ATTACK));
            return;
        }
        if (menuOption.equals("Activate") || menuOption.equals("Deactivate")) {
            this.histogramOverlay.addEvent(EventType.PRAYER, this.getInputDelay(EventType.PRAYER), this.getServerDelay(EventType.PRAYER));
            return;
        }
        if (this.handleCustomConfig(menuOption, menuTarget, this.config.custom1Interaction(), this.config.custom1Target(), EventType.CUSTOM_1)) {
            return;
        }
        if (this.handleCustomConfig(menuOption, menuTarget, this.config.custom2Interaction(), this.config.custom2Target(), EventType.CUSTOM_2)) {
            return;
        }
        if (this.handleCustomConfig(menuOption, menuTarget, this.config.custom3Interaction(), this.config.custom3Target(), EventType.CUSTOM_3)) {
            return;
        }
        if (this.handleCustomConfig(menuOption, menuTarget, this.config.custom4Interaction(), this.config.custom4Target(), EventType.CUSTOM_4)) {
            return;
        }
        if (this.handleCustomConfig(menuOption, menuTarget, this.config.custom5Interaction(), this.config.custom5Target(), EventType.CUSTOM_5)) {
            return;
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState().getState() == 45) {
            this.checksTilPing = 0;
        }
    }

    @Provides
    HistogramConfig provideConfig(ConfigManager configManager) {
        return (HistogramConfig)configManager.getConfig(HistogramConfig.class);
    }

    private float getInputDelay(EventType event) {
        float delay = (float)this.ping / 1000.0f;
        return Math.min(delay, (float)this.config.pingMax() / 1000.0f);
    }

    private void updatePing() {
        if (this.checksTilPing == 0) {
            int currentping = this.sendPing();
            if (currentping != -1) {
                this.ping = currentping;
                this.checksTilPing = this.config.pingCount() - 1;
            }
        } else {
            --this.checksTilPing;
        }
    }

    private int sendPing() {
        return Ping.ping((World)this.worldService.getWorlds().findWorld(this.client.getWorld()));
    }

    private int getPlayerCount() {
        return this.worldService.getWorlds().findWorld(this.client.getWorld()).getPlayers();
    }

    private String removeFormatting(String raw) {
        return raw.replaceAll("<[^>]*>", "");
    }

    private float getServerDelay(EventType type) {
        int playercount = this.getPlayerCount();
        switch (type) {
            case EQUIP: {
                return (float)this.config.equipConst() / 1000.0f + (float)this.config.equipMult() / 1000.0f * (float)playercount / 1000.0f;
            }
            case EAT: {
                return (float)this.config.eatConst() / 1000.0f + (float)this.config.eatMult() / 1000.0f * (float)playercount / 1000.0f;
            }
            case MOVE: {
                return (float)this.config.moveConst() / 1000.0f + (float)this.config.moveMult() / 1000.0f * (float)playercount / 1000.0f;
            }
            case USE: {
                return (float)this.config.useConst() / 1000.0f + (float)this.config.useMult() / 1000.0f * (float)playercount / 1000.0f;
            }
            case ATTACK: {
                return (float)this.config.attackConst() / 1000.0f + (float)this.config.attackMult() / 1000.0f * (float)playercount / 1000.0f;
            }
            case SPECIAL_ATTACK: {
                return (float)this.config.specialattackConst() / 1000.0f + (float)this.config.specialattackMult() / 1000.0f * (float)playercount / 1000.0f;
            }
            case PRAYER: {
                return (float)this.config.prayerConst() / 1000.0f + (float)this.config.prayerMult() / 1000.0f * (float)playercount / 1000.0f;
            }
            case CUSTOM_1: {
                return (float)this.config.custom1Const() / 1000.0f + (float)this.config.custom1Mult() / 1000.0f * (float)playercount / 1000.0f;
            }
            case CUSTOM_2: {
                return (float)this.config.custom2Const() / 1000.0f + (float)this.config.custom2Mult() / 1000.0f * (float)playercount / 1000.0f;
            }
            case CUSTOM_3: {
                return (float)this.config.custom3Const() / 1000.0f + (float)this.config.custom3Mult() / 1000.0f * (float)playercount / 1000.0f;
            }
            case CUSTOM_4: {
                return (float)this.config.custom4Const() / 1000.0f + (float)this.config.custom4Mult() / 1000.0f * (float)playercount / 1000.0f;
            }
            case CUSTOM_5: {
                return (float)this.config.custom5Const() / 1000.0f + (float)this.config.custom5Mult() / 1000.0f * (float)playercount / 1000.0f;
            }
        }
        return 0.0f;
    }

    private boolean handleCustomConfig(String menuOption, String menuTarget, String option, String target, EventType type) {
        if (option.isEmpty() && target.isEmpty()) {
            return false;
        }
        if ((option.isEmpty() || option.equals(menuOption)) && (target.isEmpty() || target.equals(menuTarget))) {
            this.histogramOverlay.addEvent(type, this.getInputDelay(type), this.getServerDelay(type));
            return true;
        }
        return false;
    }
}

