/*
 * Decompiled with CFR 0.152.
 */
package com.histogram;

import com.histogram.EventType;
import com.histogram.HistogramConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.ArrayDeque;
import net.runelite.client.ui.overlay.Overlay;

class HistogramOverlay
extends Overlay {
    private ArrayDeque<Event> events;
    private HistogramConfig config;
    private long lastnano;
    private float delta;

    HistogramOverlay(HistogramConfig config) {
        this.config = config;
        this.events = new ArrayDeque();
        this.lastnano = System.nanoTime();
    }

    public void addEvent(EventType type) {
        Event event = new Event(type);
        this.events.add(event);
    }

    public void addEvent(EventType type, float delay) {
        Event event = new Event(type);
        event.time -= delay;
        this.events.add(event);
    }

    public void addEvent(EventType type, float pingdelay, float serverdelay) {
        Event event = new Event(type);
        event.time -= pingdelay + serverdelay;
        event.serverOffset = serverdelay;
        event.inputOffset = pingdelay + serverdelay;
        this.events.add(event);
    }

    public Dimension render(Graphics2D graphics) {
        graphics.setColor(this.config.bgColor());
        graphics.fillRect(0, 0, this.config.panelSize().width, this.config.panelSize().height);
        this.updateDelta();
        this.updateEvents();
        this.drawEvents(graphics);
        return this.config.panelSize();
    }

    private void drawEvents(Graphics2D graphics) {
        for (Event event : this.events) {
            this.drawBar(graphics, event.time, event.type);
            if (event.inputOffset == 0.0f || event.serverOffset == 0.0f) continue;
            if (this.config.showInputLag()) {
                this.drawRange(graphics, event.time + event.inputOffset, event.time, event.type, this.config.inputLagAlpha());
            }
            if (!this.config.showServerLag()) continue;
            this.drawRange(graphics, event.time + event.serverOffset, event.time, event.type, this.config.serverLagAlpha());
        }
    }

    private void drawBar(Graphics2D graphics, float time, EventType type) {
        Color color = this.typeToColor(type);
        float xpos = this.lerp(this.config.panelSize().width, 0.0f, time / ((float)this.config.durationMS() / 1000.0f));
        int fullbarwidth = this.config.linewidth() - (this.config.antialiasing() ? 1 : 0);
        int fullbaroffset = (int)xpos + (this.config.antialiasing() ? 1 : 0);
        this.drawRect(graphics, color, fullbaroffset, fullbarwidth);
        if (this.config.antialiasing()) {
            float subpixel = xpos % 1.0f + (float)(xpos < 0.0f ? 1 : 0);
            Color left = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((float)color.getAlpha() * (1.0f - subpixel)));
            Color right = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((float)color.getAlpha() * subpixel));
            this.drawRect(graphics, left, (int)xpos, 1);
            this.drawRect(graphics, right, (int)xpos + this.config.linewidth(), 1);
        }
    }

    private void drawRange(Graphics2D graphics, float start, float end, EventType type, int alpha) {
        Color originalColor = this.typeToColor(type);
        Color color = new Color(originalColor.getRed(), originalColor.getGreen(), originalColor.getBlue(), (int)((float)originalColor.getAlpha() * ((float)alpha / 255.0f)));
        float xpos = this.lerp(this.config.panelSize().width, 0.0f, start / ((float)this.config.durationMS() / 1000.0f));
        float width = this.lerp(this.config.panelSize().width, 0.0f, end / ((float)this.config.durationMS() / 1000.0f)) - xpos;
        float subpixel = xpos % 1.0f + (float)(xpos < 0.0f ? 1 : 0);
        int fullbarwidth = (int)(width + subpixel + 1.0f);
        int fullbaroffset = (int)xpos + (this.config.antialiasing() ? 1 : 0);
        this.drawRect(graphics, color, fullbaroffset, fullbarwidth);
        if (this.config.antialiasing()) {
            Color left = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((float)color.getAlpha() * (1.0f - subpixel)));
            this.drawRect(graphics, left, (int)xpos, 1);
        }
    }

    private void drawRect(Graphics2D graphics, Color color, int xpos, int width) {
        if (width <= 0) {
            return;
        }
        if (xpos + width < 0 || xpos >= this.config.panelSize().width) {
            return;
        }
        if (color.getAlpha() == 0) {
            return;
        }
        int boundedx = Math.max(xpos, 0);
        int boundedw = Math.min(xpos + width, this.config.panelSize().width) - boundedx;
        graphics.setColor(color);
        graphics.fillRect(boundedx, 0, boundedw, this.config.panelSize().height);
    }

    private Color typeToColor(EventType type) {
        switch (type) {
            case TICK: {
                return this.config.tickColor();
            }
            case IDEAL_TICK: {
                return this.config.idealTickColor();
            }
            case EQUIP: {
                return this.config.equipColor();
            }
            case EAT: {
                return this.config.eatColor();
            }
            case MOVE: {
                return this.config.moveColor();
            }
            case USE: {
                return this.config.useColor();
            }
            case ATTACK: {
                return this.config.attackColor();
            }
            case SPECIAL_ATTACK: {
                return this.config.specColor();
            }
            case PRAYER: {
                return this.config.prayerColor();
            }
            case CUSTOM_1: {
                return this.config.custom1Color();
            }
            case CUSTOM_2: {
                return this.config.custom2Color();
            }
            case CUSTOM_3: {
                return this.config.custom3Color();
            }
            case CUSTOM_4: {
                return this.config.custom4Color();
            }
            case CUSTOM_5: {
                return this.config.custom5Color();
            }
        }
        return this.config.tickColor();
    }

    private float lerp(float a, float b, float t) {
        return a * (1.0f - t) + b * t;
    }

    private void updateDelta() {
        long nano = System.nanoTime();
        this.delta = (float)(nano - this.lastnano) / 1.0E9f;
        this.lastnano = nano;
    }

    public void updateEvents() {
        for (Event event : this.events) {
            event.time += this.delta;
        }
        float extratime = 1.0f + (float)this.config.linewidth() / (float)this.config.panelSize().width;
        while (!this.events.isEmpty() && this.events.peek().time > (float)this.config.durationMS() / 1000.0f * extratime) {
            this.events.removeFirst();
        }
    }

    private class Event {
        public EventType type;
        public float time;
        public float inputOffset;
        public float serverOffset;

        Event(EventType type) {
            this.type = type;
            this.time = 0.0f;
            this.inputOffset = 0.0f;
            this.serverOffset = 0.0f;
        }
    }
}

