/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.shootingstars.ui.panels;

import com.andmcadams.shootingstars.ShootingStarsData;
import com.andmcadams.shootingstars.ui.panels.ShootingStarsPluginPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;

public class ShootingStarsSinglePanel
extends JPanel {
    private static final Color INCOMING = Color.YELLOW;
    private static final Color LANDED = Color.GREEN;
    private JLabel nameLabel;
    private JLabel world;
    private JLabel time;
    private ShootingStarsData starData;
    private Color lastBackground;

    public ShootingStarsSinglePanel(final ShootingStarsData starData, final Consumer<Integer> onSelect) {
        this.starData = starData;
        this.setLayout((LayoutManager)new DynamicGridLayout(2, 1, 0, 5));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setOpaque(false);
        this.world = new JLabel("World " + starData.getWorld());
        this.nameLabel = new JLabel("<html>" + starData.getShootingStarsLocation().getName() + "</html>");
        this.nameLabel.setHorizontalAlignment(2);
        this.nameLabel.setBorder(new EmptyBorder(0, 10, 0, 0));
        topPanel.add((Component)this.world, "West");
        topPanel.add((Component)this.nameLabel, "Center");
        this.time = new JLabel();
        this.updateLabels();
        this.add(topPanel);
        this.add(this.time);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && onSelect != null) {
                    onSelect.accept(starData.getWorld());
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ShootingStarsSinglePanel.this.setBackground(ShootingStarsSinglePanel.this.getBackground().brighter());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ShootingStarsSinglePanel.this.setBackground(ShootingStarsSinglePanel.this.getBackground().darker());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ShootingStarsSinglePanel.this.lastBackground = ShootingStarsSinglePanel.this.getBackground();
                ShootingStarsSinglePanel.this.setBackground(ShootingStarsSinglePanel.this.getBackground().brighter());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ShootingStarsSinglePanel.this.setBackground(ShootingStarsSinglePanel.this.lastBackground);
            }
        });
    }

    private boolean updateLanded() {
        boolean hasLanded = this.starData.hasLanded();
        Color c = hasLanded ? LANDED : INCOMING;
        this.nameLabel.setForeground(c);
        return hasLanded;
    }

    private void updateTime() {
        this.time.setText(this.starData.getLandingTime());
    }

    public void updateLabels() {
        this.updateLanded();
        this.updateTime();
        this.repaint();
        this.revalidate();
    }

    public void createRightClickMenu(ShootingStarsPluginPanel panel) {
        JPopupMenu rightClickMenu = new JPopupMenu();
        rightClickMenu.setBorder(new EmptyBorder(1, 1, 1, 1));
        JMenuItem removeEntryOption = new JMenuItem();
        removeEntryOption.setText("Hide for this wave");
        removeEntryOption.setFont(FontManager.getRunescapeSmallFont());
        removeEntryOption.addActionListener(e -> panel.hideWorld(this.starData.getWorld(), this.starData.getMaxTime()));
        removeEntryOption.setBorder(new EmptyBorder(5, 0, 5, 0));
        JMenuItem resetHiddenWorldsOptions = new JMenuItem();
        resetHiddenWorldsOptions.setText("Unhide all worlds");
        resetHiddenWorldsOptions.setFont(FontManager.getRunescapeSmallFont());
        resetHiddenWorldsOptions.addActionListener(e -> panel.resetHiddenWorlds());
        resetHiddenWorldsOptions.setBorder(new EmptyBorder(5, 0, 5, 0));
        rightClickMenu.add(removeEntryOption);
        rightClickMenu.add(resetHiddenWorldsOptions);
        this.setComponentPopupMenu(rightClickMenu);
    }

    public ShootingStarsData getStarData() {
        return this.starData;
    }
}

