/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.shootingstars.ui.panels;

import com.andmcadams.shootingstars.ShootingStarsData;
import com.andmcadams.shootingstars.ShootingStarsPlugin;
import com.andmcadams.shootingstars.ui.ShootingStarsPluginPanelBase;
import com.andmcadams.shootingstars.ui.panels.FixedWidthPanel;
import com.andmcadams.shootingstars.ui.panels.ShootingStarsSinglePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;

public class ShootingStarsPluginPanel
extends ShootingStarsPluginPanelBase {
    FixedWidthPanel starsListPanel = new FixedWidthPanel();
    ArrayList<ShootingStarsSinglePanel> starsList = new ArrayList();
    private JScrollPane scrollPane;
    private GridBagConstraints c = new GridBagConstraints();

    public ShootingStarsPluginPanel(ShootingStarsPlugin plugin) {
        super(plugin, false);
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel topContainer = new JPanel();
        topContainer.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        titlePanel.setLayout(new BorderLayout());
        JLabel title = new JLabel();
        title.setText("Shooting Stars");
        title.setForeground(Color.WHITE);
        titlePanel.add((Component)title, "West");
        topContainer.add((Component)titlePanel, "North");
        this.add(topContainer, "North");
        this.starsListPanel.setLayout(new GridBagLayout());
        this.starsListPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.c.insets = new Insets(0, 2, 2, 2);
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.c.gridx = 0;
        this.c.anchor = 19;
        this.scrollPane = new JScrollPane(this.starsListPanel);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setBorder(new EmptyBorder(1, 0, 0, 0));
        this.scrollPane.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.add(this.scrollPane, "Center");
    }

    public void addStar(JPanel shootingStarsPanel, ShootingStarsData data) {
        ShootingStarsSinglePanel starsSinglePanel = new ShootingStarsSinglePanel(data, this.plugin::hopTo);
        starsSinglePanel.createRightClickMenu(this);
        shootingStarsPanel.add((Component)starsSinglePanel, this.c);
        ++this.c.gridy;
        this.starsList.add(starsSinglePanel);
    }

    @Override
    public void populate(List<ShootingStarsData> starsData) {
        this.c.gridy = 0;
        this.c.weighty = 0.0;
        for (ShootingStarsSinglePanel starsSinglePanel : this.starsList) {
            this.starsListPanel.remove(starsSinglePanel);
        }
        this.starsList.clear();
        ShootingStarsData lastData = null;
        for (ShootingStarsData starData : starsData) {
            if (lastData != null) {
                this.addStar(this.starsListPanel, lastData);
            }
            lastData = starData;
        }
        this.c.weighty = 1.0;
        if (lastData != null) {
            this.addStar(this.starsListPanel, lastData);
        }
        this.repaint();
        this.revalidate();
    }

    @Override
    public void updateList() {
        for (ShootingStarsSinglePanel starsSinglePanel : this.starsList) {
            starsSinglePanel.updateLabels();
        }
    }
}

