/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.shootingstars.ui.condensed;

import com.andmcadams.shootingstars.ShootingStarsLocation;
import com.andmcadams.shootingstars.ui.condensed.ShootingStarsCondensedPluginPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Duration;
import java.time.Instant;
import java.util.EnumSet;
import java.util.function.Consumer;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldType;

public class ShootingStarsTableRow
extends JPanel {
    private static final int WORLD_COLUMN_WIDTH = 35;
    private static final int TIME_COLUMN_WIDTH = 45;
    private static final int TYPE_COLUMN_WIDTH = 35;
    private static final Color CURRENT_WORLD = new Color(66, 227, 17);
    private static final Color DANGEROUS_WORLD = new Color(251, 62, 62);
    private static final Color BETA_WORLD = new Color(79, 145, 255);
    private static final Color MEMBERS_WORLD = new Color(210, 193, 53);
    private static final Color FREE_WORLD = new Color(200, 200, 200);
    private static final Color LEAGUE_WORLD = new Color(133, 177, 178);
    private static final Color COLOR_NEGATIVE = new Color(255, 80, 80);
    private JLabel worldField;
    private JLabel minTimeField;
    private JLabel maxTimeField;
    private JLabel locationField;
    private JLabel worldTypeField;
    private final World world;
    private Instant minTime;
    private boolean minPast;
    private Instant maxTime;
    private boolean maxPast;
    private ShootingStarsLocation starLocation;
    private Color lastBackground;
    private final MouseAdapter labelMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ShootingStarsTableRow.this.dispatchEvent(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ShootingStarsTableRow.this.dispatchEvent(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ShootingStarsTableRow.this.dispatchEvent(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            ShootingStarsTableRow.this.dispatchEvent(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ShootingStarsTableRow.this.dispatchEvent(mouseEvent);
        }
    };

    ShootingStarsTableRow(final World world, boolean current, Instant minTime, Instant maxTime, ShootingStarsLocation location, final Consumer<World> onSelect) {
        this.world = world;
        this.minTime = minTime;
        this.maxTime = maxTime;
        this.starLocation = location;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && onSelect != null) {
                    onSelect.accept(world);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ShootingStarsTableRow.this.setBackground(ShootingStarsTableRow.this.getBackground().brighter());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ShootingStarsTableRow.this.setBackground(ShootingStarsTableRow.this.getBackground().darker());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ShootingStarsTableRow.this.lastBackground = ShootingStarsTableRow.this.getBackground();
                ShootingStarsTableRow.this.setBackground(ShootingStarsTableRow.this.getBackground().brighter());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ShootingStarsTableRow.this.setBackground(ShootingStarsTableRow.this.lastBackground);
            }
        });
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        leftSide.setOpaque(false);
        rightSide.setOpaque(false);
        JPanel worldField = this.buildWorldField();
        worldField.setPreferredSize(new Dimension(35, 0));
        worldField.setOpaque(false);
        JPanel minTimeField = this.buildMinTimeField();
        minTimeField.setPreferredSize(new Dimension(45, 0));
        minTimeField.setOpaque(false);
        JPanel maxTimeField = this.buildMaxTimeField();
        maxTimeField.setPreferredSize(new Dimension(45, 0));
        maxTimeField.setOpaque(false);
        JPanel locationField = this.buildLocationField();
        locationField.setBorder(new EmptyBorder(5, 5, 5, 5));
        locationField.setOpaque(false);
        JPanel typeField = this.buildTypeField();
        typeField.setPreferredSize(new Dimension(35, 0));
        typeField.setOpaque(false);
        this.updateStatus(current);
        leftSide.add((Component)worldField, "West");
        leftSide.add((Component)minTimeField, "Center");
        leftSide.add((Component)maxTimeField, "East");
        rightSide.add((Component)locationField, "Center");
        rightSide.add((Component)typeField, "East");
        this.add((Component)leftSide, "West");
        this.add((Component)rightSide, "Center");
    }

    void updateStatus(boolean current) {
        StringBool min = ShootingStarsTableRow.timeString(this.minTime);
        StringBool max = ShootingStarsTableRow.timeString(this.maxTime);
        this.minTimeField.setText(min.getString());
        this.maxTimeField.setText(max.getString());
        this.locationField.setText(this.starLocation.getShortName());
        if (!this.starLocation.getName().equals(this.starLocation.getShortName())) {
            ((JPanel)this.locationField.getParent()).setToolTipText(this.starLocation.getName());
        }
        this.minPast = min.isBoolValue();
        this.maxPast = max.isBoolValue();
        if (this.minPast && this.maxPast) {
            this.minTimeField.setForeground(COLOR_NEGATIVE);
            this.maxTimeField.setForeground(COLOR_NEGATIVE);
            this.locationField.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        } else if (this.minPast) {
            this.minTimeField.setForeground(COLOR_NEGATIVE);
            this.maxTimeField.setForeground(Color.WHITE);
            this.locationField.setForeground(Color.YELLOW);
        } else {
            this.minTimeField.setForeground(Color.WHITE);
            this.maxTimeField.setForeground(Color.WHITE);
            this.locationField.setForeground(ColorScheme.PROGRESS_INPROGRESS_COLOR);
        }
        this.recolour(current);
    }

    void updateInfo(Instant minTime, Instant maxTime, ShootingStarsLocation location, boolean current) {
        this.minTime = minTime;
        this.maxTime = maxTime;
        this.starLocation = location;
        this.updateStatus(current);
    }

    private static StringBool timeString(Instant time) {
        long s = Duration.between(Instant.now(), time).getSeconds();
        boolean negative = false;
        if (s < 0L) {
            s *= -1L;
            negative = true;
        }
        long mins = s / 60L;
        long secs = s % 60L;
        String str = negative ? (mins > 9L ? String.format("-%dm", mins) : String.format("-%1d:%02d", mins, secs)) : (mins > 99L ? String.format("%dm", mins) : String.format("%1d:%02d", mins, secs));
        return new StringBool(str, negative);
    }

    public void recolour(boolean current) {
        if (current) {
            this.worldTypeField.setForeground(CURRENT_WORLD);
            this.worldField.setForeground(CURRENT_WORLD);
            return;
        }
        if (this.world.getTypes().contains(WorldType.PVP) || this.world.getTypes().contains(WorldType.HIGH_RISK) || this.world.getTypes().contains(WorldType.DEADMAN) || this.world.getTypes().contains(WorldType.TOURNAMENT)) {
            this.worldTypeField.setForeground(DANGEROUS_WORLD);
        } else if (this.world.getTypes().contains(WorldType.SEASONAL)) {
            this.worldTypeField.setForeground(LEAGUE_WORLD);
        } else if (this.world.getTypes().contains(WorldType.NOSAVE_MODE)) {
            this.worldTypeField.setForeground(BETA_WORLD);
        } else {
            this.worldTypeField.setForeground(Color.WHITE);
        }
        this.worldField.setForeground(this.world.getTypes().contains(WorldType.MEMBERS) ? MEMBERS_WORLD : FREE_WORLD);
    }

    private JPanel buildWorldField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.worldField = new JLabel("" + this.world.getId());
        column.add((Component)this.worldField, "West");
        return column;
    }

    private JPanel buildMinTimeField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.minTimeField = new JLabel();
        this.minTimeField.setFont(FontManager.getRunescapeSmallFont());
        this.minTimeField.setHorizontalAlignment(4);
        column.add((Component)this.minTimeField, "Center");
        return column;
    }

    private JPanel buildMaxTimeField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.maxTimeField = new JLabel();
        this.maxTimeField.setFont(FontManager.getRunescapeSmallFont());
        this.maxTimeField.setHorizontalAlignment(4);
        column.add((Component)this.maxTimeField, "Center");
        return column;
    }

    private JPanel buildLocationField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.locationField = new JLabel();
        this.locationField.setFont(FontManager.getRunescapeSmallFont());
        column.add((Component)this.locationField, "Center");
        column.addMouseListener(this.labelMouseListener);
        return column;
    }

    private JPanel buildTypeField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        String act = this.world.getActivity();
        StringBuilder sb = new StringBuilder();
        EnumSet types = this.world.getTypes();
        if (types.contains(WorldType.SKILL_TOTAL)) {
            sb.append(act.split(" ")[0]);
        }
        if (types.contains(WorldType.PVP)) {
            sb.append("P");
        }
        if (types.contains(WorldType.DEADMAN)) {
            sb.append("D");
        }
        if (types.contains(WorldType.TOURNAMENT)) {
            sb.append("C");
        }
        if (types.contains(WorldType.SEASONAL)) {
            sb.append("S");
        }
        if (types.contains(WorldType.HIGH_RISK)) {
            sb.append("H");
        }
        if (types.contains(WorldType.NOSAVE_MODE)) {
            sb.append("B");
        }
        if (act.toLowerCase().contains("target")) {
            sb.append("T");
        }
        this.worldTypeField = new JLabel(sb.toString());
        this.worldTypeField.setFont(FontManager.getRunescapeSmallFont());
        column.add((Component)this.worldTypeField, "East");
        if (!act.equals("-")) {
            column.setToolTipText(act);
        }
        column.addMouseListener(this.labelMouseListener);
        return column;
    }

    public void createRightClickMenu(ShootingStarsCondensedPluginPanel panel) {
        JPopupMenu rightClickMenu = new JPopupMenu();
        rightClickMenu.setBorder(new EmptyBorder(1, 1, 1, 1));
        JMenuItem removeEntryOption = new JMenuItem();
        removeEntryOption.setText("Hide for this wave");
        removeEntryOption.setFont(FontManager.getRunescapeSmallFont());
        removeEntryOption.addActionListener(e -> panel.hideWorld(this.world.getId(), this.maxTime.getEpochSecond()));
        removeEntryOption.setBorder(new EmptyBorder(5, 0, 5, 0));
        JMenuItem resetHiddenWorldsOptions = new JMenuItem();
        resetHiddenWorldsOptions.setText("Unhide all worlds");
        resetHiddenWorldsOptions.setFont(FontManager.getRunescapeSmallFont());
        resetHiddenWorldsOptions.addActionListener(e -> panel.resetHiddenWorlds());
        resetHiddenWorldsOptions.setBorder(new EmptyBorder(5, 0, 5, 0));
        rightClickMenu.add(removeEntryOption);
        rightClickMenu.add(resetHiddenWorldsOptions);
        this.setComponentPopupMenu(rightClickMenu);
        ((JPanel)this.locationField.getParent()).setComponentPopupMenu(rightClickMenu);
        ((JPanel)this.worldTypeField.getParent()).setComponentPopupMenu(rightClickMenu);
    }

    public String getWorldType() {
        return this.worldTypeField.getText();
    }

    public World getWorld() {
        return this.world;
    }

    public Instant getMinTime() {
        return this.minTime;
    }

    public boolean isMinPast() {
        return this.minPast;
    }

    public Instant getMaxTime() {
        return this.maxTime;
    }

    public boolean isMaxPast() {
        return this.maxPast;
    }

    public ShootingStarsLocation getStarLocation() {
        return this.starLocation;
    }

    private static final class StringBool {
        private final String string;
        private final boolean boolValue;

        public String getString() {
            return this.string;
        }

        public boolean isBoolValue() {
            return this.boolValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringBool)) {
                return false;
            }
            StringBool other = (StringBool)o;
            String this$string = this.getString();
            String other$string = other.getString();
            if (this$string == null ? other$string != null : !this$string.equals(other$string)) {
                return false;
            }
            return this.isBoolValue() == other.isBoolValue();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $string = this.getString();
            result = result * 59 + ($string == null ? 43 : $string.hashCode());
            result = result * 59 + (this.isBoolValue() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "ShootingStarsTableRow.StringBool(string=" + this.getString() + ", boolValue=" + this.isBoolValue() + ")";
        }

        public StringBool(String string, boolean boolValue) {
            this.string = string;
            this.boolValue = boolValue;
        }
    }
}

