/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.shootingstars.ui.condensed;

import com.andmcadams.shootingstars.ShootingStarsData;
import com.andmcadams.shootingstars.ShootingStarsLocation;
import com.andmcadams.shootingstars.ShootingStarsPlugin;
import com.andmcadams.shootingstars.ui.ShootingStarsPluginPanelBase;
import com.andmcadams.shootingstars.ui.condensed.ShootingStarsOrder;
import com.andmcadams.shootingstars.ui.condensed.ShootingStarsPanelHeader;
import com.andmcadams.shootingstars.ui.condensed.ShootingStarsTableRow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldType;

public class ShootingStarsCondensedPluginPanel
extends ShootingStarsPluginPanelBase {
    private static final Color ODD_ROW = new Color(44, 44, 44);
    private static final int WORLD_COLUMN_WIDTH = 35;
    private static final int TIME_COLUMN_WIDTH = 45;
    private static final int TYPE_COLUMN_WIDTH = 35;
    private final JPanel listContainer = new JPanel();
    private ShootingStarsPanelHeader worldHeader;
    private ShootingStarsPanelHeader minTimeHeader;
    private ShootingStarsPanelHeader maxTimeHeader;
    private ShootingStarsPanelHeader locationHeader;
    private ShootingStarsPanelHeader worldTypeHeader;
    private ShootingStarsOrder orderIndex = ShootingStarsOrder.MAX_TIME;
    private boolean ascendingOrder = true;
    private final ArrayList<ShootingStarsTableRow> rows = new ArrayList();

    public ShootingStarsCondensedPluginPanel(ShootingStarsPlugin plugin) {
        super(plugin);
        this.setBorder(null);
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        JPanel headerContainer = this.buildHeader();
        this.listContainer.setLayout(new GridLayout(0, 1));
        this.add(headerContainer);
        this.add(this.listContainer);
    }

    private JPanel buildHeader() {
        JPanel header = new JPanel(new BorderLayout());
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        this.worldHeader = new ShootingStarsPanelHeader("W", this.orderIndex == ShootingStarsOrder.WORLD, this.ascendingOrder);
        this.worldHeader.setPreferredSize(new Dimension(35, 0));
        this.worldHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                ShootingStarsCondensedPluginPanel.this.ascendingOrder = ShootingStarsCondensedPluginPanel.this.orderIndex != ShootingStarsOrder.WORLD || !ShootingStarsCondensedPluginPanel.this.ascendingOrder;
                ShootingStarsCondensedPluginPanel.this.orderBy(ShootingStarsOrder.WORLD);
            }
        });
        this.minTimeHeader = new ShootingStarsPanelHeader("Min", this.orderIndex == ShootingStarsOrder.MIN_TIME, this.ascendingOrder);
        this.minTimeHeader.setPreferredSize(new Dimension(45, 0));
        this.minTimeHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                ShootingStarsCondensedPluginPanel.this.ascendingOrder = ShootingStarsCondensedPluginPanel.this.orderIndex != ShootingStarsOrder.MIN_TIME || !ShootingStarsCondensedPluginPanel.this.ascendingOrder;
                ShootingStarsCondensedPluginPanel.this.orderBy(ShootingStarsOrder.MIN_TIME);
            }
        });
        this.maxTimeHeader = new ShootingStarsPanelHeader("Max", this.orderIndex == ShootingStarsOrder.MAX_TIME, this.ascendingOrder);
        this.maxTimeHeader.setPreferredSize(new Dimension(45, 0));
        this.maxTimeHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                ShootingStarsCondensedPluginPanel.this.ascendingOrder = ShootingStarsCondensedPluginPanel.this.orderIndex != ShootingStarsOrder.MAX_TIME || !ShootingStarsCondensedPluginPanel.this.ascendingOrder;
                ShootingStarsCondensedPluginPanel.this.orderBy(ShootingStarsOrder.MAX_TIME);
            }
        });
        this.locationHeader = new ShootingStarsPanelHeader("Location", this.orderIndex == ShootingStarsOrder.LOCATION, this.ascendingOrder);
        this.locationHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                ShootingStarsCondensedPluginPanel.this.ascendingOrder = ShootingStarsCondensedPluginPanel.this.orderIndex != ShootingStarsOrder.LOCATION || !ShootingStarsCondensedPluginPanel.this.ascendingOrder;
                ShootingStarsCondensedPluginPanel.this.orderBy(ShootingStarsOrder.LOCATION);
            }
        });
        this.worldTypeHeader = new ShootingStarsPanelHeader("T", this.orderIndex == ShootingStarsOrder.TYPE, this.ascendingOrder);
        this.worldTypeHeader.setPreferredSize(new Dimension(35, 0));
        this.worldTypeHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                ShootingStarsCondensedPluginPanel.this.ascendingOrder = ShootingStarsCondensedPluginPanel.this.orderIndex != ShootingStarsOrder.TYPE || !ShootingStarsCondensedPluginPanel.this.ascendingOrder;
                ShootingStarsCondensedPluginPanel.this.orderBy(ShootingStarsOrder.TYPE);
            }
        });
        leftSide.add((Component)this.worldHeader, "West");
        leftSide.add((Component)this.minTimeHeader, "Center");
        leftSide.add((Component)this.maxTimeHeader, "East");
        rightSide.add((Component)this.locationHeader, "Center");
        rightSide.add((Component)this.worldTypeHeader, "East");
        header.add((Component)leftSide, "West");
        header.add((Component)rightSide, "Center");
        return header;
    }

    private void orderBy(ShootingStarsOrder order) {
        this.worldHeader.highlight(false, this.ascendingOrder);
        this.minTimeHeader.highlight(false, this.ascendingOrder);
        this.maxTimeHeader.highlight(false, this.ascendingOrder);
        this.locationHeader.highlight(false, this.ascendingOrder);
        this.worldTypeHeader.highlight(false, this.ascendingOrder);
        switch (order) {
            case WORLD: {
                this.worldHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case MIN_TIME: {
                this.minTimeHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case MAX_TIME: {
                this.maxTimeHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case LOCATION: {
                this.locationHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case TYPE: {
                this.worldTypeHeader.highlight(true, this.ascendingOrder);
            }
        }
        this.orderIndex = order;
        this.updateList();
    }

    @Override
    public void updateList() {
        this.rows.sort((r1, r2) -> {
            switch (this.orderIndex) {
                case WORLD: {
                    return this.getCompareValue((ShootingStarsTableRow)r1, (ShootingStarsTableRow)r2, row -> Integer.valueOf(row.getWorld().getId()));
                }
                case MIN_TIME: {
                    return this.getCompareValue((ShootingStarsTableRow)r1, (ShootingStarsTableRow)r2, ShootingStarsTableRow::getMinTime);
                }
                case MAX_TIME: {
                    return this.getCompareValue((ShootingStarsTableRow)r1, (ShootingStarsTableRow)r2, ShootingStarsTableRow::getMaxTime);
                }
                case LOCATION: {
                    return this.getCompareValue((ShootingStarsTableRow)r1, (ShootingStarsTableRow)r2, row -> row.getStarLocation().getShortName());
                }
                case TYPE: {
                    return this.getCompareValue((ShootingStarsTableRow)r1, (ShootingStarsTableRow)r2, ShootingStarsTableRow::getWorldType);
                }
            }
            return 0;
        });
        this.listContainer.removeAll();
        int currentWorld = this.plugin.getCurrentWorld();
        int i = 0;
        for (ShootingStarsTableRow row : this.rows) {
            Duration timeSinceLanded = Duration.between(row.getMaxTime(), Instant.now());
            if (timeSinceLanded.toMinutes() >= (long)this.plugin.getConfig().shootingStarExpirationLength()) continue;
            row.updateStatus(row.getWorld().getId() == currentWorld);
            this.setColorOnRow(row, i++ % 2 == 0);
            this.listContainer.add(row);
        }
        this.listContainer.revalidate();
        this.listContainer.repaint();
    }

    private int getCompareValue(ShootingStarsTableRow row1, ShootingStarsTableRow row2, Function<ShootingStarsTableRow, Comparable> compareByFn) {
        Comparator<ShootingStarsTableRow> c = this.ascendingOrder ? Comparator.comparing(compareByFn, Comparator.naturalOrder()) : Comparator.comparing(compareByFn, Comparator.reverseOrder());
        return c.thenComparing(ShootingStarsTableRow::getMaxTime, Comparator.naturalOrder()).compare(row1, row2);
    }

    @Override
    public void populate(List<ShootingStarsData> stars) {
        this.rows.clear();
        for (int i = 0; i < stars.size(); ++i) {
            ShootingStarsData star = stars.get(i);
            this.rows.add(this.buildRow(star, i % 2 == 0));
        }
        this.updateList();
    }

    private ShootingStarsTableRow buildRow(ShootingStarsData star, boolean stripe) {
        World world = this.plugin.getWorldService().getWorlds().findWorld(star.getWorld());
        boolean current = this.plugin.getCurrentWorld() == star.getWorld();
        ShootingStarsTableRow row = new ShootingStarsTableRow(world, current, Instant.ofEpochSecond(star.getMinTime()), Instant.ofEpochSecond(star.getMaxTime()), star.getShootingStarsLocation(), this.plugin::hopTo);
        row.createRightClickMenu(this);
        this.setColorOnRow(row, stripe);
        return row;
    }

    private void setColorOnRow(ShootingStarsTableRow row, boolean stripe) {
        Color c;
        EnumSet types = row.getWorld().getTypes();
        Color color = c = stripe ? ODD_ROW : ColorScheme.DARK_GRAY_COLOR;
        if (row.getStarLocation() == ShootingStarsLocation.WILDERNESS || types.contains(WorldType.PVP) || types.contains(WorldType.DEADMAN) || types.contains(WorldType.TOURNAMENT)) {
            c = new Color(c.getRed(), c.getGreen() / 2, c.getBlue() / 2, c.getAlpha());
        }
        row.setBackground(c);
    }
}

