/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.shootingstars;

import com.andmcadams.shootingstars.ShootingStarsConfig;
import com.andmcadams.shootingstars.ShootingStarsData;
import com.andmcadams.shootingstars.ShootingStarsDataManager;
import com.andmcadams.shootingstars.ShootingStarsLocation;
import com.andmcadams.shootingstars.ShootingStarsOverlayPanel;
import com.andmcadams.shootingstars.ui.ShootingStarsPluginPanelBase;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.World;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.WorldUtil;
import net.runelite.http.api.worlds.WorldResult;
import net.runelite.http.api.worlds.WorldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Shooting Stars", description="Crowdsources the locations of shooting stars", tags={"stars", "mining", "shooting star"})
public class ShootingStarsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ShootingStarsPlugin.class);
    @Inject
    Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ShootingStarsDataManager manager;
    @Inject
    private ShootingStarsConfig config;
    @Inject
    private ShootingStarsOverlayPanel overlayPanel;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ClientThread clientThread;
    @Inject
    private WorldService worldService;
    private final int SECONDS_BETWEEN_UPLOADS = 10;
    private final int SECONDS_BETWEEN_GET = 5;
    private final int SECONDS_BETWEEN_PANEL_REFRESH = 5;
    private boolean canRefresh;
    private ShootingStarsLocation lastLoc;
    private int lastWorld;
    static final String CONFIG_GROUP_KEY = "shootingstar";
    private String shootingStarPostEndpoint;
    private String shootingStarGetEndpoint;
    private String shootingStarsSharedKey;
    private ArrayList<ShootingStarsData> starData = new ArrayList();
    private final HashMap<Integer, Long> hiddenWorlds = new HashMap();
    private boolean postError = false;
    private boolean getError = false;
    private boolean keyError = false;
    private ShootingStarsPluginPanelBase shootingStarsPanel;
    private NavigationButton navButton = null;
    private final BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/shooting_stars_icon.png");
    private final Pattern firstMinThenHour = Pattern.compile(".* next (\\d+) minutes to (\\d+) hours? (\\d+) .*");
    private final Pattern hourRegex = Pattern.compile(".* next (\\d+) hours? (\\d+) minutes? to (\\d+) hours? (\\d+) .*");
    private final Pattern minutes = Pattern.compile(".* (\\d+) to (\\d+) .*");
    private static final int MAX_TIME_ADJ = 59;
    private final Pattern validKeyRegex = Pattern.compile("^[a-zA-Z]{1,10}$");
    private static final int DISPLAY_SWITCHER_MAX_ATTEMPTS = 3;
    private World quickHopTargetWorld;
    private int displaySwitcherAttempts = 0;

    @Provides
    ShootingStarsConfig getConfig(ConfigManager configManager) {
        return (ShootingStarsConfig)configManager.getConfig(ShootingStarsConfig.class);
    }

    protected void startUp() throws Exception {
        this.lastLoc = null;
        this.lastWorld = -1;
        this.canRefresh = true;
        this.shootingStarPostEndpoint = this.config.shootingStarPostEndpointConfig();
        this.shootingStarGetEndpoint = this.config.shootingStarGetEndpointConfig();
        this.shootingStarsSharedKey = this.config.shootingStarSharedKeyConfig();
        this.keyError = this.isInvalidKey(this.shootingStarsSharedKey);
        this.overlayManager.add((Overlay)this.overlayPanel);
        this.loadPluginPanel();
    }

    protected void shutDown() throws Exception {
        this.lastLoc = null;
        this.lastWorld = -1;
        this.overlayManager.remove((Overlay)this.overlayPanel);
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals(CONFIG_GROUP_KEY)) {
            return;
        }
        switch (event.getKey()) {
            case "post endpoint": {
                this.shootingStarPostEndpoint = this.config.shootingStarPostEndpointConfig();
                this.manager.makePostRequest(new ArrayList<Object>());
                break;
            }
            case "get endpoint": {
                this.shootingStarGetEndpoint = this.config.shootingStarGetEndpointConfig();
                this.manager.makeGetRequest();
                break;
            }
            case "password": {
                this.shootingStarsSharedKey = this.config.shootingStarSharedKeyConfig();
                this.keyError = this.isInvalidKey(this.shootingStarsSharedKey);
                this.canRefresh = true;
                break;
            }
            case "panelclass": {
                this.loadPluginPanel();
                this.updatePanelList();
                break;
            }
            case "sidebar icon": {
                if (this.config.showSidebarIcon()) {
                    this.clientToolbar.addNavigation(this.navButton);
                    break;
                }
                this.clientToolbar.removeNavigation(this.navButton);
                break;
            }
            default: {
                this.updatePanelList();
            }
        }
    }

    private void loadPluginPanel() {
        if (this.navButton != null) {
            this.clientToolbar.removeNavigation(this.navButton);
        }
        Class<? extends ShootingStarsPluginPanelBase> clazz = this.config.shootingStarsPanelType().getPanelClass();
        try {
            this.shootingStarsPanel = clazz.getDeclaredConstructor(((Object)((Object)this)).getClass()).newInstance(new Object[]{this});
        }
        catch (Exception e) {
            log.error("Error loading panel class", (Throwable)e);
            return;
        }
        this.navButton = NavigationButton.builder().tooltip("Shooting Stars").icon(this.icon).priority(7).panel((PluginPanel)this.shootingStarsPanel).build();
        if (this.config.showSidebarIcon()) {
            this.clientToolbar.addNavigation(this.navButton);
        }
    }

    private void recordEvent(ShootingStarsLocation loc, int world, int minTime, int maxTime) {
        long currentTime = Instant.now().toEpochMilli();
        long lminTime = currentTime / 1000L + (long)(minTime * 60);
        long lmaxTime = currentTime / 1000L + (long)(maxTime * 60) + 59L;
        this.manager.storeEvent(new ShootingStarsData(loc, world, lminTime, lmaxTime));
        this.lastWorld = world;
        this.lastLoc = loc;
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.handleHop();
        Widget chatbox = this.client.getWidget(229, 1);
        if (chatbox != null) {
            int world = this.client.getWorld();
            ShootingStarsLocation loc = ShootingStarsLocation.determineLocation(chatbox.getText());
            if (world != this.lastWorld || loc != null && loc != this.lastLoc) {
                String text = chatbox.getText();
                Matcher m = this.firstMinThenHour.matcher(text = text.replace("<br>", " "));
                if (m.find()) {
                    int minTime = Integer.parseInt(m.group(1));
                    int maxTime = 60 * Integer.parseInt(m.group(2)) + Integer.parseInt(m.group(3));
                    this.recordEvent(loc, world, minTime, maxTime);
                    return;
                }
                m = this.hourRegex.matcher(text);
                if (m.find()) {
                    int minTime = 60 * Integer.parseInt(m.group(1)) + Integer.parseInt(m.group(2));
                    int maxTime = 60 * Integer.parseInt(m.group(3)) + Integer.parseInt(m.group(4));
                    this.recordEvent(loc, world, minTime, maxTime);
                    return;
                }
                m = this.minutes.matcher(text);
                if (m.find()) {
                    int minTime = Integer.parseInt(m.group(1));
                    int maxTime = Integer.parseInt(m.group(2));
                    this.recordEvent(loc, world, minTime, maxTime);
                    return;
                }
            }
        }
    }

    public void updatePanelList() {
        log.debug("Update panel list");
        SwingUtilities.invokeLater(() -> this.shootingStarsPanel.populate(this.starData.stream().filter(this::isAllowedWorld).collect(Collectors.toList())));
    }

    @Schedule(period=5L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void updatePanels() {
        log.debug("Update panels");
        if (this.shootingStarsPanel.isOpen()) {
            SwingUtilities.invokeLater(() -> this.shootingStarsPanel.updateList());
        }
    }

    @Schedule(period=10L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void submitToAPI() {
        this.manager.submitToAPI();
    }

    @Schedule(period=5L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void attemptGetRequest() {
        log.debug("Attempt get request");
        this.hitAPI();
    }

    private boolean isInvalidKey(String sharedKey) {
        log.debug("key is valid: " + this.validKeyRegex.matcher(sharedKey).find());
        return !this.validKeyRegex.matcher(sharedKey).find();
    }

    public void hitAPI() {
        if (this.canRefresh && (this.client.getGameState() == GameState.LOGGED_IN || this.client.getGameState() == GameState.HOPPING) && !this.keyError && this.shootingStarsPanel.isOpen()) {
            this.canRefresh = false;
            this.manager.makeGetRequest();
            Timer t = new Timer();
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    log.debug("Resetting canRefresh");
                    ShootingStarsPlugin.this.canRefresh = true;
                }
            }, 30000L);
        }
    }

    private boolean isAllowedWorld(ShootingStarsData starData) {
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null) {
            return false;
        }
        net.runelite.http.api.worlds.World world = worldResult.findWorld(starData.getWorld());
        if (world == null) {
            return false;
        }
        Duration timeSinceLanded = Duration.between(Instant.ofEpochSecond(starData.getMaxTime()), Instant.now());
        if (timeSinceLanded.toMinutes() >= (long)this.config.shootingStarExpirationLength()) {
            return false;
        }
        if (this.isWorldHidden(starData)) {
            return false;
        }
        if (!this.config.shootingStarShowPvpWorlds() && world.getTypes().contains(WorldType.PVP)) {
            return false;
        }
        if (!this.config.shootingStarShowSkillTotalWorlds() && world.getTypes().contains(WorldType.SKILL_TOTAL)) {
            return false;
        }
        if (!world.getTypes().contains(WorldType.MEMBERS)) {
            return false;
        }
        return starData.getShootingStarsLocation().getConfigFunction().apply(this.config);
    }

    public int getCurrentWorld() {
        return this.client.getWorld();
    }

    public void hopTo(net.runelite.http.api.worlds.World world) {
        this.hopTo(world.getId());
    }

    public void hopTo(int worldId) {
        this.clientThread.invoke(() -> this.hop(worldId));
    }

    private void hop(int worldId) {
        assert (this.client.isClientThread());
        if (!this.config.isWorldHopperEnabled()) {
            return;
        }
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult == null) {
            return;
        }
        net.runelite.http.api.worlds.World world = worldResult.findWorld(worldId);
        if (world == null) {
            return;
        }
        World rsWorld = this.client.createWorld();
        rsWorld.setActivity(world.getActivity());
        rsWorld.setAddress(world.getAddress());
        rsWorld.setId(world.getId());
        rsWorld.setPlayerCount(world.getPlayers());
        rsWorld.setLocation(world.getLocation());
        rsWorld.setTypes(WorldUtil.toWorldTypes((EnumSet)world.getTypes()));
        String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Quick-hopping to World ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(world.getId())).append(ChatColorType.NORMAL).append("..").build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
        if (this.client.getGameState() == GameState.LOGIN_SCREEN) {
            this.client.changeWorld(rsWorld);
            return;
        }
        this.quickHopTargetWorld = rsWorld;
    }

    private void handleHop() {
        if (this.quickHopTargetWorld == null) {
            return;
        }
        if (this.client.getWidget(WidgetInfo.WORLD_SWITCHER_LIST) == null) {
            this.client.openWorldHopper();
            if (++this.displaySwitcherAttempts >= 3) {
                String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Failed to quick-hop after ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(this.displaySwitcherAttempts)).append(ChatColorType.NORMAL).append(" attempts.").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
                this.resetQuickHopper();
            }
        } else {
            this.client.hopToWorld(this.quickHopTargetWorld);
            this.resetQuickHopper();
        }
    }

    private void resetQuickHopper() {
        this.quickHopTargetWorld = null;
        this.displaySwitcherAttempts = 0;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (event.getMessage().equals("Please finish what you're doing before using the World Switcher.")) {
            this.resetQuickHopper();
        }
    }

    public void hideWorld(int world, long maxTime) {
        this.hiddenWorlds.put(world, maxTime);
        this.updatePanelList();
    }

    public boolean isWorldHidden(ShootingStarsData data) {
        return this.hiddenWorlds.containsKey(data.getWorld()) && this.hiddenWorlds.get(data.getWorld()) >= data.getMaxTime();
    }

    public void resetHiddenWorlds() {
        this.hiddenWorlds.clear();
        this.updatePanelList();
    }

    public ShootingStarsConfig getConfig() {
        return this.config;
    }

    public WorldService getWorldService() {
        return this.worldService;
    }

    public String getShootingStarPostEndpoint() {
        return this.shootingStarPostEndpoint;
    }

    public String getShootingStarGetEndpoint() {
        return this.shootingStarGetEndpoint;
    }

    public String getShootingStarsSharedKey() {
        return this.shootingStarsSharedKey;
    }

    public ArrayList<ShootingStarsData> getStarData() {
        return this.starData;
    }

    public void setStarData(ArrayList<ShootingStarsData> starData) {
        this.starData = starData;
    }

    public boolean isPostError() {
        return this.postError;
    }

    public void setPostError(boolean postError) {
        this.postError = postError;
    }

    public boolean isGetError() {
        return this.getError;
    }

    public void setGetError(boolean getError) {
        this.getError = getError;
    }

    public boolean isKeyError() {
        return this.keyError;
    }
}

