/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.shootingstars;

import com.andmcadams.shootingstars.ShootingStarsData;
import com.andmcadams.shootingstars.ShootingStarsLocation;
import com.andmcadams.shootingstars.ShootingStarsPlugin;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ShootingStarsDataManager {
    private static final Logger log = LoggerFactory.getLogger(ShootingStarsDataManager.class);
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private Gson gson;
    @Inject
    private ShootingStarsPlugin plugin;
    private List<Object> data = new ArrayList<Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeEvent(Object event) {
        ShootingStarsDataManager shootingStarsDataManager = this;
        synchronized (shootingStarsDataManager) {
            this.data.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitToAPI() {
        List<Object> temp;
        ShootingStarsDataManager shootingStarsDataManager = this;
        synchronized (shootingStarsDataManager) {
            if (this.data.isEmpty()) {
                return;
            }
            temp = this.data;
            this.data = new ArrayList<Object>();
        }
        this.makePostRequest(temp);
    }

    private ArrayList<ShootingStarsData> parseData(JsonArray j) {
        ArrayList<ShootingStarsData> l = new ArrayList<ShootingStarsData>();
        for (JsonElement jsonElement : j) {
            JsonObject jObj = jsonElement.getAsJsonObject();
            ShootingStarsData d = new ShootingStarsData(ShootingStarsLocation.getLocation(jObj.get("location").getAsInt()), jObj.get("world").getAsInt(), jObj.get("minTime").getAsLong(), jObj.get("maxTime").getAsLong());
            l.add(d);
        }
        return l;
    }

    protected void makePostRequest(List<Object> temp) {
        try {
            Request r = new Request.Builder().url(this.plugin.getShootingStarPostEndpoint()).addHeader("Authorization", this.plugin.getShootingStarsSharedKey()).post(RequestBody.create((MediaType)JSON, (String)this.gson.toJson(temp))).build();
            this.okHttpClient.newCall(r).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    log.debug("Error sending shooting star data", (Throwable)e);
                    ShootingStarsDataManager.this.plugin.setPostError(true);
                }

                public void onResponse(Call call, Response response) {
                    if (response.isSuccessful()) {
                        log.debug("Successfully sent shooting star data");
                        ShootingStarsDataManager.this.plugin.setPostError(false);
                        response.close();
                    } else {
                        log.error("Post request unsuccessful");
                        ShootingStarsDataManager.this.plugin.setPostError(true);
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            log.error("Bad URL given: " + e.getLocalizedMessage());
            this.plugin.setPostError(true);
        }
    }

    protected void makeGetRequest() {
        try {
            Request r = new Request.Builder().url(this.plugin.getShootingStarGetEndpoint()).addHeader("Authorization", this.plugin.getShootingStarsSharedKey()).build();
            this.okHttpClient.newCall(r).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    log.debug("Error retrieving shooting star data", (Throwable)e);
                    ShootingStarsDataManager.this.plugin.setGetError(true);
                }

                public void onResponse(Call call, Response response) {
                    if (response.isSuccessful()) {
                        try {
                            JsonArray j = (JsonArray)new Gson().fromJson(response.body().string(), JsonArray.class);
                            ShootingStarsDataManager.this.plugin.setStarData(ShootingStarsDataManager.this.parseData(j));
                            log.debug(j.toString());
                            ShootingStarsDataManager.this.plugin.setGetError(false);
                            ShootingStarsDataManager.this.plugin.updatePanelList();
                        }
                        catch (JsonSyntaxException | IOException e) {
                            ShootingStarsDataManager.this.plugin.setGetError(true);
                            log.error(e.getMessage());
                        }
                    } else {
                        log.error("Get request unsuccessful");
                        ShootingStarsDataManager.this.plugin.setGetError(true);
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            log.error("Bad URL given: " + e.getLocalizedMessage());
        }
    }
}

