/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.shootingstars;

import com.andmcadams.shootingstars.ShootingStarsLocation;
import java.time.Duration;
import java.time.Instant;

public class ShootingStarsData {
    private final int location;
    private final int world;
    private final long minTime;
    private final long maxTime;
    private static final String NOW_STRING = "Now";

    public ShootingStarsData(ShootingStarsLocation loc, int world, long minTime, long maxTime) {
        this.location = loc.getId();
        this.world = world;
        this.minTime = minTime;
        this.maxTime = maxTime;
    }

    public ShootingStarsLocation getShootingStarsLocation() {
        return ShootingStarsLocation.getLocation(this.location);
    }

    public boolean hasLanded() {
        Duration timeUntil = Duration.between(Instant.now(), Instant.ofEpochMilli(this.minTime * 1000L));
        return NOW_STRING.equals(this.prettyPrintTime(timeUntil));
    }

    private String prettyPrintTime(Duration d) {
        long hours = d.toHours();
        StringBuilder timeStringBuilder = new StringBuilder();
        if (hours != 0L) {
            timeStringBuilder.append(hours).append(" hr ");
        }
        long minutes = d.toMinutes() % 60L;
        if (hours == 0L && minutes <= 0L) {
            long seconds = d.getSeconds() % 60L;
            if (seconds > 0L) {
                timeStringBuilder.append(String.format("%d sec", seconds));
            } else {
                timeStringBuilder.append(NOW_STRING);
            }
        } else {
            timeStringBuilder.append(String.format("%d min", minutes));
        }
        return timeStringBuilder.toString();
    }

    public String getLandingTime() {
        String minTimeString = this.prettyPrintTime(Duration.between(Instant.now(), Instant.ofEpochMilli(this.minTime * 1000L)));
        String maxTimeString = this.prettyPrintTime(Duration.between(Instant.now(), Instant.ofEpochMilli(this.maxTime * 1000L)));
        if (NOW_STRING.equals(maxTimeString)) {
            return NOW_STRING;
        }
        return minTimeString + " - " + maxTimeString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShootingStarsData)) {
            return false;
        }
        ShootingStarsData other = (ShootingStarsData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLocation() != other.getLocation()) {
            return false;
        }
        if (this.getWorld() != other.getWorld()) {
            return false;
        }
        if (this.getMinTime() != other.getMinTime()) {
            return false;
        }
        return this.getMaxTime() == other.getMaxTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShootingStarsData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLocation();
        result = result * 59 + this.getWorld();
        long $minTime = this.getMinTime();
        result = result * 59 + (int)($minTime >>> 32 ^ $minTime);
        long $maxTime = this.getMaxTime();
        result = result * 59 + (int)($maxTime >>> 32 ^ $maxTime);
        return result;
    }

    public String toString() {
        return "ShootingStarsData(location=" + this.getLocation() + ", world=" + this.getWorld() + ", minTime=" + this.getMinTime() + ", maxTime=" + this.getMaxTime() + ")";
    }

    public int getLocation() {
        return this.location;
    }

    public int getWorld() {
        return this.world;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }
}

