/*
 * Decompiled with CFR 0.152.
 */
package com.andmcadams.shootingstars;

import com.andmcadams.shootingstars.ui.ShootingStarsPanelType;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="shootingstar")
public interface ShootingStarsConfig
extends Config {
    public static final String SHOOTING_STAR_POST_ENDPOINT_KEYNAME = "post endpoint";
    public static final String SHOOTING_STAR_GET_ENDPOINT_KEYNAME = "get endpoint";
    public static final String SHOOTING_STAR_SHARED_KEY_KEYNAME = "password";
    public static final String SHOOTING_STAR_EXPIRATION_LENGTH = "expiration";
    public static final String SHOOTING_STAR_PANEL_CLASS = "panelclass";
    public static final String SHOOTING_STAR_SHOW_PVP_WORLDS_KEYNAME = "pvp worlds";
    public static final String SHOOTING_STAR_SHOW_ASGARNIA_KEYNAME = "asgarnia";
    public static final String SHOOTING_STAR_SHOW_KARAMJA_KEYNAME = "karamja";
    public static final String SHOOTING_STAR_SHOW_FELDIP_HILLS_KEYNAME = "feldip hills";
    public static final String SHOOTING_STAR_SHOW_FOSSIL_ISLAND_KEYNAME = "fossil island";
    public static final String SHOOTING_STAR_SHOW_FREMENNIK_KEYNAME = "fremennik";
    public static final String SHOOTING_STAR_SHOW_KOUREND_KEYNAME = "kourend";
    public static final String SHOOTING_STAR_SHOW_KANDARIN_KEYNAME = "kandarin";
    public static final String SHOOTING_STAR_SHOW_KEBOS_KEYNAME = "kebos";
    public static final String SHOOTING_STAR_SHOW_KHARIDIAN_DESERT_KEYNAME = "desert";
    public static final String SHOOTING_STAR_SHOW_MISTHALIN_KEYNAME = "misthalin";
    public static final String SHOOTING_STAR_SHOW_MORYTANIA_KEYNAME = "morytania";
    public static final String SHOOTING_STAR_SHOW_PISCATORIS_KEYNAME = "piscatoris";
    public static final String SHOOTING_STAR_SHOW_TIRANNWN_KEYNAME = "tirannwn";
    public static final String SHOOTING_STAR_SHOW_WILDERNESS_KEYNAME = "wilderness";
    public static final String SHOOTING_STAR_SHOW_SKILL_TOTAL_KEYNAME = "skill total";
    public static final String SHOOTING_STAR_SHOW_SIDEBAR_ICON = "sidebar icon";
    @ConfigSection(name="World Toggles", description="Settings to show and hide certain types of worlds from the list of scouted worlds", position=5)
    public static final String toggleSection = "World Toggles";

    @ConfigItem(keyName="post endpoint", position=0, name="POST endpoint", description="Web endpoint to post star data to")
    default public String shootingStarPostEndpointConfig() {
        return "https://z9smj03u77.execute-api.us-east-1.amazonaws.com/stars";
    }

    @ConfigItem(keyName="get endpoint", position=1, name="GET endpoint", description="Web endpoint to get star data from")
    default public String shootingStarGetEndpointConfig() {
        return "https://z9smj03u77.execute-api.us-east-1.amazonaws.com/stars";
    }

    @ConfigItem(keyName="password", position=2, name="Key", description="A keyword to use to share stars with friends. Must be 1-10 alpha characters")
    default public String shootingStarSharedKeyConfig() {
        return "global";
    }

    @ConfigItem(keyName="expiration", position=2, name="Show landed stars for", description="How many minutes landed stars should remain listed in the side panel<br>Different APIs may return less than the maximum of 120 minutes")
    @Range(max=120)
    @Units(value=" mins")
    default public int shootingStarExpirationLength() {
        return 5;
    }

    @ConfigItem(keyName="panelclass", position=3, name="Stars Panel", description="Choose the shooting stars panel implementation")
    default public ShootingStarsPanelType shootingStarsPanelType() {
        return ShootingStarsPanelType.CONDENSED;
    }

    @ConfigItem(keyName="worldHopperEnabled", position=4, name="Double click to Hop", description="Enables double clicking worlds in the side view panels to quick-hop to them")
    default public boolean isWorldHopperEnabled() {
        return true;
    }

    @ConfigItem(keyName="pvp worlds", position=3, name="PVP worlds", description="Show scouted PVP worlds", section="World Toggles")
    default public boolean shootingStarShowPvpWorlds() {
        return false;
    }

    @ConfigItem(keyName="wilderness", position=4, name="Wilderness", description="Show scouted Wilderness worlds", section="World Toggles")
    default public boolean shootingStarShowWildernessWorlds() {
        return false;
    }

    @ConfigItem(keyName="skill total", position=5, name="Skill Total worlds", description="Show scouted Skill Total worlds", section="World Toggles")
    default public boolean shootingStarShowSkillTotalWorlds() {
        return true;
    }

    @ConfigItem(keyName="asgarnia", position=6, name="Asgarnia", description="Show scouted Asgarnia worlds", section="World Toggles")
    default public boolean shootingStarShowAsgarniaWorlds() {
        return true;
    }

    @ConfigItem(keyName="karamja", position=7, name="Crandor and Karamja", description="Show scouted Crandor and Karamja worlds", section="World Toggles")
    default public boolean shootingStarShowKaramjaWorlds() {
        return true;
    }

    @ConfigItem(keyName="feldip hills", position=8, name="Feldip Hills and Isle of Souls", description="Show scouted Feldip Hills and Isle of Souls worlds", section="World Toggles")
    default public boolean shootingStarShowFeldipWorlds() {
        return true;
    }

    @ConfigItem(keyName="fossil island", position=9, name="Fossil Island and Mos Le'Harmless", description="Show scouted Fossil Island and Mos Le'Harmless worlds", section="World Toggles")
    default public boolean shootingStarShowFossilIslandWorlds() {
        return true;
    }

    @ConfigItem(keyName="fremennik", position=10, name="Fremennik Lands and Lunar Isle", description="Show scouted Fremennik Lands and Lunar Isle worlds", section="World Toggles")
    default public boolean shootingStarShowFremennikWorlds() {
        return true;
    }

    @ConfigItem(keyName="kourend", position=11, name="Great Kourend", description="Show scouted Great Kourend worlds", section="World Toggles")
    default public boolean shootingStarShowKourendWorlds() {
        return true;
    }

    @ConfigItem(keyName="kandarin", position=12, name="Kandarin", description="Show scouted Kandarin worlds", section="World Toggles")
    default public boolean shootingStarShowKandarinWorlds() {
        return true;
    }

    @ConfigItem(keyName="kebos", position=13, name="Kebos Lowlands", description="Show scouted Kebos Lowlands worlds", section="World Toggles")
    default public boolean shootingStarShowKebosWorlds() {
        return true;
    }

    @ConfigItem(keyName="desert", position=14, name="Kharidian Desert", description="Show scouted Kharidian Desert worlds", section="World Toggles")
    default public boolean shootingStarShowDesertWorlds() {
        return true;
    }

    @ConfigItem(keyName="misthalin", position=15, name="Misthalin", description="Show scouted Misthalin worlds", section="World Toggles")
    default public boolean shootingStarShowMisthalinWorlds() {
        return true;
    }

    @ConfigItem(keyName="morytania", position=16, name="Morytania", description="Show scouted Morytania worlds", section="World Toggles")
    default public boolean shootingStarShowMorytaniaWorlds() {
        return true;
    }

    @ConfigItem(keyName="piscatoris", position=17, name="Piscatoris and the Gnome Stronghold", description="Show scouted Piscatoris and Gnome Stronghold worlds", section="World Toggles")
    default public boolean shootingStarShowPiscatorisWorlds() {
        return true;
    }

    @ConfigItem(keyName="tirannwn", position=18, name="Tirannwn", description="Show scouted Tirannwn worlds", section="World Toggles")
    default public boolean shootingStarShowTirannwnWorlds() {
        return true;
    }

    @ConfigItem(keyName="sidebar icon", position=19, name="Show side panel", description="Show the side panel with landing times")
    default public boolean showSidebarIcon() {
        return true;
    }
}

