/*
 * Decompiled with CFR 0.152.
 */
package com.questsplits.overlays;

import com.questsplits.QuestSplitsPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.inject.Inject;
import net.runelite.api.widgets.Widget;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

public class QuestSplitsOverlay
extends OverlayPanel {
    private final QuestSplitsPlugin plugin;
    private Widget[] textFields;

    @Inject
    public QuestSplitsOverlay(QuestSplitsPlugin plugin, Widget[] textFields) {
        this.plugin = plugin;
        this.setMovable(true);
        this.setPriority(OverlayPriority.HIGHEST);
    }

    public Widget[] getTextFields() {
        return this.textFields;
    }

    public void setTextFields(Widget[] textFields) {
        this.textFields = textFields;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.textFields == null || !this.plugin.getConfig().showSplits()) {
            return super.render(graphics);
        }
        this.panelComponent.setPreferredSize(new Dimension(300, 100));
        this.panelComponent.setPreferredLocation(new Point(0, 0));
        for (String time : this.plugin.getTimes().keySet()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left(time).right(this.plugin.getTimes().get(time) + " " + this.plugin.getBestTimes().get(time)).build());
        }
        return super.render(graphics);
    }
}

