/*
 * Decompiled with CFR 0.152.
 */
package com.questsplits;

import com.google.inject.Provides;
import com.questsplits.QuestSplitsConfig;
import com.questsplits.overlays.QuestSplitsOverlay;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.events.WorldChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Quest Splits")
public class QuestSplitsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(QuestSplitsPlugin.class);
    private int widgetId = 46596101;
    private boolean worldChange = false;
    private List<String> inventoryItems = new ArrayList<String>();
    private Queue<String> keyItems;
    private Map<String, String> times;
    private Map<String, String> bestTimes = new LinkedHashMap<String, String>();
    private Widget[] textFields;
    private QuestSplitsOverlay overlay = new QuestSplitsOverlay(this, this.textFields);
    private Widget topWidget;
    @Inject
    private Client client;
    @Inject
    private QuestSplitsConfig config;
    @Inject
    private OverlayManager overlayManager;

    protected void startUp() throws Exception {
        log.info("Example started!");
    }

    protected void shutDown() throws Exception {
        log.info("Example stopped!");
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (this.client.getWidget(this.widgetId) != null) {
            this.topWidget = this.client.getWidget(this.widgetId).getParent();
            this.textFields = this.client.getWidget(this.widgetId).getChildren();
            this.overlay.setTextFields(this.textFields);
            this.overlayManager.add((Overlay)this.overlay);
            if (this.keyItems == null || this.times == null) {
                this.changeKeyItems();
            }
            this.worldChange = false;
        } else if (!this.worldChange) {
            this.keyItems = null;
        }
    }

    @Subscribe
    public void onWorldChanged(WorldChanged worldChanged) {
        this.worldChange = true;
    }

    @Subscribe
    public void onGameTick(GameTick gameStateChanged) {
        if (this.client.getWidget(this.widgetId) == null) {
            return;
        }
        this.textFields = this.client.getWidget(this.widgetId).getChildren();
        this.overlay.setTextFields(this.textFields);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        this.inventoryItems = new ArrayList<String>();
        if (itemContainerChanged.getContainerId() != InventoryID.INVENTORY.getId() && itemContainerChanged.getContainerId() != InventoryID.EQUIPMENT.getId() || this.keyItems == null) {
            return;
        }
        for (Item item : itemContainerChanged.getItemContainer().getItems()) {
            this.addItemToInventory(item);
        }
        for (String item : this.inventoryItems) {
            String[] splits;
            String[] dupeCheck = item.split(";");
            if (!dupeCheck[0].equalsIgnoreCase(this.keyItems.peek()) && !item.equalsIgnoreCase(this.keyItems.peek())) continue;
            String foundItem = this.keyItems.remove().toLowerCase();
            String time = this.textFields[2].getText();
            if (foundItem.contains(";")) {
                this.times.put(item.toLowerCase(), time);
            } else {
                this.times.put(dupeCheck[0].toLowerCase(), time);
            }
            StringBuilder newSplits = new StringBuilder();
            for (String split : splits = this.config.getSplitItems().split(",")) {
                String[] seperated = split.split("_");
                if (seperated[0].equalsIgnoreCase(foundItem) && (this.timeToInt(seperated[1]) > this.timeToInt(time) || this.timeToInt(seperated[1]) == 0)) {
                    seperated[1] = time;
                    this.bestTimes.put(dupeCheck[0].toLowerCase(), time);
                }
                if (foundItem.toLowerCase().endsWith(seperated[0].toLowerCase()) && (this.timeToInt(seperated[1]) > this.timeToInt(time) || this.timeToInt(seperated[1]) == 0)) {
                    seperated[1] = time;
                    this.bestTimes.put(item.toLowerCase(), time);
                }
                newSplits.append(seperated[0]).append("_").append(seperated[1]);
                if (split.equals(splits[splits.length - 1])) continue;
                newSplits.append(",");
            }
            this.config.setSplitItems(newSplits.toString());
            return;
        }
    }

    @Provides
    QuestSplitsConfig provideConfig(ConfigManager configManager) {
        return (QuestSplitsConfig)configManager.getConfig(QuestSplitsConfig.class);
    }

    void changeKeyItems() {
        this.keyItems = new LinkedList<String>();
        this.bestTimes = new LinkedHashMap<String, String>();
        String[] items = this.config.getSplitItems().split(",");
        for (String item : items) {
            String[] splitted = item.split("_");
            try {
                int id = Integer.parseInt(splitted[0]);
                splitted[0] = this.client.getItemDefinition(id).getName().toLowerCase() + ";" + id;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.keyItems.add(splitted[0]);
            this.bestTimes.put(splitted[0].toLowerCase(), splitted[1]);
        }
        this.times = new LinkedHashMap<String, String>();
        for (String keyItem : this.keyItems) {
            this.times.put(keyItem.toLowerCase(), "0:00.00");
        }
    }

    void addItemToInventory(Item item) {
        String newItem = this.client.getItemDefinition(item.getId()).getName() + ";" + item.getId();
        if (!this.inventoryItems.contains(newItem) && !Objects.equals(newItem, "null")) {
            this.inventoryItems.add(newItem);
        }
    }

    public Map<String, String> getTimes() {
        return this.times;
    }

    public Map<String, String> getBestTimes() {
        return this.bestTimes;
    }

    int timeToInt(String time) {
        String result = time.replace(":", "");
        result = result.replace(".", "");
        return Integer.parseInt(result);
    }

    public QuestSplitsConfig getConfig() {
        return this.config;
    }
}

