/*
 * Decompiled with CFR 0.152.
 */
package com.camerakeys;

import com.camerakeys.CameraKeysConfig;
import com.camerakeys.CameraKeysListener;
import com.camerakeys.CameraKeysOverlay;
import com.google.inject.Provides;
import java.awt.Color;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.keyremapping.KeyRemappingPlugin;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Camera Keys", description="Adds hotkeys for camera zoom and direction", tags={"Camera, Hotkeys, Accessibility"})
@PluginDependency(value=KeyRemappingPlugin.class)
public class CameraKeysPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CameraKeysPlugin.class);
    private static final String PRESS_ENTER_TO_CHAT = "Press Enter to Chat...";
    private static final String SCRIPT_EVENT_SET_CHATBOX_INPUT = "setChatboxInput";
    private static final String SCRIPT_EVENT_BLOCK_CHAT_INPUT = "blockChatInput";
    private static final int ZOOM_CANCEL_LOCKOUT_START_TICKS = 15;
    private static final int ZOOM_CANCEL_THRESHOLD = 50;
    private static final String KEYREMAPPINGPLUGIN_NAME = "keyremappingplugin";
    private static final int COMPASS_SCRIPT_ID = 1050;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private KeyManager keyManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CameraKeysListener cameraKeysListener;
    @Inject
    private CameraKeysConfig cameraKeysConfig;
    @Inject
    private CameraKeysOverlay cameraKeysOverlay;
    @Inject
    private KeyRemappingPlugin keyRemappingPlugin;
    private boolean typing;
    private ChatInputHandlingState chatInputHandlingState = ChatInputHandlingState.DISABLED;
    private ZoomState zoomState = ZoomState.OFF;
    private Integer prevZoomLevel = null;
    private Integer newZoomLevel = null;
    private Integer zoomCancelLockout = null;

    protected void startUp() throws Exception {
        ChatInputHandlingState chatInputHandlingState = this.chatInputHandlingState = this.pluginManager.isPluginEnabled((Plugin)this.keyRemappingPlugin) ? ChatInputHandlingState.DISABLED : ChatInputHandlingState.ENABLED;
        if (this.chatInputHandlingState == ChatInputHandlingState.ENABLED) {
            this.clientThread.invoke(() -> {
                if (this.client.getGameState() == GameState.LOGGED_IN) {
                    this.typing = false;
                    this.lockChat();
                    this.client.setVarcStrValue(335, "");
                }
            });
        } else {
            String chatboxInputText;
            int index;
            Widget chatboxInput = this.client.getWidget(WidgetInfo.CHATBOX_INPUT);
            this.typing = chatboxInput != null ? ((index = (chatboxInputText = chatboxInput.getText()).indexOf(58)) > -1 ? !chatboxInputText.substring(index).equals(": Press Enter to Chat...") : false) : false;
        }
        this.keyManager.registerKeyListener((KeyListener)this.cameraKeysListener);
    }

    protected void shutDown() throws Exception {
        if (this.chatInputHandlingState == ChatInputHandlingState.ENABLED) {
            this.clientThread.invoke(() -> {
                if (this.client.getGameState() == GameState.LOGGED_IN) {
                    if (this.zoomState == ZoomState.ON) {
                        log.debug("Zoom level change: " + this.prevZoomLevel + " <-- " + this.getZoom());
                        this.clientThread.invoke(() -> this.client.runScript(new Object[]{42, this.prevZoomLevel, this.prevZoomLevel}));
                    }
                    this.unlockChat();
                }
            });
        }
        this.overlayManager.remove((Overlay)this.cameraKeysOverlay);
        this.keyManager.unregisterKeyListener((KeyListener)this.cameraKeysListener);
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent scriptCallbackEvent) {
        if (this.chatInputHandlingState == ChatInputHandlingState.ENABLED) {
            switch (scriptCallbackEvent.getEventName()) {
                case "setChatboxInput": {
                    Widget chatboxInput = this.client.getWidget(WidgetInfo.CHATBOX_INPUT);
                    if (chatboxInput == null || this.typing) break;
                    this.setChatboxWidgetInput(chatboxInput, PRESS_ENTER_TO_CHAT);
                    break;
                }
                case "blockChatInput": {
                    if (this.typing) break;
                    int[] intStack = this.client.getIntStack();
                    int intStackSize = this.client.getIntStackSize();
                    intStack[intStackSize - 1] = 1;
                }
            }
        }
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        this.checkForZoomUpdate();
        this.checkForZoomCancel();
        this.checkForChatLockUpdate();
        this.checkForOverlayUpdate();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        this.checkForKeyRemappingPluginChange(configChanged);
    }

    boolean chatboxFocused() {
        Widget chatboxParent = this.client.getWidget(WidgetInfo.CHATBOX_PARENT);
        if (chatboxParent == null || chatboxParent.getOnKeyListener() == null) {
            return false;
        }
        Widget worldMapSearch = this.client.getWidget(WidgetInfo.WORLD_MAP_SEARCH);
        return worldMapSearch == null || this.client.getVarcIntValue(190) != 1;
    }

    boolean isDialogOpen() {
        return this.isHidden(WidgetInfo.CHATBOX_MESSAGES) || this.isHidden(WidgetInfo.CHATBOX_TRANSPARENT_LINES) || !this.isHidden(WidgetInfo.BANK_PIN_CONTAINER);
    }

    private boolean isHidden(WidgetInfo widgetInfo) {
        Widget w = this.client.getWidget(widgetInfo);
        return w == null || w.isSelfHidden();
    }

    private int getZoom() {
        return this.client.getVarcIntValue(73);
    }

    void lockChat() {
        Widget chatboxInput = this.client.getWidget(WidgetInfo.CHATBOX_INPUT);
        if (chatboxInput != null) {
            if (this.chatInputHandlingState == ChatInputHandlingState.ENABLE) {
                this.chatInputHandlingState = ChatInputHandlingState.ENABLED;
            }
            this.setChatboxWidgetInput(chatboxInput, PRESS_ENTER_TO_CHAT);
        }
    }

    void unlockChat() {
        Widget chatboxInput = this.client.getWidget(WidgetInfo.CHATBOX_INPUT);
        boolean isChatboxTransparent = this.client.isResized() && this.client.getVarcIntValue(4608) == 1;
        Color textColor = isChatboxTransparent ? JagexColors.CHAT_TYPED_TEXT_TRANSPARENT_BACKGROUND : JagexColors.CHAT_TYPED_TEXT_OPAQUE_BACKGROUND;
        this.setChatboxWidgetInput(chatboxInput, ColorUtil.wrapWithColorTag((String)(this.client.getVarcStrValue(335) + "*"), (Color)textColor));
    }

    private void setChatboxWidgetInput(Widget widget, String input) {
        String text = widget.getText();
        int idx = text.indexOf(58);
        if (idx != -1) {
            String newText = text.substring(0, idx) + ": " + input;
            widget.setText(newText);
        }
    }

    void zoom(keyState state) {
        switch (this.cameraKeysConfig.getActivationType()) {
            case HOLD: {
                this.zoomHold(state);
                break;
            }
            case TOGGLE: {
                this.zoomToggle(state);
                break;
            }
            case SET: {
                this.zoomSet(state);
            }
        }
    }

    private void zoomHold(keyState state) {
        switch (state) {
            case PRESSED: {
                this.zoomState = ZoomState.ZOOM;
                break;
            }
            case RELEASED: {
                if (this.zoomState != ZoomState.ON) break;
                this.zoomState = ZoomState.RESET;
            }
        }
    }

    private void zoomToggle(keyState state) {
        block0 : switch (state) {
            case PRESSED: {
                switch (this.zoomState) {
                    case OFF: {
                        this.zoomState = ZoomState.ZOOM;
                        break block0;
                    }
                    case ON: {
                        this.zoomState = ZoomState.RESET;
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private void zoomSet(keyState state) {
        switch (state) {
            case PRESSED: {
                this.zoomState = ZoomState.SET;
                break;
            }
        }
    }

    void setCompassDirection(CardinalDirections direction) {
        this.clientThread.invoke(() -> this.client.runScript(new Object[]{1050, direction.value}));
    }

    private void checkForZoomCancel() {
        if (this.zoomState == ZoomState.ON && this.zoomCancelLockout != null && this.zoomCancelLockout <= 0) {
            if (this.newZoomLevel != null && Math.abs(this.getZoom() - this.newZoomLevel) > 50) {
                if (this.newZoomLevel != null && Math.abs(this.getZoom() - this.newZoomLevel) > 50) {
                    this.zoomState = ZoomState.OFF;
                    log.debug("zoom canceled by users set point. Target Zoom: " + this.newZoomLevel + " User Zoom: " + this.getZoom());
                }
            } else {
                Integer n = this.zoomCancelLockout;
                Integer n2 = this.zoomCancelLockout = Integer.valueOf(this.zoomCancelLockout - 1);
            }
        }
    }

    private void checkForChatLockUpdate() {
        if (this.chatInputHandlingState == ChatInputHandlingState.ENABLE) {
            String chatboxInputText;
            int index;
            Color textColor;
            this.client.setVarcStrValue(335, "");
            Widget chatboxInput = this.client.getWidget(WidgetInfo.CHATBOX_INPUT);
            boolean isChatboxTransparent = this.client.isResized() && this.client.getVarcIntValue(4608) == 1;
            Color color = textColor = isChatboxTransparent ? JagexColors.CHAT_TYPED_TEXT_TRANSPARENT_BACKGROUND : JagexColors.CHAT_TYPED_TEXT_OPAQUE_BACKGROUND;
            if (chatboxInput != null && (index = (chatboxInputText = chatboxInput.getText()).indexOf(58)) > -1 && chatboxInputText.substring(index).equals(": " + ColorUtil.wrapWithColorTag((String)"*", (Color)textColor))) {
                this.lockChat();
            }
        }
    }

    private void checkForOverlayUpdate() {
        switch (this.zoomState) {
            case OFF: {
                this.overlayManager.remove((Overlay)this.cameraKeysOverlay);
                break;
            }
            case ON: {
                this.overlayManager.add((Overlay)this.cameraKeysOverlay);
                break;
            }
        }
    }

    private void checkForZoomUpdate() {
        switch (this.zoomState) {
            case ZOOM: {
                this.prevZoomLevel = this.getZoom();
                this.clientThread.invoke(() -> this.client.runScript(new Object[]{42, this.cameraKeysConfig.zoom(), this.cameraKeysConfig.zoom()}));
                this.newZoomLevel = this.getZoom();
                log.debug("Zoom level change: " + this.prevZoomLevel + " --> " + this.newZoomLevel);
                this.zoomCancelLockout = 15;
                this.zoomState = ZoomState.ON;
                break;
            }
            case SET: {
                this.prevZoomLevel = this.getZoom();
                this.clientThread.invoke(() -> this.client.runScript(new Object[]{42, this.cameraKeysConfig.zoom(), this.cameraKeysConfig.zoom()}));
                log.debug("Zoom level change: " + this.prevZoomLevel + " --> " + this.getZoom());
                this.zoomState = ZoomState.OFF;
                break;
            }
            case RESET: {
                log.debug("Zoom level change: " + this.prevZoomLevel + " <-- " + this.getZoom());
                this.clientThread.invoke(() -> this.client.runScript(new Object[]{42, this.prevZoomLevel, this.prevZoomLevel}));
                this.zoomState = ZoomState.OFF;
                this.zoomCancelLockout = null;
                this.prevZoomLevel = null;
                this.newZoomLevel = null;
                break;
            }
        }
    }

    private void checkForKeyRemappingPluginChange(ConfigChanged configChanged) {
        if (Objects.equals(configChanged.getKey(), KEYREMAPPINGPLUGIN_NAME)) {
            if (Objects.equals(configChanged.getNewValue(), "false")) {
                log.debug("Key Remapping Plugin Disabled. Taking over the handling of the chat box");
                this.chatInputHandlingState = ChatInputHandlingState.ENABLE;
            } else {
                log.debug("Key Remapping Plugin Enabled. Stopping the handling of the chat box.");
                this.chatInputHandlingState = ChatInputHandlingState.DISABLED;
            }
        }
    }

    @Provides
    CameraKeysConfig provideConfig(ConfigManager configManager) {
        return (CameraKeysConfig)configManager.getConfig(CameraKeysConfig.class);
    }

    boolean isTyping() {
        return this.typing;
    }

    void setTyping(boolean typing) {
        this.typing = typing;
    }

    ChatInputHandlingState getChatInputHandlingState() {
        return this.chatInputHandlingState;
    }

    private static enum ZoomState {
        ON,
        ZOOM,
        SET,
        RESET,
        OFF;

    }

    static enum CardinalDirections {
        NORTH(1),
        EAST(2),
        SOUTH(3),
        WEST(4);

        private final int value;

        private CardinalDirections(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    static enum ChatInputHandlingState {
        DISABLED,
        ENABLE,
        ENABLED;

    }

    static enum keyState {
        PRESSED,
        RELEASED;

    }
}

