/*
 * Decompiled with CFR 0.152.
 */
package com.camerakeys;

import com.camerakeys.CameraKeysConfig;
import com.camerakeys.CameraKeysPlugin;
import com.google.inject.Inject;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.util.ImageUtil;

public class CameraKeysOverlay
extends OverlayPanel {
    private final BufferedImage zoomIcon;
    private final CameraKeysConfig config;

    @Inject
    private CameraKeysOverlay(CameraKeysConfig config, CameraKeysPlugin plugin) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.CANVAS_TOP_RIGHT);
        this.config = config;
        this.setPriority(OverlayPriority.LOW);
        this.zoomIcon = ImageUtil.loadImageResource(CameraKeysPlugin.class, (String)"zoomIcon.png");
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.isZoomIndicatorEnabled()) {
            this.panelComponent.getChildren().clear();
            ImageComponent imageComponent = new ImageComponent(this.zoomIcon);
            this.panelComponent.getChildren().add(imageComponent);
            return super.render(graphics);
        }
        return null;
    }
}

