/*
 * Decompiled with CFR 0.152.
 */
package com.camerakeys;

import com.camerakeys.CameraKeysConfig;
import com.camerakeys.CameraKeysPlugin;
import com.google.common.base.Strings;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.input.KeyListener;

class CameraKeysListener
implements KeyListener {
    private final Set<Integer> blockedChars = new HashSet<Integer>();
    @Inject
    private CameraKeysPlugin plugin;
    @Inject
    private CameraKeysConfig config;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;

    CameraKeysListener() {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (!this.plugin.chatboxFocused()) {
            return;
        }
        if (!this.plugin.isTyping()) {
            if (!this.blockedChars.contains(e.getKeyCode()) && !this.plugin.isDialogOpen()) {
                if (this.config.zoomKey().matches(e)) {
                    this.plugin.zoom(CameraKeysPlugin.keyState.PRESSED);
                }
                if (this.config.northKey().matches(e)) {
                    this.plugin.setCompassDirection(CameraKeysPlugin.CardinalDirections.NORTH);
                }
                if (this.config.eastKey().matches(e)) {
                    this.plugin.setCompassDirection(CameraKeysPlugin.CardinalDirections.EAST);
                }
                if (this.config.southKey().matches(e)) {
                    this.plugin.setCompassDirection(CameraKeysPlugin.CardinalDirections.SOUTH);
                }
                if (this.config.westKey().matches(e)) {
                    this.plugin.setCompassDirection(CameraKeysPlugin.CardinalDirections.WEST);
                }
            }
            switch (e.getKeyCode()) {
                case 10: 
                case 47: 
                case 513: {
                    this.plugin.setTyping(true);
                    if (this.plugin.getChatInputHandlingState() != CameraKeysPlugin.ChatInputHandlingState.ENABLED) break;
                    this.clientThread.invoke(this.plugin::unlockChat);
                }
            }
            this.blockedChars.add(e.getKeyCode());
        } else {
            switch (e.getKeyCode()) {
                case 27: {
                    this.plugin.setTyping(false);
                    if (this.plugin.getChatInputHandlingState() != CameraKeysPlugin.ChatInputHandlingState.ENABLED && this.plugin.getChatInputHandlingState() != CameraKeysPlugin.ChatInputHandlingState.ENABLE) break;
                    e.consume();
                    this.clientThread.invoke(() -> {
                        this.client.setVarcStrValue(335, "");
                        this.client.setVarcStrValue(335, "");
                        this.plugin.lockChat();
                    });
                    break;
                }
                case 10: {
                    this.plugin.setTyping(false);
                    if (this.plugin.getChatInputHandlingState() != CameraKeysPlugin.ChatInputHandlingState.ENABLED) {
                        if (this.plugin.getChatInputHandlingState() != CameraKeysPlugin.ChatInputHandlingState.ENABLE) break;
                    }
                    this.clientThread.invoke(this.plugin::lockChat);
                    break;
                }
                case 8: {
                    if (!Strings.isNullOrEmpty((String)this.client.getVarcStrValue(335))) break;
                    this.plugin.setTyping(false);
                    if (this.plugin.getChatInputHandlingState() != CameraKeysPlugin.ChatInputHandlingState.ENABLED) {
                        if (this.plugin.getChatInputHandlingState() != CameraKeysPlugin.ChatInputHandlingState.ENABLE) break;
                    }
                    this.clientThread.invoke(this.plugin::lockChat);
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.config.zoomKey().matches(e)) {
            this.plugin.zoom(CameraKeysPlugin.keyState.RELEASED);
        }
        this.blockedChars.remove(e.getKeyCode());
    }
}

