/*
 * Decompiled with CFR 0.152.
 */
package com.camerakeys;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.ModifierlessKeybind;
import net.runelite.client.config.Range;

@ConfigGroup(value="camerakeys")
public interface CameraKeysConfig
extends Config {
    @ConfigSection(name="Zoom Key", description="Zoom Key settings", position=0, closedByDefault=false)
    public static final String ZoomKeySection = "ZoomKey";
    @ConfigSection(name="Compass Keys", description="Compass Key Options", position=1, closedByDefault=false)
    public static final String CompassKeySection = "CompassKeys";

    @ConfigItem(keyName="zoom", name="Zoom level", description="Zoom level to change to", section="ZoomKey", position=1)
    @Range(min=-272, max=1300)
    default public int zoom() {
        return 0;
    }

    @ConfigItem(position=2, keyName="zoomKey", name="Zoom Key", section="ZoomKey", description="The key that activates/toggles zoom level")
    default public ModifierlessKeybind zoomKey() {
        return new ModifierlessKeybind(67, 0);
    }

    @ConfigItem(position=3, keyName="activationType", name="Activation Type", section="ZoomKey", description="The activation type of the zoom level key")
    default public ActivationType getActivationType() {
        return ActivationType.HOLD;
    }

    @ConfigItem(position=4, keyName="zoomIndicator", name="Zoom Icon", section="ZoomKey", description="Displays an icon when the zoom is in effect")
    default public boolean isZoomIndicatorEnabled() {
        return true;
    }

    @ConfigItem(position=0, keyName="northKey", name="North", section="CompassKeys", description="The key that faces the camera north")
    default public ModifierlessKeybind northKey() {
        return new ModifierlessKeybind(78, 0);
    }

    @ConfigItem(position=1, keyName="eastKey", name="East", section="CompassKeys", description="The key that faces the camera east")
    default public ModifierlessKeybind eastKey() {
        return new ModifierlessKeybind(0, 0);
    }

    @ConfigItem(position=1, keyName="southKey", name="South", section="CompassKeys", description="The key that faces the camera south")
    default public ModifierlessKeybind southKey() {
        return new ModifierlessKeybind(0, 0);
    }

    @ConfigItem(position=1, keyName="westKey", name="West", section="CompassKeys", description="The key that faces the camera west")
    default public ModifierlessKeybind westKey() {
        return new ModifierlessKeybind(0, 0);
    }

    public static enum ActivationType {
        HOLD("Hold"),
        TOGGLE("Toggle"),
        SET("Set");

        private final String value;

        public String toString() {
            return this.value;
        }

        private ActivationType(String value) {
            this.value = value;
        }
    }
}

